/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert;

import com.huawei.ism.drm.cert.CertificateDockingWidget;
import com.huawei.ism.drm.cert.sdk.service.ICertificateManagementService;
import com.huawei.ism.drm.cert.sdk.service.ICertificateManagementWidget;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cert.OpenStackCertificateConstants;
import com.huawei.ism.drm.openstack.cert.task.OpenStackCertificateKeepAliveTask;
import com.huawei.ism.drm.openstack.cert.task.OpenStackCertificateRegisterTask;
import com.huawei.ism.drm.openstack.cert.task.OpenStackQueryCrlTask;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.resource.authentication.CertificateCache;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class OpenStackCertManagementService
implements ICertificateManagementService {
    private static final Log logger = LogFactory.getInstance(OpenStackCertManagementService.class);

    public List<String> getCertificateSummaryCategories() {
        return Arrays.asList("default", "hcs");
    }

    public boolean available() {
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.info((Object)"certificate server url is empty, certificate management is not supported.");
            return false;
        }
        logger.info((Object)"certificate management is supported.");
        return true;
    }

    public List<ICertificateManagementWidget> getCertificateManagementWidgets() {
        logger.info((Object)"getCertificateManagementWidgets");
        return Arrays.asList(new CertificateDockingWidget((ICertificateManagementService)this, OpenStackCertificateRegisterTask::new, "once:startup"), new CertificateDockingWidget((ICertificateManagementService)this, OpenStackCertificateKeepAliveTask::new, "cron:0 0 0 * * ?"), new CertificateDockingWidget((ICertificateManagementService)this, OpenStackQueryCrlTask::new, "once:startup"), new CertificateDockingWidget((ICertificateManagementService)this, OpenStackQueryCrlTask::new, "cron:20 0/10 * * * ?"));
    }

    public void notifyCertificateStatus(String taskId, String updateStatus, String details, String certName) {
        logger.info((Object)("update certificate result, taskId: " + taskId + ", status: " + updateStatus + ", detail: " + details));
        HashMap<String, String> status = new HashMap<String, String>();
        status.put("11111111", "failed");
        status.put("00000000", "success");
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        logger.debug((Object)("certificate, url: " + urlStr));
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)"notify certificate status, but server url is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject updateStatusJo = new JSONObject();
        updateStatusJo.put((Object)"taskId", (Object)taskId);
        updateStatusJo.put((Object)"updateStatus", status.get(updateStatus));
        if (!"00000000".equals(updateStatus)) {
            updateStatusJo.put((Object)"detail", (Object)(details + "##" + details));
        }
        logger.info((Object)("upload update certificate result, request body: " + updateStatusJo));
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String fullUrl = "https://" + urlStr + OpenStackCertificateConstants.RequestUrl.UPLOAD_UPDATE_STATUS.getUri();
        String response = ClientUtil.sendPutRequest(fullUrl, updateStatusJo.toString(), tokenId);
        logger.info((Object)("upload update certificate result, response: " + response));
        if (VerifyUtil.isEmpty((String)response)) {
            logger.error((Object)"openstack notify certificate status's response is empty.");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject result = null;
        try {
            result = JSONObject.fromObject((Object)response);
        }
        catch (Exception e) {
            logger.error((Object)"resolve notify certificate status's response failed.", (Throwable)e);
        }
        if (null != result && result.containsKey((Object)"resultCode")) {
            String resultCode = result.getString("resultCode");
            if ("00000000".equals(resultCode)) {
                logger.info((Object)"notify certificate status succeed.");
                if ("eReplication-IAM".equalsIgnoreCase(certName)) {
                    logger.info((Object)"need change IAM ceart.");
                    CertificateCache.getInstance().setNeedUpdate(true);
                }
            } else {
                logger.error((Object)("notify certificate status failed, error: " + result.getString("errorMsg")));
            }
        }
    }
}

