/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.discovery.processor;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IKeystoreManager;
import com.huawei.ism.drm.openstack.adapter.util.EndpointUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackServiceEndPoint;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseProcessor
implements IProcessor {
    private static Log logger = LogFactory.getInstance(BaseProcessor.class);

    public boolean process(AbstractContext context) {
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        this.checkParams(extend);
        this.checkOpenExist(context, extend);
        Set<String> regionSet = this.getDiscoverRegions(extend);
        FusionSphereOpenStack fsos = this.constuctOpenstackObj(context, extend);
        OpenstackInfo openInfo = this.constructOpenInfo(extend);
        openInfo.setUuid(fsos.getUuid());
        try {
            TokenUtil tokenMgr = TokenUtil.getInstance();
            String unscopedToken = tokenMgr.getTokenId(openInfo, null);
            Map<String, OpenStackRegion> regionMap = this.getRegionResource(openInfo, fsos, unscopedToken, regionSet);
            Object actionObject = context.getAttribute("DiscoveryType");
            this.getRegionEndpoints(actionObject, openInfo, regionMap);
            Map<String, OpenStackProject> projMap = this.getProjectResource(openInfo, fsos, unscopedToken);
            if (VerifyUtil.isEmpty(projMap)) {
                logger.info((Object)"project map is empty");
                return true;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get openstack info error.", (Throwable)e, 90160758786989L);
            Object actionObject = context.getAttribute("DiscoveryType");
            if (!("register".equals(actionObject) || e.getErrorCode() != 1073947691L && e.getErrorCode() != 1073947689L)) {
                this.reSetRegions(regionSet, fsos, openInfo, actionObject);
                fsos.setStatus(Integer.valueOf(2));
                context.setAttribute("DiscoveryError_" + fsos.getSn(), (Object)e);
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"get openstack info error.", (long)1073947689L, (String[])new String[0], (Log)logger);
        }
        return true;
    }

    private void reSetRegions(Set<String> regionSet, FusionSphereOpenStack fsos, OpenstackInfo openInfo, Object actionObject) {
        List regionList = CommonDAOLocator.getMoDao().find("from OpenStackRegion where parentMo.uuid = ? order by name", new Object[]{fsos.getUuid()});
        HashMap<String, OpenStackRegion> regionMap = new HashMap<String, OpenStackRegion>();
        for (OpenStackRegion region : regionList) {
            if (!regionSet.isEmpty() && !regionSet.contains(region.getName())) continue;
            OpenStackRegion openRegion = new OpenStackRegion();
            openRegion.setName(region.getName());
            openRegion.setDescription(region.getDescription());
            openRegion.setUuid(region.getUuid());
            openRegion.setTopMoUuid(region.getTopMoUuid());
            openRegion.setConfig(region.getConfig());
            fsos.addChildMo((ManagedObject)openRegion);
            openRegion.setParentMo((ManagedObject)fsos);
            regionMap.put(openRegion.getUuid(), openRegion);
        }
        this.getRegionEndpoints(actionObject, openInfo, regionMap);
    }

    private Set<String> getDiscoverRegions(NeMgrProtocolExtend extend) {
        HashSet<String> resionSet = new HashSet<String>();
        String regions = (String)extend.getExtendParams().get("discoveryregions");
        if (VerifyUtil.isEmpty((String)regions)) {
            return resionSet;
        }
        try {
            JSONArray resionArray = JSONArray.fromObject((Object)regions);
            int size = resionArray.size();
            for (int i = 0; i < size; ++i) {
                resionSet.add(resionArray.getString(i));
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)(regions + " is not a vailid json array."), (Throwable)e);
            return resionSet;
        }
        return resionSet;
    }

    private void getRegionEndpoints(Object actionObject, OpenstackInfo openInfo, Map<String, OpenStackRegion> regionMap) {
        if (!"register".equals(actionObject)) {
            List savedEndpointList = CommonDAOLocator.getMoDao().find("from OpenStackServiceEndPoint where topMoUuid = ? order by name", new Object[]{openInfo.getUuid()});
            if (VerifyUtil.isEmpty((Collection)savedEndpointList)) {
                logger.warn((Object)"savedEndpointList is empty.");
                return;
            }
            ArrayList<OpenStackServiceEndPoint> endpointList = new ArrayList<OpenStackServiceEndPoint>();
            int size = savedEndpointList.size();
            for (int i = 0; i < size; ++i) {
                String serviceId = UUIDGenerator.getUUID();
                OpenStackServiceEndPoint savedOpenStackServiceEndPoint = (OpenStackServiceEndPoint)savedEndpointList.get(i);
                OpenStackServiceEndPoint openStackServiceEndPoint = new OpenStackServiceEndPoint();
                openStackServiceEndPoint.setServiceId(serviceId);
                openStackServiceEndPoint.setUuid(OpenStackCommonUtil.getObjectUuid(openInfo.getUuid(), serviceId));
                openStackServiceEndPoint.setRegionUuid(savedOpenStackServiceEndPoint.getRegionUuid());
                openStackServiceEndPoint.setServiceType(savedOpenStackServiceEndPoint.getServiceType());
                openStackServiceEndPoint.setServiceUrl(savedOpenStackServiceEndPoint.getServiceUrl());
                openStackServiceEndPoint.setTopMoUuid(openInfo.getUuid());
                endpointList.add(openStackServiceEndPoint);
            }
            this.getEndpointResource(regionMap, endpointList);
        }
    }

    private OpenstackInfo constructOpenInfo(NeMgrProtocolExtend extend) {
        logger.trace((Object)"enter constructOpenInfo");
        String ip = extend.getNetworkIpAddress();
        String userName = extend.getNetworkUserName();
        String passwd = extend.getNetworkPassword();
        String domainName = (String)extend.getExtendParams().get("domain");
        Map paramMap = extend.getExtendParams();
        String port = (String)paramMap.get("port");
        String isIam = (String)paramMap.get("authType");
        OpenstackInfo openInfo = new OpenstackInfo();
        openInfo.setIp(ip);
        openInfo.setUser(userName);
        openInfo.setPasswd(passwd);
        openInfo.setDomainName(domainName);
        openInfo.setPort(port);
        openInfo.setUseIAM("IAM".equals(isIam));
        return openInfo;
    }

    private void checkOpenExist(AbstractContext context, NeMgrProtocolExtend extend) {
        List drOpenstacks;
        String action = (String)context.getAttribute("DiscoveryType");
        String ip = extend.getNetworkIpAddress();
        if ("register".equals(action) && !VerifyUtil.isEmpty((Collection)(drOpenstacks = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFusionSphereOpenStack", new Object[0])))) {
            logger.error((Object)("openstack has bean already discovered.Now dev's ip is " + ip), 90160758786989L);
            throw new LegoCheckedException(1073947431L);
        }
    }

    private FusionSphereOpenStack constuctOpenstackObj(AbstractContext context, NeMgrProtocolExtend extend) {
        logger.trace((Object)"enter constuctOpenstackObj");
        String siteId = (String)context.getAttribute("Location");
        String ip = extend.getNetworkIpAddress();
        FusionSphereOpenStack fsos = new FusionSphereOpenStack();
        fsos.setIpAddress(ip);
        fsos.setIsTopMo(Boolean.valueOf(true));
        fsos.setLinkIp(ip);
        fsos.setLocation(siteId);
        String action = (String)context.getAttribute("DiscoveryType");
        if ("register".equals(action)) {
            fsos.setUuid(UUIDGenerator.getUUID());
        } else {
            ManagedObject mo = (ManagedObject)context.getAttribute("StorageDevice");
            fsos.setUuid(mo.getUuid());
        }
        fsos.setSn(fsos.getUuid());
        fsos.setName("OpenStack-" + ip);
        fsos.setStatus(Integer.valueOf(0));
        context.setAttribute("OpenStackObj", (Object)fsos);
        context.setAttribute("cloudServerObj", (Object)fsos);
        return fsos;
    }

    private Map<String, OpenStackRegion> getRegionResource(OpenstackInfo openInfo, FusionSphereOpenStack fsos, String unscopedToken, Set<String> regionSet) {
        IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, openInfo.isUseIAM());
        HashMap<String, OpenStackRegion> regionMap = new HashMap<String, OpenStackRegion>();
        List<OpenStackRegion> regionList = keystoreMgr.getRegions(openInfo, unscopedToken);
        if (VerifyUtil.isEmpty(regionList)) {
            logger.error((Object)"get openstack info failed,regionList is empty", 90160758786989L);
            throw new LegoCheckedException(1073947689L);
        }
        List oldRegionList = CommonDAOLocator.getMoDao().find("from OpenStackRegion where parentMo.uuid = ? order by name", new Object[]{fsos.getUuid()});
        for (OpenStackRegion region : regionList) {
            this.setOldConfig(region, oldRegionList);
            if (!regionSet.isEmpty() && !regionSet.contains(region.getName())) continue;
            fsos.addChildMo((ManagedObject)region);
            region.setParentMo((ManagedObject)fsos);
            regionMap.put(region.getUuid(), region);
        }
        return regionMap;
    }

    private void setOldConfig(OpenStackRegion region, List<OpenStackRegion> oldRegionList) {
        if (VerifyUtil.isEmpty(oldRegionList)) {
            return;
        }
        for (OpenStackRegion oldOpenStackRegion : oldRegionList) {
            if (!oldOpenStackRegion.getUuid().equals(region.getUuid())) continue;
            region.setConfig(oldOpenStackRegion.getConfig());
        }
    }

    private Map<String, Map<String, String>> getEndpointResource(Map<String, OpenStackRegion> regionMap, List<OpenStackServiceEndPoint> endpointList) {
        if (VerifyUtil.isEmpty(endpointList)) {
            logger.error((Object)"get openstack info failed,endpointList is empty", 90160758786989L);
            throw new LegoCheckedException(1073947689L);
        }
        HashMap<String, Map<String, String>> regionEndpointMap = new HashMap<String, Map<String, String>>();
        for (OpenStackServiceEndPoint endpoint : endpointList) {
            String regionUuid = endpoint.getRegionUuid();
            if (VerifyUtil.isEmpty((String)regionUuid)) {
                logger.info((Object)("endpoint is invalid:serviceName=" + endpoint.getServiceName() + "endpointUrl=" + endpoint.getServiceUrl()));
                continue;
            }
            OpenStackRegion region = regionMap.get(regionUuid);
            if (VerifyUtil.isEmpty((Object)region)) {
                logger.info((Object)("endpoint is invalid,cant find region object:serviceName=" + endpoint.getServiceName() + "endpointUrl=" + endpoint.getServiceUrl()));
                continue;
            }
            region.addChildMo((ManagedObject)endpoint);
            endpoint.setParentMo((ManagedObject)region);
            if (!regionEndpointMap.containsKey(regionUuid)) {
                HashMap endpointMap = new HashMap();
                regionEndpointMap.put(regionUuid, endpointMap);
            }
            Map map = (Map)regionEndpointMap.get(regionUuid);
            map.put(endpoint.getServiceType(), endpoint.getServiceUrl());
        }
        EndpointUtil.getInstance().refreshEndpointMap(regionEndpointMap);
        return regionEndpointMap;
    }

    private Map<String, OpenStackProject> getProjectResource(OpenstackInfo openInfo, FusionSphereOpenStack fsos, String unscopedToken) {
        IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, openInfo.isUseIAM());
        List<OpenStackProject> projList = keystoreMgr.getProjects(openInfo, unscopedToken);
        if (VerifyUtil.isEmpty(projList)) {
            logger.error((Object)"get openstack info failed,project is empty", 90160758786989L);
            throw new LegoCheckedException(1073947689L);
        }
        HashMap<String, OpenStackProject> projMap = new HashMap<String, OpenStackProject>();
        for (OpenStackProject proj : projList) {
            fsos.addChildMo((ManagedObject)proj);
            proj.setParentMo((ManagedObject)fsos);
            projMap.put(proj.getUuid(), proj);
        }
        return projMap;
    }

    private void checkParams(NeMgrProtocolExtend extend) {
        if (null == extend) {
            logger.error((Object)"extend is null.", 90160758786989L);
            throw new LegoCheckedException(2099466L);
        }
        String ipAddress = extend.getNetworkIpAddress();
        String pwd = extend.getNetworkPassword();
        String userName = extend.getNetworkUserName();
        if (null == extend.getExtendParams()) {
            logger.error((Object)"extend params is null.", 90160758786989L);
            throw new LegoCheckedException(2099466L);
        }
        String port = (String)extend.getExtendParams().get("port");
        String domain = (String)extend.getExtendParams().get("domain");
        if (VerifyUtil.isEmpty((String)ipAddress) || VerifyUtil.isEmpty((String)pwd) || VerifyUtil.isEmpty((String)userName) || VerifyUtil.isEmpty((String)port) || VerifyUtil.isEmpty((String)domain)) {
            logger.error((Object)"params is not validated.", 90160758786989L);
            throw new LegoCheckedException(2099466L);
        }
    }

    public void postProcess(AbstractContext context) {
        logger.trace((Object)"enter postProcess");
    }

    public void clean(AbstractContext context) {
        logger.trace((Object)"enter clean");
    }

    public String getName() {
        logger.trace((Object)"enter getName");
        return null;
    }
}

