/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.calculator;

import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenstackArrayReplicationRPOCalculator
extends BaseRecoveryPointObjectiveCalculator {
    private static final Log logger = LogFactory.getInstance(OpenstackArrayReplicationRPOCalculator.class);
    private static final String SPLITTER_COMMA = ",";

    public List<String> getTypes() {
        return Arrays.asList("21", "22", "34", "37");
    }

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.debug((Object)("Begin to calculate configRpo. pgName= " + pg.getName()));
        PolicyTemplate template = pg.getTemplate();
        Schedule schedule = this.getSchedule(template);
        String proSiteId = pg.getProductSiteId();
        String recSiteId = pg.getProductSiteId();
        String rpoKey = schedule.getProtectLocation() + SPLITTER_COMMA + proSiteId + SPLITTER_COMMA + recSiteId;
        context.addObject("rpoKey", (Object)rpoKey);
        HashMap<String, Object> configRpo = new HashMap<String, Object>();
        if (21 == template.getType()) {
            configRpo.put(rpoKey, 0);
            return configRpo;
        }
        if (0 == schedule.getScheduleMode() && ProtectionJobUtil.getInstance().isTimeInRange((ISchedule)schedule, new Date())) {
            configRpo.put(rpoKey, this.getConfigRPO(template.getProps(), schedule.getProtectLocation()));
        } else {
            configRpo.put(rpoKey, -1);
        }
        return configRpo;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.debug((Object)("Begin to calculate actualRpo. pgName= " + pg.getName()));
        PolicyTemplate template = pg.getTemplate();
        Schedule schedule = this.getSchedule(template);
        String rpoKey = (String)context.getObject("rpoKey");
        HashMap<String, Object> actualRpo = new HashMap<String, Object>();
        if (21 == template.getType()) {
            actualRpo.put(rpoKey, this.calculateSyncReplicaActualRpo(pg));
        } else {
            actualRpo.put(rpoKey, this.calculateAsyncReplicaActualRpo(pg, schedule));
        }
        return actualRpo;
    }

    private Object calculateSyncReplicaActualRpo(ProtectGroup pg) {
        if (this.getCgStatus(pg)) {
            return 0;
        }
        return -3;
    }

    private Object calculateAsyncReplicaActualRpo(ProtectGroup pg, Schedule schedule) {
        if (0 != schedule.getScheduleMode()) {
            return -1;
        }
        Long lastSuccessExecutedTime = this.getLastSuccessExcTime(pg, "");
        if (null != lastSuccessExecutedTime) {
            return System.currentTimeMillis() - lastSuccessExecutedTime;
        }
        return -3;
    }

    private boolean getCgStatus(ProtectGroup pg) {
        VolumeReplicationCgInfo drCg;
        VolumeReplicationCgInfo cg;
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        try {
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            DrExtendManager mgr = new DrExtendManager();
            cg = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, cgUuid);
            drCg = mgr.queryVolumeReplicationCG(drRegionUuid, drTokenId, drProjUuid, drCgUuid);
        }
        catch (Exception ex) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("query volumeReplicationCg or drCg error");
            buffer.append(", regionUuid:" + regionUuid);
            buffer.append(", projUuid:" + projUuid);
            buffer.append(", cgUuid:" + cgUuid);
            buffer.append(", drRegionUuid:" + drRegionUuid);
            buffer.append(", drProjUuid:" + drProjUuid);
            buffer.append(", drCgUuid:" + drCgUuid);
            buffer.append(ExceptionUtil.getErrorMessage((Throwable)ex));
            logger.error((Object)buffer.toString(), 90160758787071L);
            return false;
        }
        return this.isCgStatusOK(cg) && this.isCgStatusOK(drCg);
    }

    private boolean isCgStatusOK(VolumeReplicationCgInfo cg) {
        if (null == cg) {
            return false;
        }
        if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cg.getStatus())) {
            return false;
        }
        return OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(cg.getReplicationStatus()) || OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue().equals(cg.getReplicationStatus());
    }

    private Schedule getSchedule(PolicyTemplate template) {
        Set schedules = template.getSchedules();
        Schedule schedule = schedules == null || schedules.isEmpty() ? new Schedule() : this.getAutoSchedule(schedules);
        return null == schedule ? new Schedule() : schedule;
    }

    private Schedule getAutoSchedule(Set<Schedule> schedules) {
        for (Schedule schedule : schedules) {
            if (schedule.getScheduleMode() != 0) continue;
            return schedule;
        }
        return (Schedule)CommonUtil.getFirstElement(schedules);
    }

    protected String getSiteId(String key) {
        String[] array = key.split(SPLITTER_COMMA);
        if (array.length != 3) {
            logger.error((Object)("getRecoverySiteId error! key:" + key), 90160758787071L);
            return "";
        }
        return array[2];
    }

    protected Object getProductSiteId(String key) {
        String[] array = key.split(SPLITTER_COMMA);
        if (array.length != 3) {
            logger.error((Object)("getProductSiteId error! key:" + key), 90160758787071L);
            return "";
        }
        return array[1];
    }
}

