/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.path.builder;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.protection.framework.service.path.AbstractProtectionPathImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Map;

public class OpenStackArraySyncReplicaProtectionPath
extends AbstractProtectionPathImpl {
    protected static final String OPEN_PARENTHESIS = "(";
    protected static final String CLOSE_PARENTHESIS = ")";
    protected static final String BACKSLASH_CHARCTER = "/";
    protected static final String PATH_SYMBOL = " --> ";
    private static final Log logger = LogFactory.getInstance(OpenStackArraySyncReplicaProtectionPath.class);

    public ProtectionPathData buildPath(ProtectGroup pg, Map<String, ? extends StorageResource> storages, BatchOperation batchOperation) {
        if (null == pg || null == batchOperation) {
            logger.error((Object)"Build protection path data failed. ProtectGroup or BatchOperation is null.", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<ProtectionPath> protectionPaths = new ArrayList<ProtectionPath>();
        protectionPaths.add(this.constructSiteProtectionPath(pg));
        protectionPaths.add(this.constructRdProtectionPath(pg));
        ProtectionPathData ppd = new ProtectionPathData(protectionPaths);
        if (0L != batchOperation.getErrorCode()) {
            batchOperation.setTargetName(pg.getName());
            ppd.setOperation(batchOperation);
        }
        return ppd;
    }

    protected ProtectionPath constructSiteProtectionPath(ProtectGroup pg) {
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        ProtectionPath siteProtectionPath = new ProtectionPath();
        String siteRelation = pg.getProductSiteName() + "-->" + pg.getProductSiteName() + "\n";
        sitePathDetails.add(siteRelation);
        siteProtectionPath.setPathDetails(sitePathDetails);
        return siteProtectionPath;
    }

    protected ProtectionPath constructRdProtectionPath(ProtectGroup pg) {
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        ProtectionPath rdProtectionPath = new ProtectionPath();
        String projName = (String)pg.getProps().get("projectName");
        String drProjName = (String)pg.getProps().get("drProjectName");
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        StringBuffer rdRelationBuff = new StringBuffer();
        ArrayList<String> volumeUuids = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo poReplicaInfo = this.getPoReplicaInfo(po, "replicationInfo");
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) {
                    logger.info((Object)("volume's replica pair is not protected, status: " + pairInfo.getVolumeStatus()));
                    continue;
                }
                if (volumeUuids.contains(pairInfo.getVolumeUuid())) continue;
                volumeUuids.add(pairInfo.getVolumeUuid());
                rdRelationBuff.append(pairInfo.getVolumeName()).append(OPEN_PARENTHESIS).append(projName).append(BACKSLASH_CHARCTER).append(azName).append(CLOSE_PARENTHESIS);
                rdRelationBuff.append(PATH_SYMBOL);
                rdRelationBuff.append(pairInfo.getVolumeName()).append(OPEN_PARENTHESIS).append(drProjName).append(BACKSLASH_CHARCTER).append(drAzName).append(CLOSE_PARENTHESIS);
                rdRelationBuff.append(";\n");
            }
        }
        rdPathDetails.add(rdRelationBuff.toString());
        rdProtectionPath.setPathDetails(rdPathDetails);
        return rdProtectionPath;
    }

    protected PoReplicaInfo getPoReplicaInfo(ProtectObject po, String repilcaType) {
        String poReplicaJson = (String)po.getProps().get(repilcaType);
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaJson, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            logger.info((Object)("parse poReplicaInfo failed. poReplicaJson=" + poReplicaJson));
            poReplicaInfo = new PoReplicaInfo();
        }
        return poReplicaInfo;
    }

    public int getPolicyTemplateType() {
        return 21;
    }
}

