/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.provider;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.resource.provider.protectgroup.AbstractVmProvider;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.RecoveryTestNetWorkConfigInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.virtualization.util.ProtectionToolsUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenStackVMProvider
extends AbstractVmProvider {
    private static Log logger = LogFactory.getInstance(OpenStackVMProvider.class);
    private INeMgrProtocolExtendService neMgr;
    private IProtectGroupRefreshService pgRefreshService;

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public String getCloudType() {
        return DrFusionSphereOpenStack.class.getSimpleName();
    }

    public void buildProtectObjects(ProtectGroup paramProtectGroup) {
        ProtectionToolsUtil.getInstance().checkBuildProtectObjectsParam(paramProtectGroup);
        ProtectionToolsUtil.getInstance().checkProtectObjectNumber(paramProtectGroup, 512);
        List<OpenStackVM> vms = this.getVmInfos(paramProtectGroup);
        logger.debug((Object)"build protect objects and end to get vminfo,protectGroup name=%s", new Object[]{paramProtectGroup.getName()});
        for (ProtectObject po : paramProtectGroup.getPolist()) {
            boolean vmNotExisted = true;
            for (OpenStackVM vm : vms) {
                if (!vm.getUuid().equals(po.getMoUuid())) continue;
                vmNotExisted = false;
                this.updateProtectObjectBaseInfo(po, vm, paramProtectGroup);
            }
            if (!vmNotExisted) continue;
            logger.error((Object)("vm(" + po.getMoUuid() + ") is not existed."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        this.loadProtectObjectStorageInfo(new ArrayList<ProtectObject>(paramProtectGroup.getPolist()), vms);
        OpenStackCommonUtil.setProtectObjectAddressMap(paramProtectGroup);
    }

    private void updateProtectObjectBaseInfo(ProtectObject po, OpenStackVM vm, ProtectGroup paramProtectGroup) {
        if (VerifyUtil.isEmpty((String)po.getUuid())) {
            po.setUuid(UUIDGenerator.getUUID());
        }
        po.setMoUuid(vm.getUuid());
        po.setName(vm.getName());
        po.setPoType(12);
        po.setProviderSN(vm.getTopMoUuid());
        po.getProps().put("VM_VOLUME_UUIDS", vm.getVolumeAttached());
        if (paramProtectGroup.getTemplate().getType() == 25) {
            po.getProps().put("flavorId", vm.getFlavorId());
        }
        if (!VerifyUtil.isEmpty((String)vm.getBootDevName())) {
            po.getProps().put("VM_ROOT_DEVNAME_KEY", vm.getBootDevName());
        }
        if (!VerifyUtil.isEmpty((Collection)vm.getTags()) && vm.getTags().contains("__type_baremetal")) {
            po.getProps().put("vm_type", "BMS");
        } else {
            po.getProps().put("vm_type", "ECS");
        }
    }

    public List<ProtectObject> getAvailableProtectObject(String providerSn, Map<String, Object> paramMap) {
        String regionUuid = (String)paramMap.get("regionId");
        String projUuid = (String)paramMap.get("projectId");
        String azName = (String)paramMap.get("zoneName");
        if (!(ParamChecker.checkGeneralId((String)regionUuid) && ParamChecker.checkGeneralId((String)projUuid) && ParamChecker.checkGeneralId((String)azName))) {
            logger.error((Object)("param is error:regionUuid=" + regionUuid + " projUuid=" + projUuid + " azName=" + azName));
            throw new LegoCheckedException(1073947393L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        List<OpenStackVM> vmList = novaMgr.getVms(regionUuid, tokenId, projUuid);
        String queryMouuidSql = "select moUuid from ProtectObject";
        String queryTaskIdSql = "select taskId from RollBackTaskInfo";
        List moUuidList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryMouuidSql, new Object[0]);
        List taskIdList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryTaskIdSql, new Object[0]);
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        for (OpenStackVM vm : vmList) {
            if (vm.getLocked().booleanValue() || VerifyUtil.isEmpty((String)vm.getVolumeAttached()) || !azName.equals(vm.getAzName()) || moUuidList.contains(vm.getUuid()) || taskIdList.contains(vm.getUuid())) continue;
            ProtectObject po = new ProtectObject();
            po.setMoUuid(vm.getUuid());
            po.setName(vm.getName());
            po.setPoType(12);
            po.setProviderSN(providerSn);
            poList.add(po);
        }
        return poList;
    }

    public void refreshProtectObjectProperties(ProtectGroup protectGroup) {
    }

    public void fillProtectObjects(ProtectGroup protectGroup) {
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        List list = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getAllTemplate(0L);
        ArrayList<PolicyTemplate> result = new ArrayList<PolicyTemplate>();
        for (PolicyTemplate pt : list) {
            if (21 != pt.getType() && 22 != pt.getType() && 25 != pt.getType() && 29 != pt.getType() && 34 != pt.getType() && 37 != pt.getType()) continue;
            result.add(pt);
        }
        return result;
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList, int protectType) {
        if (protectType != ProtectionTypeEnum.STORAGE_REPLICATION.getValue()) {
            logger.warn((Object)("protectType(" + protectType + ") is not supported."));
            return new ArrayList<PolicyTemplate>();
        }
        return this.getSupportPolicyTemplate(protectObjectList);
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList, Object vms) {
        ProtectGroup pg = ((ProtectObject)CommonUtil.getFirstElement(protectObjectList)).getProtectGroup();
        if (null != pg) {
            String regionUuid = (String)pg.getProps().get("regionId");
            String projectUuid = (String)pg.getProps().get("projectId");
            List vmsOfProtectGroup = (List)vms;
            HashSet<String> uuidSet = new HashSet<String>();
            for (OpenStackVM vm : vmsOfProtectGroup) {
                uuidSet.addAll(OpenStackCommonUtil.getListFromStr(vm.getVolumeAttached(), ","));
            }
            List volumes = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).queryVolumesByUuid(regionUuid, projectUuid, new ArrayList(uuidSet), false);
            logger.info((Object)"Pg:%s, uuidSet size:%s,volumes size:%s", new Object[]{pg.getName(), String.valueOf(uuidSet.size()), String.valueOf(volumes.size())});
            for (ProtectObject po : protectObjectList) {
                po.getUsedStorageResourceSet().clear();
                this.updateProtectObjectStorageInfo(volumes, po);
                logger.info((Object)"Pg:%s, po:%s, uuidSet size:%s,volumes size:%s,storage size:%s", new Object[]{pg.getName(), po.getName(), String.valueOf(uuidSet.size()), String.valueOf(volumes.size()), String.valueOf(po.getUsedStorageResourceSet().size())});
            }
        }
    }

    private void updateProtectObjectStorageInfo(List<OpenStackVolume> volumes, ProtectObject po) {
        String bootDevName = (String)po.getProps().get("VM_ROOT_DEVNAME_KEY");
        for (OpenStackVolume volume : volumes) {
            volume.generateAttachmentInfo();
            if (!volume.getAttachVmUuids().contains(po.getMoUuid())) continue;
            ProtectObjectStorageInfo storage = new ProtectObjectStorageInfo();
            storage.setId(UUIDGenerator.getUUID());
            storage.setResourceName(volume.getName());
            storage.setLunWWN(volume.getUuid());
            storage.setResourceId(volume.getUuid());
            storage.setResourceProviderSN(OpenStackCommonUtil.getOpenstackUuidFromStr(volume.getUuid()));
            for (OpenStackVolAttachment attachment : volume.getAttachments()) {
                if (!po.getMoUuid().equals(attachment.getVmUuid())) continue;
                storage.setDeviceName(attachment.getDevice());
                if (VerifyUtil.isEmpty((String)attachment.getDevice()) || !attachment.getDevice().equals(bootDevName)) continue;
                po.getProps().put("VM_BOOTABLE_VOLUME", volume.getUuid());
            }
            po.addHostStorageResourceInfo(storage);
        }
    }

    private List<OpenStackVM> getVmInfos(ProtectGroup pg) {
        String projUuid;
        String regionUuid;
        Object[] uuids = this.getVmUuids(pg.getPolist());
        IVirtualMachineService service = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
        List vms = service.queryVmByUuids(regionUuid = (String)pg.getProps().get("regionId"), projUuid = (String)pg.getProps().get("projectId"), (String[])uuids);
        if (VerifyUtil.isEmpty((Collection)vms)) {
            logger.error((Object)("OpenstackVM is empty: " + StringUtil.arrayToString((Object[])uuids)), 90160758787071L);
            throw new LegoCheckedException(1073948206L);
        }
        if (uuids.length != vms.size()) {
            logger.error((Object)("some OpenstackVM is not existed: " + StringUtil.arrayToString((Object[])uuids)), 90160758787071L);
            throw new LegoCheckedException(1073948206L);
        }
        return vms;
    }

    private String[] getVmUuids(Collection<ProtectObject> pos) {
        String[] uuids = new String[pos.size()];
        int index = 0;
        for (ProtectObject po : pos) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                logger.error((Object)"uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            uuids[index++] = po.getMoUuid();
        }
        return uuids;
    }

    public void refreshProtectGroup(ProtectGroup pg) {
        if (null != this.pgRefreshService) {
            pg.getProps().put("isManualRefresh", Integer.toString(1));
            try {
                this.pgRefreshService.refreshProtectGroup(pg);
            }
            finally {
                pg.getProps().remove("isManualRefresh");
            }
        }
    }

    public IProtectGroupRefreshService getPgRefreshService() {
        return this.pgRefreshService;
    }

    public void setPgRefreshService(IProtectGroupRefreshService pgRefreshService) {
        this.pgRefreshService = pgRefreshService;
    }

    public String getProviderType() {
        return "FusionSphereOpenstack";
    }

    public void refreshCloud(String cloudSn, String userName, boolean cascade) {
        logger.debug((Object)"refresh Openstack enter", 90160758786816L);
        if (VerifyUtil.isEmpty((String)cloudSn)) {
            logger.error((Object)"openstack sn is empty, refresh failed", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        final ManagedObject mo = CommonDAOLocator.getMoDao().getMo(FusionSphereOpenStack.class, "sn", (Object)cloudSn);
        if (null == mo || null == mo.getMoId()) {
            logger.error((Object)("Openstack(" + cloudSn + ") dosen't exist.Failed to refresh."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)mo.getName(), (String)"ism.drm.openstack.log.refresh", (String)userName, (String)"", null);
        int timeOut = 21600;
        AbstractBackTask task = new AbstractBackTask(mo.getUuid(), bt, timeOut, true){

            protected void doWork() {
                long moId = mo.getMoId();
                NeMgrProtocolExtend extend = OpenStackVMProvider.this.neMgr.findByMoId(Long.valueOf(moId));
                if (null == extend) {
                    logger.error((Object)("Openstack(" + mo.getName() + ") dosen't exist.Failed to refresh."), 90160758787071L);
                    throw new LegoCheckedException(1073947393L);
                }
                RefreshContext context = new RefreshContext(mo);
                context.setAttribute("refreshTask", (Object)this);
                context.setAttribute("DiscoveryType", (Object)"refresh");
                CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Openstack");
                if (null == refreshTemplate) {
                    throw new LegoCheckedException(127402L);
                }
                refreshTemplate.process((AbstractContext)context);
                Long errorCode = (Long)context.getAttribute("icommand:errorcode");
                if (errorCode != null) {
                    throw new LegoCheckedException(errorCode.longValue());
                }
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }

    public Map<String, Object> checkRecoveryContext(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, Map<String, String> recoveryContext, RecoveryPlan recoveryPlan, String reySite) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        String siteId = RecoveryProcessUtil.getDisterSiteId((String)reySite, (ProtectGroup)((ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups())));
        settings.put("DISASTER_SITE_ID", siteId);
        ProtectGroup pg = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
        if (PolicyTemplateType.POLICY_TEMPLATE_E.OPENSTACK_INTRA_CITY_ASYNC_HYPER_METRO_RING.getValue() == pg.getTemplate().getType() && (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION == procType || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY == procType)) {
            if (null == recoveryContext.get("recovery_region_id") || null == recoveryContext.get("recovery_az_id")) {
                logger.error((Object)"CSHA+CSDR instance:%s, execute type:%s , no necessary recovery parameters.", new Object[]{pg.getName(), procType});
                throw new LegoCheckedException(1073947393L);
            }
            settings.put("recovery_region_id", recoveryContext.get("recovery_region_id"));
            settings.put("recovery_az_id", recoveryContext.get("recovery_az_id"));
        }
        this.checkPlaceHoldVm(recoveryPlan, procType);
        this.checkProtectObjectInfo(recoveryPlan, procType);
        return settings;
    }

    private void checkPlaceHoldVm(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            logger.error((Object)"pg is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (procType.equals((Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING) || procType.equals((Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY) || procType.equals((Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION) || procType.equals((Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION)) {
            for (ProtectObject po : pg.getPolist()) {
                boolean hasPlaceHoldVm = false;
                for (RecoverySetting setting : recoverySettings) {
                    if (!setting.getOwnerId().equals(po.getUuid()) || !setting.getName().equals("PLACEHOLDVM") || VerifyUtil.isEmpty((String)setting.getValue())) continue;
                    hasPlaceHoldVm = true;
                    break;
                }
                if (hasPlaceHoldVm) continue;
                logger.error((Object)("po has not set phvm:" + po.getName()));
                throw new LegoCheckedException(1073948908L);
            }
        }
    }

    private void checkProtectObjectInfo(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            logger.error((Object)"pg is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (procType.equals((Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING) || procType.equals((Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION) || procType.equals((Object)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION)) {
            for (ProtectObject po : pg.getPolist()) {
                if (ProtectObjectStatusEnum.VALID.getValue() != po.getPoStatus()) {
                    logger.error((Object)("po(" + po.getName() + ") is not valid."));
                    throw new LegoCheckedException(1073948909L);
                }
                String replicationInfo = (String)po.getProps().get("replicationInfo");
                if (VerifyUtil.isEmpty((String)replicationInfo)) {
                    logger.warn((Object)("replicaInfo is empty. vm is " + po.getName()));
                    continue;
                }
                logger.debug((Object)("replicaInfo:" + replicationInfo));
                JSONObject replicaInfo = JSONObject.fromObject((Object)replicationInfo);
                JSONArray volInfo = replicaInfo.getJSONArray("pairInfos");
                if (null == volInfo) {
                    logger.warn((Object)("pairInfos is empty. vm is " + po.getName()));
                    continue;
                }
                this.checkVolumeStatus(procType, po, volInfo);
            }
        }
    }

    private void checkVolumeStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType, ProtectObject po, JSONArray volInfo) {
        for (int i = 0; i < volInfo.size(); ++i) {
            JSONObject pairInfo = volInfo.getJSONObject(i);
            String volumeStatus = pairInfo.getString("volumeStatus");
            if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(volumeStatus)) continue;
            if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(volumeStatus) && OpenStackCommonUtil.isBareMetalServer(po)) {
                logger.info((Object)("bms (" + po.getName() + ") has unprotected volume, allow to execute " + procType.getValue()));
                continue;
            }
            logger.error((Object)("po(" + po.getName() + ") has at least one volume not protected."));
            throw new LegoCheckedException(1073948909L);
        }
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        super.checkRecoverySettings(recoverySettingList);
        this.checkStartDelayTime(recoverySettingList);
        this.checkPlaceHoldVm(recoverySettingList);
        this.checkPlaceHoldVmName(recoverySettingList);
        this.checkTestNetConfig(recoverySettingList);
    }

    private void checkStartDelayTime(List<RecoverySetting> recoverySettingList) {
        for (RecoverySetting setting : recoverySettingList) {
            if (!"start_delay_time".equals(setting.getName()) || NumberUtil.between((String)setting.getValue(), (int)0, (int)1800)) continue;
            logger.error((Object)"%s is not in range (0-3600)s: %s", new Object[]{"start_delay_time", setting.getValue()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkPlaceHoldVm(List<RecoverySetting> recoverySettingList) {
        HashSet<String> vmUuidSet = new HashSet<String>();
        for (RecoverySetting setting : recoverySettingList) {
            if (!setting.getName().equals("PLACEHOLDVM")) continue;
            if (VerifyUtil.isEmpty((String)setting.getValue())) {
                logger.error((Object)"not set PLACEHOLDVM");
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)setting.getValue())) {
                logger.error((Object)"Invalid PLACEHOLDVM");
                throw new LegoCheckedException(1073947393L);
            }
            String vmUuid = setting.getValue();
            if (vmUuidSet.contains(vmUuid)) {
                logger.error((Object)("placeholdvm(" + vmUuid + ") is setted to different po."));
                throw new LegoCheckedException(1073947393L);
            }
            vmUuidSet.add(vmUuid);
        }
    }

    private void checkPlaceHoldVmName(List<RecoverySetting> recoverySettingList) {
        for (RecoverySetting setting : recoverySettingList) {
            if (!"PLACEHOLDVMNAME".equals(setting.getName())) continue;
            if (VerifyUtil.isEmpty((String)setting.getValue())) {
                logger.error((Object)"not set PLACEHOLDVMNAME");
                throw new LegoCheckedException(1073947393L);
            }
            if (ParamChecker.checkGeneralText((String)setting.getValue())) continue;
            logger.error((Object)"Invalid PLACEHOLDVMNAME");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkTestNetConfig(List<RecoverySetting> recoverySettingList) {
        for (RecoverySetting setting : recoverySettingList) {
            if (!setting.getName().equals("TESTNETWORKCONFIG")) continue;
            if (VerifyUtil.isEmpty((String)setting.getValue())) {
                logger.error((Object)("not set TESTNETWORKCONFIG for po:" + setting.getOwnerId()));
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkLongText((String)setting.getValue())) {
                logger.error((Object)"TESTNETWORKCONFIG incorrect");
                throw new LegoCheckedException(1073947393L);
            }
            JSONArray netWorkArray = JSONArray.fromObject((Object)setting.getValue());
            for (int i = 0; i < netWorkArray.size(); ++i) {
                JSONObject obj = netWorkArray.getJSONObject(i);
                RecoveryTestNetWorkConfigInfo configInfo = (RecoveryTestNetWorkConfigInfo)JSONObject.toBean((JSONObject)obj, RecoveryTestNetWorkConfigInfo.class);
                this.checkCreatePortParam(configInfo.getNetworkId(), configInfo.getIsDhcp(), configInfo.getIpAddress(), configInfo.getPortName());
            }
        }
    }

    private void checkCreatePortParam(String networkId, Boolean isDhcp, String ipAddress, String portName) {
        if (VerifyUtil.isEmpty((String)networkId) || null == isDhcp || VerifyUtil.isEmpty((String)portName)) {
            logger.error((Object)"params: networkId, isDhcp, portName is empty or null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParamWithOutChinese((String)portName)) {
            logger.error((Object)"portName is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(isDhcp.booleanValue() || CommUtil.checkDrmIpParam((String)ipAddress) || CommUtil.checkDrmIpV6Param((String)ipAddress))) {
            logger.error((Object)("ip error:" + ipAddress));
            throw new LegoCheckedException(1073947393L);
        }
    }
}

