/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenStackVMActionEnum;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AbStractPhVmTask {
    private static Log logger = LogFactory.getInstance(AbStractPhVmTask.class);
    private PoReplicaInfo replicaInfo;
    private String drRegionUuid;
    private String drProjectUuid;
    private String instanceType;
    private String protectGroupName;

    public PoReplicaInfo getReplicaInfo() {
        return this.replicaInfo;
    }

    public void setReplicaInfo(PoReplicaInfo replicaInfo) {
        this.replicaInfo = replicaInfo;
    }

    public String getDrRegionUuid() {
        return this.drRegionUuid;
    }

    public void setDrRegionUuid(String drRegionUuid) {
        this.drRegionUuid = drRegionUuid;
    }

    public String getDrProjectUuid() {
        return this.drProjectUuid;
    }

    public void setDrProjectUuid(String drProjectUuid) {
        this.drProjectUuid = drProjectUuid;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getProtectGroupName() {
        return this.protectGroupName;
    }

    public void setProtectGroupName(String protectGroupName) {
        this.protectGroupName = protectGroupName;
    }

    protected void lockVm(String vmUuid) {
        String tokenId;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        AsyncTaskResponse response = novaMgr.lockVm(this.drRegionUuid, tokenId = TokenUtil.getInstance().getTokenId(this.drProjectUuid), this.drProjectUuid, vmUuid);
        if (!response.isSuccess()) {
            logger.error((Object)("lock vm failed:vmuuid=" + vmUuid));
            throw new LegoCheckedException(1073948108L);
        }
        novaMgr.addTagToVm(this.drRegionUuid, tokenId, this.drProjectUuid, vmUuid, "__type_dr");
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(this.getInstanceType()) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(this.getInstanceType())) {
            novaMgr.addTagToVm(this.drRegionUuid, tokenId, this.drProjectUuid, vmUuid, "__type_csha");
        }
    }

    protected void deletePorts(OpenStackVM vm) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(this.drProjectUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        INeutronManager networkMgr = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        List phVmPortList = this.replicaInfo.getPhVmInfo().getPortIdList();
        logger.info((Object)("start delete ports.the size of port in PhVmInfo is:" + phVmPortList.size() + ",vmId: " + vm.getUuid() + ",vmName=" + vm.getName() + ", protectGroup name=" + this.getProtectGroupName()));
        Iterator iterator = phVmPortList.iterator();
        while (iterator.hasNext()) {
            String portId = (String)iterator.next();
            AsyncTaskResponse response = novaMgr.detachPortFromVM(portId, vm.getUuid(), this.drProjectUuid, this.drRegionUuid, tokenId);
            if (!response.isSuccess()) {
                logger.error((Object)("detach port failed:portId=" + portId + ",vmName=" + vm.getName() + ",vmId=" + vm.getUuid() + ", protectGroup name=" + this.getProtectGroupName()));
                throw new LegoCheckedException(1073948912L);
            }
            CommonUtil.sleep((long)3000L);
            response = networkMgr.deletePort(this.drRegionUuid, tokenId, portId);
            if (!response.isSuccess()) {
                logger.info((Object)("delete port failed:portId=" + portId + ",vmName=" + vm.getName() + ",vmId=" + vm.getUuid() + ", protectGroup name=" + this.getProtectGroupName()));
                continue;
            }
            iterator.remove();
        }
    }

    protected void deleteBootVolume(String vmUuid, String volumeId) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(this.drProjectUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        AsyncTaskResponse detachResonse = novaMgr.detachVolFromVm(tokenId, this.drProjectUuid, this.drRegionUuid, vmUuid, "ECS", volumeId);
        if (!detachResonse.isSuccess()) {
            logger.error((Object)("detach boot volume failed:vmUuid=" + vmUuid + " volumeId=" + volumeId));
            throw new LegoCheckedException(1073948107L);
        }
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        AsyncTaskResponse response = cinderMgr.deleteVolume(volumeId, this.drRegionUuid, tokenId, this.drProjectUuid);
        if (!response.isSuccess()) {
            logger.error((Object)("delete the temp boot volume failed:volumeId=" + volumeId));
            return;
        }
        this.replicaInfo.getPhVmInfo().setBootVolumeUuid("");
    }

    protected void shutdownVm(String vmUuid) {
        String tokenId;
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.drRegionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        AsyncTaskResponse response = novaMgr.vmAction(vmUuid, this.drProjectUuid, this.drRegionUuid, tokenId = TokenUtil.getInstance().getTokenId(this.drProjectUuid), OpenStackVMActionEnum.STOP);
        if (!response.isSuccess()) {
            logger.error((Object)("shutdown vm(" + vmUuid + ") failed" + response.getErrorCode()));
            throw new LegoCheckedException(1073948363L);
        }
    }

    public static boolean isSwitchNetwork(String regionId) {
        List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionId);
        if (VerifyUtil.isEmpty((Collection)regions)) {
            logger.error((Object)("openstack region is not exist.regionId=" + regionId));
            throw new LegoCheckedException(1073947393L);
        }
        return ((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork();
    }
}

