/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.AbStractPhVmTask;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;

public class ConfigPhVmTask
extends AbStractPhVmTask
implements Callable<PoReplicaInfo> {
    private static Log logger = LogFactory.getInstance(ConfigPhVmTask.class);
    private String phVmUuid;

    public ConfigPhVmTask(PoReplicaInfo replicaInfo, String phVmUuid, String instanceType, String protectGroupName) {
        this.phVmUuid = phVmUuid;
        this.setReplicaInfo(replicaInfo);
        this.setDrRegionUuid(replicaInfo.getDrRegionUuid());
        this.setDrProjectUuid(replicaInfo.getDrProjUuid());
        this.setInstanceType(instanceType);
        this.setProtectGroupName(protectGroupName);
    }

    @Override
    public PoReplicaInfo call() {
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.getDrRegionUuid());
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getTokenId(this.getDrProjectUuid());
            OpenStackVM vmInfo = novaMgr.getVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), this.phVmUuid, new int[0]);
            if (null == vmInfo) {
                logger.error((Object)("occupied vm is not found:" + this.phVmUuid + " in (" + this.getDrRegionUuid() + "#" + this.getDrProjectUuid() + "), protectGroup name=" + this.getProtectGroupName()));
                throw new LegoCheckedException(1073948375L);
            }
            if (!OpenStackCommonUtil.isBareMetalServer(vmInfo)) {
                if (OpenstackEnumDefine.VM_STATUS_E.STOPPED.getValue() != vmInfo.getStatus().intValue() && OpenstackEnumDefine.VM_STATUS_E.SHUTOFF.getValue() != vmInfo.getStatus().intValue()) {
                    logger.error((Object)("ECS status is not stopped or shutoff. occupied vm name(" + vmInfo.getName() + "), uuid(" + this.phVmUuid + ") status is error:" + vmInfo.getStatus() + ", protectGroup name=" + this.getProtectGroupName()));
                    throw new LegoCheckedException(1073948907L);
                }
                this.checkSnapShots(openstackUuid, tokenId, vmInfo);
            }
            PhVmInfo phVm = new PhVmInfo();
            this.getReplicaInfo().setPhVmInfo(phVm);
            if ((ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(this.getInstanceType()) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(this.getInstanceType())) && OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                this.deletePortForPhVm(novaMgr, tokenId, vmInfo, phVm);
            }
            if (OpenStackCommonUtil.isBareMetalServer(vmInfo)) {
                novaMgr.addTagToVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmInfo.getUuid(), "__type_dr");
                phVm.setStatus(OpenstackEnumDefine.VM_STATUS_E.getStatusByValue((int)vmInfo.getStatus()).getType());
            } else {
                this.detachAllVolumesInVm(vmInfo);
                logger.info((Object)("detach volumes successfully,vmName=" + vmInfo.getName() + "vmuud=" + vmInfo.getUuid() + ",protectGroup name=" + this.getProtectGroupName()));
                HashMap<String, String> metadata = new HashMap<String, String>();
                String pdVMId = OpenStackCommonUtil.getIdFromUuid(OpenStackCommonUtil.getBcmPrimaryVmUuid(this.getReplicaInfo()));
                metadata.put("_bcm_primary_vm", pdVMId);
                novaMgr.updateVMmetadata(this.phVmUuid, this.getDrProjectUuid(), this.getDrRegionUuid(), tokenId, metadata);
                this.lockVm(vmInfo.getUuid());
                if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(this.getInstanceType())) {
                    this.addBackUpTagsToCSHAVm(this.getReplicaInfo(), vmInfo.getUuid(), OpenStackCommonUtil.getIdFromUuid(this.getReplicaInfo().getMoUuid()));
                }
                logger.debug((Object)("lock vm successfully, vmuud=" + vmInfo.getUuid() + ",vmName=" + vmInfo.getName() + ", protectGroup name=" + this.getProtectGroupName()));
                phVm.setStatus(OpenstackEnumDefine.VM_STATUS_E.STOPPED.getType());
            }
            phVm.setVmUuid(vmInfo.getUuid());
            phVm.setName(vmInfo.getName());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("config phvm phVmUuid=" + this.phVmUuid + ",protectGroup name=" + this.getProtectGroupName()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"config phvm failed", (long)1073948363L, (String[])new String[0], (Log)logger);
        }
        return this.getReplicaInfo();
    }

    private void checkSnapShots(String openstackUuid, String tokenId, OpenStackVM vmInfo) {
        if (OpenStackCommonUtil.isBareMetalServer(vmInfo)) {
            return;
        }
        List<String> attachedVol = OpenStackCommonUtil.getListFromStr(vmInfo.getVolumeAttached(), ",");
        if (!VerifyUtil.isEmpty(attachedVol)) {
            ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
            for (String volUuid : attachedVol) {
                String volumeId = OpenStackCommonUtil.getIdFromUuid(volUuid);
                HashMap<String, String> filterProp = new HashMap<String, String>();
                filterProp.put("volume_id", volumeId);
                List<VolumeSnapShotInfo> volSnapShotList = cinderMgr.queryVolumeSnapShots(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), filterProp);
                if (VerifyUtil.isEmpty(volSnapShotList)) continue;
                logger.error((Object)"ph vmInfo=%s volumeId=%s has %s snapshots", new Object[]{vmInfo, volumeId, volSnapShotList.size()});
                throw new LegoCheckedException(1073949718L, new String[]{vmInfo.getName(), volumeId});
            }
        }
    }

    private void deletePortForPhVm(INovaManager novaMgr, String tokenId, OpenStackVM vmInfo, PhVmInfo phVm) {
        logger.info((Object)("start to delete port for phvm,vmName=" + vmInfo.getName() + ",phVm=" + phVm + ", protectGroup name=" + this.getProtectGroupName()));
        if (ConfigPhVmTask.isSwitchNetwork(this.getDrRegionUuid())) {
            List<VMInterface> interfaces = novaMgr.getVmInterfaces(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmInfo.getUuid());
            if (!VerifyUtil.isEmpty(interfaces)) {
                for (VMInterface vmInterface : interfaces) {
                    phVm.getPortIdList().add(vmInterface.getPortId());
                }
                this.deletePorts(vmInfo);
            }
            logger.info((Object)("delete ports successfully,vmName=" + vmInfo.getName() + ", protectGroup name=" + this.getProtectGroupName()));
        }
        logger.info((Object)("DR regionuuid " + this.getDrRegionUuid() + "is not SwitchNetwork, protectGroup name=" + this.getProtectGroupName()));
    }

    private void detachAllVolumesInVm(OpenStackVM vmInfo) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.getDrRegionUuid());
        String tokenId = TokenUtil.getInstance().getTokenId(this.getDrProjectUuid());
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        ICinderManager cinderMgr = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        List<String> attachedVol = OpenStackCommonUtil.getListFromStr(vmInfo.getVolumeAttached(), ",");
        for (String volUuid : attachedVol) {
            AsyncTaskResponse detachResonse = novaMgr.detachVolFromVm(tokenId, this.getDrProjectUuid(), this.getDrRegionUuid(), vmInfo.getUuid(), "ECS", OpenStackCommonUtil.getIdFromUuid(volUuid));
            if (!detachResonse.isSuccess()) {
                logger.error((Object)("detach volume failed:vmUuid=" + vmInfo.getUuid() + " volumeId=" + volUuid + "vmInfo=" + vmInfo));
                throw new LegoCheckedException(1073948107L);
            }
            AsyncTaskResponse response = cinderMgr.deleteVolume(OpenStackCommonUtil.getIdFromUuid(volUuid), this.getDrRegionUuid(), tokenId, this.getDrProjectUuid());
            if (response.isSuccess()) continue;
            logger.error((Object)("delete the temp boot volume failed:volumeId=" + volUuid + ",vmInfo =" + vmInfo));
            return;
        }
    }

    protected void addBackUpTagsToCSHAVm(PoReplicaInfo poReplicationInfo, String vmUuid, String peerVmId) {
        if (poReplicationInfo == null || VerifyUtil.isEmpty((String)vmUuid) || VerifyUtil.isEmpty((String)peerVmId)) {
            logger.error((Object)"Param error, PoReplicaInfo, vmUuid or peerVmId is null");
            return;
        }
        String regionUuid = poReplicationInfo.getRegionUuid();
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openStackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(this.getDrProjectUuid());
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)openStackUuid)) {
            logger.info((Object)"Some param is null, regionUuid:%s, openStackUuid:%s", new Object[]{regionUuid, openStackUuid});
            return;
        }
        try {
            novaMgr.addTagToVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmUuid, "dr_backup_vm::" + peerVmId);
            novaMgr.addTagToVm(this.getDrRegionUuid(), tokenId, this.getDrProjectUuid(), vmUuid, "dr_backup_region::" + OpenStackCommonUtil.getIdFromUuid(regionUuid));
        }
        catch (Exception e) {
            logger.error((Object)"AddBackUpTagsToCSHAVm, add tags error, vmUuid:%s", new Object[]{vmUuid});
        }
    }
}

