/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.AbStractPhVmTask;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.CreatePortInfo;
import com.huawei.ism.drm.openstack.sdk.msg.CreateServerInfo;
import com.huawei.ism.drm.openstack.sdk.msg.DevMappingOfCreateServer;
import com.huawei.ism.drm.openstack.sdk.msg.ImageMetadataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.NetworkOfCreateServer;
import com.huawei.ism.drm.openstack.sdk.msg.PortInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVirtualMachineService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class CreatePhVmTask
extends AbStractPhVmTask
implements Callable<PoReplicaInfo> {
    private static Log logger = LogFactory.getInstance(CreatePhVmTask.class);
    private ProtectGroup pg;
    private String srcVmUuid;
    private String regionUuid;
    private String projectUuid;
    private String drAzName;
    private String drVolumeType;

    public CreatePhVmTask(ProtectGroup pg, PoReplicaInfo replicaInfo) {
        this.pg = pg;
        this.srcVmUuid = replicaInfo.getMoUuid();
        this.regionUuid = replicaInfo.getRegionUuid();
        this.projectUuid = replicaInfo.getProjUuid();
        this.drAzName = (String)pg.getProps().get("drZoneName");
        this.drVolumeType = ((PoReplicaPairInfo)CommonUtil.getFirstElement((Collection)replicaInfo.getPairInfos())).getDrVolumeType();
        this.setReplicaInfo(replicaInfo);
        this.setDrRegionUuid(replicaInfo.getDrRegionUuid());
        this.setDrProjectUuid(replicaInfo.getDrProjUuid());
    }

    @Override
    public PoReplicaInfo call() {
        try {
            IVolumeService volService;
            String srcVolumeUuid;
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getTokenId(this.projectUuid);
            OpenStackVM srcVmInfo = novaMgr.getVm(this.regionUuid, tokenId, this.projectUuid, this.srcVmUuid, new int[0]);
            if (null == srcVmInfo) {
                logger.error((Object)"get vm return null value.");
                throw new LegoCheckedException(1073947393L);
            }
            List<VMInterface> srcVmPortList = novaMgr.getVmInterfaces(this.regionUuid, tokenId, this.projectUuid, this.srcVmUuid);
            if (VerifyUtil.isEmpty(srcVmPortList)) {
                logger.error((Object)"the port of source vm is empty");
                throw new LegoCheckedException(1073948363L);
            }
            VolumeInfo bootVolume = this.createBootVolume(srcVmInfo);
            logger.debug((Object)("create boot volume successfully,volumeId=" + bootVolume.getId()));
            if (this.pg.getTemplate().getType() == 25 && !VerifyUtil.isEmpty((String)(srcVolumeUuid = this.findBootVolume(srcVmInfo, volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class))))) {
                this.updateImageMetadata(volService, srcVolumeUuid);
            }
            OpenStackVM vm = this.createVm(srcVmInfo, srcVmPortList, bootVolume);
            logger.debug((Object)("create placehold vm successfully,vmName=" + vm.getName()));
            try {
                String drTokenId = TokenUtil.getInstance().getTokenId(this.getDrProjectUuid());
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("_ha_policy_type", "close");
                this.addPrimaryVMKey(srcVmInfo, metadata);
                novaMgr.updateVMmetadata(vm.getUuid(), this.getDrProjectUuid(), this.getDrRegionUuid(), drTokenId, metadata);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("close phvm ha error:" + vm.getName()), (Throwable)e);
            }
            this.shutdownVm(vm.getUuid());
            logger.debug((Object)("shutdown vm successfully,vmName=" + vm.getName()));
            if (CreatePhVmTask.isSwitchNetwork(this.getDrRegionUuid())) {
                this.deletePorts(vm);
                logger.debug((Object)("detach and delete port successfully,vmName=" + vm.getName()));
            }
            this.deleteBootVolume(vm.getUuid(), bootVolume.getId());
            logger.debug((Object)("detach and delete boot volume successfully,vmName=" + vm.getName()));
            this.lockVm(vm.getUuid());
            logger.debug((Object)("lock vm successfully,vmName=" + vm.getName()));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create phvm failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"create phvm failed", (long)1073948363L, (String[])new String[0], (Log)logger);
        }
        return this.getReplicaInfo();
    }

    private void addPrimaryVMKey(OpenStackVM vmInfo, Map<String, String> metadata) {
        if (!VerifyUtil.isEmpty((Map)vmInfo.getMetadata()) && !VerifyUtil.isEmpty((String)((String)vmInfo.getMetadata().get("_bcm_primary_vm")))) {
            metadata.put("_bcm_primary_vm", (String)vmInfo.getMetadata().get("_bcm_primary_vm"));
        } else {
            metadata.put("_bcm_primary_vm", OpenStackCommonUtil.getIdFromUuid(this.srcVmUuid));
        }
    }

    private void updateImageMetadata(IVolumeService volService, String volumeUuid) {
        String regionId = (String)this.pg.getProps().get("regionId");
        String projUuid = (String)this.pg.getProps().get("projectId");
        String drRegionId = (String)this.pg.getProps().get("drRegionId");
        String drProjectId = (String)this.pg.getProps().get("drProjectId");
        ImageMetadataInfo queryImageMedata = volService.queryImageMetadata(volumeUuid, regionId, projUuid);
        volService.updateImageMetadata(this.getReplicaInfo().getPhVmInfo().getBootVolumeUuid(), drRegionId, drProjectId, queryImageMedata);
    }

    private String findBootVolume(OpenStackVM srcVmInfo, IVolumeService volService) {
        List volumes = volService.getVolumesByVm(this.regionUuid, this.projectUuid, false, new String[]{this.srcVmUuid});
        String bootDevName = srcVmInfo.getBootDevName();
        for (OpenStackVolume openStackVolume : volumes) {
            openStackVolume.generateAttachmentInfo();
            for (OpenStackVolAttachment attachment : openStackVolume.getAttachments()) {
                if (VerifyUtil.isEmpty((String)srcVmInfo.getUuid()) || !srcVmInfo.getUuid().equals(attachment.getVmUuid()) || VerifyUtil.isEmpty((String)attachment.getDevice()) || !attachment.getDevice().equals(bootDevName)) continue;
                logger.debug((Object)("vm boot volume is " + openStackVolume.getUuid()));
                return openStackVolume.getUuid();
            }
        }
        return null;
    }

    private OpenStackVM createVm(OpenStackVM srcVmInfo, List<VMInterface> srcVmPortList, VolumeInfo bootVolume) {
        String portId = null;
        try {
            String tokenId = TokenUtil.getInstance().getTokenId(this.projectUuid);
            String drTokenId = TokenUtil.getInstance().getTokenId(this.getDrProjectUuid());
            portId = this.getDrPortId(srcVmPortList, tokenId, drTokenId, srcVmInfo);
            CreateServerInfo createInfo = new CreateServerInfo();
            createInfo.setAvailabilityZone(this.drAzName);
            String phVmName = OpenStackCommonUtil.getNameBySuff(srcVmInfo.getName(), "-HA");
            createInfo.setName(phVmName);
            createInfo.setFlavorId(srcVmInfo.getFlavorId());
            ArrayList<NetworkOfCreateServer> portList = new ArrayList<NetworkOfCreateServer>();
            NetworkOfCreateServer port = new NetworkOfCreateServer();
            port.setPortId(portId);
            portList.add(port);
            createInfo.setNetworks(portList);
            DevMappingOfCreateServer devMapping = new DevMappingOfCreateServer();
            devMapping.setSourceId(bootVolume.getId());
            ArrayList<DevMappingOfCreateServer> devMappingList = new ArrayList<DevMappingOfCreateServer>();
            devMappingList.add(devMapping);
            createInfo.setBlockDevMapping(devMappingList);
            IVirtualMachineService vmService = (IVirtualMachineService)ServiceLocator.getInstance().getService(IVirtualMachineService.class);
            OpenStackVM vmCreated = vmService.createVm(this.getDrRegionUuid(), this.getDrProjectUuid(), drTokenId, createInfo);
            this.getReplicaInfo().getPhVmInfo().setVmUuid(vmCreated.getUuid());
            this.getReplicaInfo().getPhVmInfo().setName(vmCreated.getName());
            this.getReplicaInfo().getPhVmInfo().getPortIdList().add(portId);
            return vmCreated;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create phvm failed:", (Throwable)e);
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                this.getReplicaInfo().getPhVmInfo().setVmUuid(e.getParameters()[0]);
            }
            if (!VerifyUtil.isEmpty(portId)) {
                this.getReplicaInfo().getPhVmInfo().getPortIdList().add(portId);
            }
            throw e;
        }
    }

    private String getDrPortId(List<VMInterface> srcVmPortList, String tokenId, String drTokenId, OpenStackVM srcVmInfo) {
        VMInterface srcPort = this.getUsefulPort(srcVmPortList);
        if (VerifyUtil.isEmpty((Object)srcPort)) {
            logger.error((Object)("The product vm has no useful port,vmId=" + srcVmInfo.getUuid()));
            throw new LegoCheckedException(1073948363L);
        }
        logger.debug((Object)("the useful srcPortId is : " + srcPort.getPortId()));
        INeutronManager neutronManager = ManagerFactory.getInstance().getNeutronManager(OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid));
        OpenStackPort srcStackPort = neutronManager.getPort(this.regionUuid, tokenId, srcPort.getPortId());
        if (null == srcStackPort) {
            logger.error((Object)"Get port return null value.");
            throw new LegoCheckedException(1073947393L);
        }
        CreatePortInfo createPortInfo = new CreatePortInfo();
        logger.debug((Object)("srcPort type is : " + srcStackPort.getType()));
        if ("direct".equals(srcStackPort.getType())) {
            createPortInfo.setType(srcStackPort.getType());
        }
        createPortInfo.setNetworkId(srcPort.getNetId());
        AsyncTaskResponse taskResponse = neutronManager.createPort(this.getDrRegionUuid(), drTokenId, this.getDrProjectUuid(), createPortInfo);
        if (!taskResponse.isSuccess()) {
            logger.error((Object)("create port failed ; network id is : " + createPortInfo.getNetworkId()));
            throw new LegoCheckedException(1073948363L);
        }
        PortInfo drPortInfo = (PortInfo)taskResponse.getTaskResult();
        String portId = drPortInfo.getId();
        if (VerifyUtil.isEmpty((String)portId)) {
            logger.error((Object)"create drPort failed , portid is empty");
            throw new LegoCheckedException(1073948363L);
        }
        logger.debug((Object)("drPortId is : " + portId));
        return portId;
    }

    private VMInterface getUsefulPort(List<VMInterface> srcVmPortList) {
        for (VMInterface port : srcVmPortList) {
            if (VerifyUtil.isEmpty((Object)port) || VerifyUtil.isEmpty((String)port.getNetId()) || VerifyUtil.isEmpty((String)port.getPortId())) continue;
            return port;
        }
        return null;
    }

    private VolumeInfo createBootVolume(OpenStackVM srcVmInfo) {
        try {
            VolumeCreateInfo volCreateInfo = new VolumeCreateInfo();
            volCreateInfo.setAzName(this.drAzName);
            String bootVolName = OpenStackCommonUtil.getNameBySuff(srcVmInfo.getName(), "-DR");
            volCreateInfo.setName(bootVolName);
            volCreateInfo.setProjectId(OpenStackCommonUtil.getIdFromUuid(this.getDrProjectUuid()));
            volCreateInfo.setSize(1);
            volCreateInfo.setVolTypeName(this.drVolumeType);
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            VolumeInfo bootVolume = volService.createVolume(volCreateInfo, this.getDrRegionUuid(), this.getDrProjectUuid(), true);
            String volumeUuid = OpenStackCommonUtil.getObjectUuid(this.pg.getPoProviderSN(), bootVolume.getId());
            if (null == this.getReplicaInfo().getPhVmInfo()) {
                PhVmInfo phVmInfo = new PhVmInfo();
                this.getReplicaInfo().setPhVmInfo(phVmInfo);
            }
            this.getReplicaInfo().getPhVmInfo().setBootVolumeUuid(volumeUuid);
            return bootVolume;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("create placehold vm's boot volume failed:" + CommUtil.convertToString((Object)e.getParameters())));
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                if (null == this.getReplicaInfo().getPhVmInfo()) {
                    PhVmInfo phVmInfo = new PhVmInfo();
                    this.getReplicaInfo().setPhVmInfo(phVmInfo);
                }
                this.getReplicaInfo().getPhVmInfo().setBootVolumeUuid(this.pg.getPoProviderSN() + ":" + e.getParameters()[0]);
            }
            throw e;
        }
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }
}

