/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.openstack.protection.service.CreateRingTaskResult;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.OpenstackResourceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;
import java.util.concurrent.Callable;

public class CreateRingTask
implements Callable<CreateRingTaskResult> {
    private static Log logger = LogFactory.getInstance(CreateRingTask.class);
    private IVolumeService volumeService;
    private Map<String, PoReplicaInfo> poReplicaInfoMap;
    private ProtectGroup pg;
    private String ringSide;

    public CreateRingTask(IVolumeService volumeService, ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, String ringSide) {
        this.volumeService = volumeService;
        this.pg = pg;
        this.poReplicaInfoMap = poReplicaInfoMap;
        this.ringSide = ringSide;
    }

    @Override
    public CreateRingTaskResult call() {
        if (VerifyUtil.isEmpty(this.poReplicaInfoMap)) {
            logger.error((Object)("createReplicaRing:replicaList is empty,protectGroup name=" + this.pg.getName()), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Map pgProps = this.pg.getProps();
        String createRingType = null;
        VhaCsdrRingInfo ringInfo = new VhaCsdrRingInfo();
        ringInfo.setName(this.pg.getName());
        CreateRingTaskResult result = new CreateRingTaskResult();
        CreateVhaCsdrRingInfo ringCreateInfo = null;
        String ringIDType = "standbyDRRingUuid";
        try {
            String cgDRID;
            String cgID;
            String azName;
            String projUuid;
            String regionUuid;
            if ("ring_active".equals(this.ringSide)) {
                regionUuid = (String)pgProps.get("regionId");
                projUuid = (String)pgProps.get("projectId");
                azName = (String)pgProps.get("zoneName");
                cgID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("replicaCgUuid"));
                cgDRID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProCgUuid"));
                createRingType = "active";
                ringIDType = "prodRingID";
            } else if ("ring_hypermetor".equals(this.ringSide)) {
                regionUuid = (String)pgProps.get("regionId");
                projUuid = (String)pgProps.get("projectId");
                azName = (String)pgProps.get("zoneName");
                if (this.pg.getTemplate().getType() == 37) {
                    azName = (String)pgProps.get("prod_region_drZoneName");
                }
                cgID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProdrCgUuid"));
                cgDRID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProRemoteCgUuid"));
                createRingType = "hypermetro";
                ringIDType = "hyperDRRingID";
            } else {
                regionUuid = (String)pgProps.get("drRegionId");
                projUuid = (String)pgProps.get("drProjectId");
                azName = (String)pgProps.get("drZoneName");
                cgID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("drReplicaCgUuid"));
                cgDRID = OpenStackCommonUtil.getIdFromUuid((String)pgProps.get("hyperProRemotedrCgUuid"));
                createRingType = "remote";
                ringIDType = "standbyDRRingUuid";
            }
            logger.info((Object)("start create ring ringType=" + createRingType + ", replicaCGIDStr=" + cgID + " replicaDRCGIDStr=" + cgDRID + ", protectGroup name=" + this.pg.getName()));
            ringCreateInfo = this.getCreateVhaCsdrRingInfo(cgID, cgDRID, azName);
            ringInfo = this.volumeService.createReplicaRing(ringCreateInfo, regionUuid, projUuid);
            this.pg.getProps().put(ringIDType, ringInfo.getId());
            OpenStackCommonUtil.switchRing(ringInfo.getId(), true, regionUuid, projUuid);
            this.setResult(result, ringInfo, true);
            logger.info((Object)("create replication Ring ringType=" + createRingType + " sucessfully.replicationRingId=" + ringInfo.getId() + ", protectGroup name=" + this.pg.getName()));
        }
        catch (LegoCheckedException e) {
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                logger.error((Object)("create " + createRingType + " ring failed, ring id = " + e.getParameters()[0] + ",protectGroup name=" + this.pg.getName() + ", ringCreateInfo=" + ringCreateInfo + ", Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)));
                this.pg.getProps().put(ringIDType, e.getParameters()[0]);
            } else {
                logger.error((Object)("create " + createRingType + " ring failed,protectGroup name=" + this.pg.getName() + ", ringCreateInfo=" + ringCreateInfo + ", Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            this.setResult(result, ringInfo, false);
        }
        catch (Exception e) {
            logger.error((Object)("create " + createRingType + " ring failed,protectGroup name=" + this.pg.getName() + ", ringCreateInfo=" + ringCreateInfo + ", Exception:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.setResult(result, ringInfo, false);
        }
        return result;
    }

    private void setResult(CreateRingTaskResult result, VhaCsdrRingInfo ringInfo, boolean flag) {
        result.setVhaCsdrRingInfo(ringInfo);
        result.setResultFlag(flag);
    }

    private CreateVhaCsdrRingInfo getCreateVhaCsdrRingInfo(String cgID, String cgDRID, String azName) {
        CreateVhaCsdrRingInfo ringCreateInfo = new CreateVhaCsdrRingInfo();
        ringCreateInfo.setName(this.pg.getName());
        ringCreateInfo.setAzName(azName);
        ringCreateInfo.setDescription(this.pg.getName());
        ringCreateInfo.setSwapStrategy(OpenstackResourceUtil.getInstance().getValue("openstack_ring_switch_policy"));
        ringCreateInfo.setSwapTime(OpenstackResourceUtil.getInstance().getValue("openstack_ring_swap_time"));
        ringCreateInfo.setReplicationcgs(cgID + "," + cgDRID);
        return ringCreateInfo;
    }
}

