/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.Callable;

public class LockVMTask
implements Callable<Boolean> {
    private static Log logger = LogFactory.getInstance(LockVMTask.class);
    private String vmUuid;
    private String regionUuid;
    private String projectUuid;
    private ProtectGroup protectGroup;

    public LockVMTask(ProtectGroup protectGroup, String vmUuid, String projectUuid, String regionUuid) {
        this.protectGroup = protectGroup;
        this.vmUuid = vmUuid;
        this.projectUuid = projectUuid;
        this.regionUuid = regionUuid;
    }

    @Override
    public Boolean call() {
        String tokenId;
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(this.protectGroup.getPoProviderSN());
        AsyncTaskResponse response = novaMgr.unlockVm(this.regionUuid, tokenId = TokenUtil.getInstance().getTokenId(this.projectUuid), this.projectUuid, this.vmUuid);
        if (!response.isSuccess()) {
            logger.error((Object)"Unlock VMTask failed.Vmuuid=%s, protectGroup name=%s", new Object[]{this.vmUuid, this.protectGroup.getName()});
            return false;
        }
        return true;
    }
}

