/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.protection.service.ReattachProtectGroupVolumeBackTask;
import com.huawei.ism.drm.openstack.protection.service.UpdateProtectedVolumeBackTask;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectGroupVolStatusInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectGroupVolStatusVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackConsts;
import com.huawei.ism.drm.openstack.sdk.service.IOpenStackProtectionService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.base.thread.Enhancer;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IOpenStackProtectionService", Desc="", Interface=IOpenStackProtectionService.class)
public class OpenStackProtectionServiceImpl
extends BaseService
implements IOpenStackProtectionService {
    private static Log logger = LogFactory.getInstance(OpenStackProtectionServiceImpl.class);
    private IProtectGroupRefreshService pgRefreshService;

    public void updateVolumeInProtectGroup(String protectGroupId, Set<ProtectedVolumeInfo> removedVolumes, Set<ProtectedVolumeInfo> addedVolumes) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            throw new LegoCheckedException(1073947393L, "protectGroupId is empty");
        }
        if (VerifyUtil.isEmpty(removedVolumes) && VerifyUtil.isEmpty(addedVolumes)) {
            throw new LegoCheckedException(1073947393L, "there is no volume need to be update.");
        }
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        if (null == pg) {
            throw new LegoCheckedException(2117645L, "there is no ProtectGroup:" + protectGroupId);
        }
        UpdateProtectedVolumeBackTask task = new UpdateProtectedVolumeBackTask(pg, removedVolumes, addedVolumes);
        task.setPgRefreshService(this.pgRefreshService);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public String getPoVolumeInfos(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"protectGroup ID is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId);
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)("cant get pg info:protectGroupId=" + protectGroupId));
            return null;
        }
        HashMap<String, ProtectGroupVolStatusInfo> volStatusInfoMap = new HashMap<String, ProtectGroupVolStatusInfo>();
        for (ProtectObject po : pg.getPolist()) {
            String poReplicaInfoStr = (String)po.getProps().get("replicationInfo");
            if (VerifyUtil.isEmpty((String)poReplicaInfoStr)) continue;
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                logger.error((Object)("json str to bean failed:poReplicaInfoStr=" + poReplicaInfoStr));
                continue;
            }
            this.convertVolumeInfos(volStatusInfoMap, po, poReplicaInfo);
        }
        return JsonUtil.listToJsonArray(volStatusInfoMap.values());
    }

    public long reMappingVols(String protectGroupId, String userName) {
        if (VerifyUtil.isEmpty((String)userName)) {
            throw new LegoCheckedException(1073947393L, "userName is empty");
        }
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            throw new LegoCheckedException(1073947393L, "protectGroupId is empty");
        }
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        if (null == pg) {
            throw new LegoCheckedException(2117645L, "there is no ProtectGroup:" + protectGroupId);
        }
        if (!OpenstackConsts.OPENSTACK_NEEDREATTACH_TYPES.contains(pg.getTemplate().getType())) {
            logger.error((Object)("pg template type:" + pg.getTemplate().getType() + "not support remaping vols opt"));
            throw new LegoCheckedException(1073947453L);
        }
        ReattachProtectGroupVolumeBackTask task = new ReattachProtectGroupVolumeBackTask(pg, userName);
        task.setTaskId(pg.getUuid() + "_reMappingVol");
        return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    private void convertVolumeInfos(Map<String, ProtectGroupVolStatusInfo> volStatusInfoMap, ProtectObject po, PoReplicaInfo poReplicaInfo) {
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            String volUuid = pairInfo.getVolumeUuid();
            if (volStatusInfoMap.containsKey(volUuid)) {
                ProtectGroupVolStatusVmInfo vmInfo = new ProtectGroupVolStatusVmInfo(po.getUuid(), po.getName());
                volStatusInfoMap.get(volUuid).getVms().add(vmInfo);
                continue;
            }
            ProtectGroupVolStatusInfo volStatusInfo = new ProtectGroupVolStatusInfo(pairInfo.getVolumeUuid(), pairInfo.getVolumeName(), pairInfo.getVolumeType(), pairInfo.getVolumeStatus(), pairInfo.getDrVolumeType());
            ProtectGroupVolStatusVmInfo vmInfo = new ProtectGroupVolStatusVmInfo(po.getUuid(), po.getName());
            volStatusInfo.getVms().add(vmInfo);
            volStatusInfoMap.put(volUuid, volStatusInfo);
        }
    }

    public ProtectGroup getProtectGroupBasicInfo(String protectGroupId, boolean isQueryPos) {
        ProtectGroup pg = (ProtectGroup)OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_PROTECTGROUP_DATA, protectGroupId, Enhancer.timeSupplier((String)("get protectGroup by ID " + protectGroupId), () -> {
            ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, isQueryPos);
            return protectGroup;
        }));
        return pg;
    }

    public IProtectGroupRefreshService getPgRefreshService() {
        return this.pgRefreshService;
    }

    public void setPgRefreshService(IProtectGroupRefreshService pgRefreshService) {
        this.pgRefreshService = pgRefreshService;
    }
}

