/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.serviceinstance.checker.ConsistanceGroupCheck;
import com.huawei.ism.drm.openstack.serviceinstance.checker.HoldVmCheckChecker;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VmChecker;
import com.huawei.ism.drm.openstack.serviceinstance.checker.VmVolumCheckChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.alarm.AlarmGenerator;
import com.huawei.ism.drm.virtualization.sdk.service.IProtectGroupRefreshService;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

@ServiceBoundInfo(methodName="onBind", targetBeanName="protectGroupRefreshDelegate", properties="type:21##22##25##29")
public class OpenstackPgRefreshServiceImpl
implements IProtectGroupRefreshService {
    private static Log logger = LogFactory.getInstance(OpenstackPgRefreshServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshProtectGroup(ProtectGroup protectGroup) {
        logger.info((Object)"Begin to refresh openstack protectgroup:%s", new Object[]{protectGroup.getName()});
        if ("true".equals(protectGroup.getProps().get("OBJ_DELETE_ERROR"))) {
            logger.info((Object)("the protectgroup is invalid,cant refresh it,pgname=" + protectGroup.getName()));
            return;
        }
        String isManualRefresh = protectGroup.getProperty("isManualRefresh");
        if (!VerifyUtil.isEmpty((String)isManualRefresh) && String.valueOf(1).equals(isManualRefresh)) {
            this.refresh(protectGroup);
            return;
        }
        ProtectGroupHelper helper = ProtectGroupHelper.getInstance();
        try {
            helper.checkProtectGroupRefresh(protectGroup);
        }
        catch (Exception e) {
            logger.error((Object)("pg cant be refresh." + protectGroup.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return;
        }
        boolean isLockSuccess = ProtectionJobUtil.getInstance().getLockPg(protectGroup.getUuid());
        if (!isLockSuccess) {
            logger.error((Object)("The pg is locked: " + protectGroup.getName()), 90160758786893L);
            return;
        }
        try {
            this.refresh(protectGroup);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroup.getUuid());
            logger.debug((Object)("End to refresh protectgroup:" + protectGroup.getName()));
        }
        logger.debug((Object)("End to refresh protectgroup:" + protectGroup.getName()));
    }

    private ServiceInstance getServiceInstByPgId(String pgId) {
        Session session = null;
        List instList = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ServiceInstance.class);
            crit.add((Criterion)Restrictions.eq((String)"protectGroupId", (Object)pgId));
            instList = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        if (!VerifyUtil.isEmpty((Collection)instList)) {
            return (ServiceInstance)instList.get(0);
        }
        return null;
    }

    private void refresh(ProtectGroup protectGroup) {
        try {
            CheckContext context;
            boolean hasServiceIns;
            ServiceInstance inst = this.getServiceInstByPgId(protectGroup.getUuid());
            ArrayList<Object> checkerList = new ArrayList<Object>();
            boolean bl = hasServiceIns = null != inst;
            if (hasServiceIns) {
                context = new CheckContext(inst, protectGroup);
                checkerList.add(new VmChecker());
                checkerList.add(new HoldVmCheckChecker());
                checkerList.add(new ConsistanceGroupCheck());
                checkerList.add(new VmVolumCheckChecker());
            } else {
                context = new CheckContext(null, protectGroup);
                checkerList.add(new VmChecker());
                checkerList.add(new ConsistanceGroupCheck());
                checkerList.add(new VmVolumCheckChecker());
            }
            OpenstackCache.run(() -> {
                for (IServiceInstChecker checker : checkerList) {
                    checker.check(context);
                }
                return null;
            });
            String isManualRefresh = protectGroup.getProperty("isManualRefresh");
            if (!VerifyUtil.isEmpty((String)isManualRefresh) && String.valueOf(0).equals(isManualRefresh)) {
                protectGroup.getProps().remove("isManualRefresh");
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
            this.dealAlarm(context, protectGroup, hasServiceIns);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to update protectobject in Group(" + protectGroup.getName() + ") by consistence rules." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to update protectobject in Group(" + protectGroup.getName() + ") by unexpected exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            ExceptionUtil.rethrowException((Exception)e, (String)"fail to refresh pg", (long)0x300001L, (String[])new String[0]);
        }
    }

    private void dealHoldVmAlarm(Set<String> holdVmUnconfig, Set<String> holdVnUnMap, Set<String> holdVnUnExsit, ProtectGroup pg) {
        Set poList = pg.getPolist();
        for (ProtectObject po : poList) {
            String mouuid = po.getMoUuid();
            if (holdVmUnconfig.contains(mouuid)) {
                AlarmReporter.sendAlarm((long)52625453L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{pg.getUuid(), po.getUuid(), pg.getName(), po.getName(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
                continue;
            }
            AlarmReporter.restoreAlarm((long)52625453L, (String[])new String[]{pg.getUuid() + po.getUuid(), pg.getName(), po.getName()});
            if (holdVnUnExsit.contains(mouuid)) {
                AlarmReporter.sendAlarm((long)52625452L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{pg.getUuid(), po.getUuid(), pg.getName(), po.getName(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
                continue;
            }
            AlarmReporter.restoreAlarm((long)52625452L, (String[])new String[]{pg.getUuid() + po.getUuid(), pg.getName(), po.getName()});
            if (holdVnUnMap.contains(mouuid)) {
                AlarmReporter.sendAlarm((long)52625454L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{pg.getUuid(), po.getUuid(), pg.getName(), po.getName()});
                continue;
            }
            AlarmReporter.restoreAlarm((long)52625454L, (String[])new String[]{pg.getUuid() + po.getUuid(), pg.getName(), po.getName()});
        }
    }

    private Map<Long, Long> getAlarmIdMap(boolean hasServiceInst) {
        HashMap<Long, Long> alarmIdMap = new HashMap<Long, Long>();
        alarmIdMap.put(52625434L, 52625434L);
        alarmIdMap.put(52625447L, 52625447L);
        alarmIdMap.put(52625449L, 52625449L);
        if (hasServiceInst) {
            alarmIdMap.put(52625434L, 52625466L);
            alarmIdMap.put(52625447L, 52625467L);
            alarmIdMap.put(52625449L, 52625468L);
            alarmIdMap.put(52625422L, 52625469L);
            alarmIdMap.put(0x3230022L, 0x3230022L);
            alarmIdMap.put(52625441L, 52625441L);
            alarmIdMap.put(0x3230023L, 0x3230023L);
        }
        return alarmIdMap;
    }

    private void dealAlarm(CheckContext context, ProtectGroup pg, boolean hasServiceInst) {
        Set removedVmUuids = context.getRemovedVmUuids();
        Set unSupportedVmUuids = context.getUnSupportedPoUuids();
        Set volDelVmUuids = context.getVolDelVmUuids();
        Set volAddVmUuids = context.getVolAddVmUuids();
        List sharedVolumeNotInPgVmList = context.getSharedVolumeNotInPgVmList();
        Set cgIdNotInInsVmUuids = context.getCgIdNotInInsVmUuids();
        Set hyperCgIdNotInInsVmUiods = context.getHyperCgIdNotInInsVmUuid();
        Map cannotProtectVms = context.getCannotProtectVms();
        Map allVmUuidsMap = context.getAllVmUuidsMap();
        if (hasServiceInst) {
            Set holdVmUnconfig = context.getUnConfigHoldVmPo();
            Set holdVnUnMap = context.getHoldVmConfigUnMapPo();
            Set holdVnUnExsit = context.getUnExistedHoldVmPo();
            this.dealHoldVmAlarm(holdVmUnconfig, holdVnUnMap, holdVnUnExsit, pg);
        }
        Set cgStatusError = context.getCgStatusErrorIds();
        Set hyperCgStatusError = context.getHyperCgStatusErrorIds();
        Set hyperRemoteCgStatusError = context.getHyperRemoteStatusErrorIds();
        this.dealConsistGroupAlarm(pg, cgStatusError, hyperCgStatusError, hyperRemoteCgStatusError);
        Map<Long, Long> alarmIdMap = this.getAlarmIdMap(hasServiceInst);
        Set poList = pg.getPolist();
        HashSet<ProtectObject> removedVms = new HashSet<ProtectObject>();
        for (ProtectObject po : poList) {
            if (removedVmUuids.contains(po.getMoUuid())) {
                removedVms.add(po);
                continue;
            }
            this.dealUnspportRecoveryAlarms(po, pg, unSupportedVmUuids, alarmIdMap);
            if (!(volAddVmUuids.contains(po.getMoUuid()) || cgIdNotInInsVmUuids.contains(po.getMoUuid()) || hyperCgIdNotInInsVmUiods.contains(po.getMoUuid()))) {
                AlarmReporter.restoreAlarm((long)alarmIdMap.get(52625449L), (String[])new String[]{pg.getUuid() + po.getMoUuid()});
            } else if (!this.isUnprotectedBareMetalServerVolume(allVmUuidsMap, po)) {
                logger.error((Object)(po.getName() + " has not been protected"));
                AlarmReporter.sendAlarm((long)alarmIdMap.get(52625449L), (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{pg.getUuid() + po.getMoUuid(), pg.getName(), po.getName(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
            }
            if (cannotProtectVms.isEmpty() || !cannotProtectVms.containsKey(po.getMoUuid())) {
                AlarmReporter.restoreAlarm((long)52625491L, (String[])new String[]{pg.getUuid() + po.getMoUuid()});
            } else {
                String vmName = (String)cannotProtectVms.get(po.getMoUuid());
                if (null != vmName) {
                    AlarmReporter.sendAlarm((long)52625491L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{pg.getUuid() + po.getMoUuid(), pg.getName(), vmName});
                }
            }
            if (volDelVmUuids.isEmpty() || !volDelVmUuids.contains(po.getMoUuid())) {
                AlarmReporter.restoreAlarm((long)alarmIdMap.get(52625447L), (String[])new String[]{pg.getUuid() + po.getMoUuid()});
                continue;
            }
            OpenStackVM vm = (OpenStackVM)allVmUuidsMap.get(po.getMoUuid());
            if (null == vm) {
                logger.error((Object)"vm isn't in pg");
                continue;
            }
            AlarmReporter.sendAlarm((long)alarmIdMap.get(52625447L), (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{pg.getUuid() + po.getMoUuid(), pg.getName(), vm.getName(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
        }
        AlarmGenerator.sendPoRemoveAlarm((String)pg.getUuid(), (String)pg.getName(), removedVms, alarmIdMap);
        if (sharedVolumeNotInPgVmList.isEmpty()) {
            AlarmReporter.restoreAlarm((long)52625478L, (String[])new String[]{pg.getUuid()});
        } else {
            AlarmReporter.sendAlarm((long)52625478L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{pg.getUuid(), pg.getName(), sharedVolumeNotInPgVmList.toString(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
        }
    }

    private boolean isUnprotectedBareMetalServerVolume(Map<String, OpenStackVM> allVmUuidsMap, ProtectObject po) {
        OpenStackVM server = allVmUuidsMap.get(po.getMoUuid());
        if (null != server && OpenStackCommonUtil.isBareMetalServer(server)) {
            logger.info((Object)("there is a bare metal server: " + server.getName() + ", do not send alarm when unprotected volume existed."));
            return true;
        }
        return false;
    }

    private void dealUnspportRecoveryAlarms(ProtectObject po, ProtectGroup pg, Set<String> unSupportedVmUuids, Map<Long, Long> alarmIdMap) {
        if (!unSupportedVmUuids.contains(po.getMoUuid())) {
            AlarmReporter.restoreAlarm((long)alarmIdMap.get(52625434L), (String[])new String[]{pg.getUuid() + po.getMoUuid()});
        } else {
            AlarmReporter.sendAlarm((long)alarmIdMap.get(52625434L), (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{pg.getUuid() + po.getMoUuid(), po.getName(), pg.getName(), ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
        }
    }

    private void dealConsistGroupAlarm(ProtectGroup pg, Set<String> cgStatusError, Set<String> hyperCgStatusError, Set<String> hyperRemoteCgStatusError) {
        boolean result = this.isExistStatusError(cgStatusError, hyperCgStatusError, hyperRemoteCgStatusError);
        if (!result) {
            AlarmReporter.restoreAlarm((long)52625455L, (String[])new String[]{pg.getUuid()});
        } else {
            String cgId = this.getHyperMetroCg(pg);
            AlarmReporter.sendAlarm((long)52625455L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{pg.getUuid(), pg.getName(), cgId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getFrontInstanceType((String)((String)pg.getProps().get("serviceInstanceType")))});
        }
    }

    private boolean isExistStatusError(Set<String> cgStatusError, Set<String> hyperCgStatusError, Set<String> hyperRemoteCgStatusError) {
        return !cgStatusError.isEmpty() || !hyperCgStatusError.isEmpty() || !hyperRemoteCgStatusError.isEmpty();
    }

    private String getHyperMetroCg(ProtectGroup pg) {
        String cgId = (String)pg.getProps().get("hyperProCgUuid");
        if (VerifyUtil.isEmpty((String)cgId)) {
            cgId = (String)pg.getProps().get("replicaCgUuid");
        }
        return cgId;
    }
}

