/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:21##22")
public class OpenstackRateConfigServiceImpl
implements IRateConfigService {
    private static Log logger = LogFactory.getInstance(OpenstackRateConfigServiceImpl.class);

    public void modifyRate(DmEnumDefine.SPEED_LEVEL_E speedLevel, ProtectGroup pg, int protectionLocation) {
        logger.info((Object)("start to modify synchronization speed to :" + speedLevel.getValue()));
        IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Object)volumeService)) {
            logger.error((Object)"pg or volumeservice is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        volumeService.updateReplicationCGBandwidth(regionUuid, projUuid, cgUuid, speedLevel);
        logger.info((Object)"modify local replicaCG successfully");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        volumeService.updateReplicationCGBandwidth(drRegionUuid, drProjUuid, drCgUuid, speedLevel);
        logger.info((Object)" modify synchronization speed sucessfully");
    }
}

