/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.protection.service.ReattachVolumeTask;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ReattachProtectGroupVolumeBackTask
extends AbstractBackTask {
    private static Log logger = LogFactory.getInstance(ReattachProtectGroupVolumeBackTask.class);
    private ProtectGroup protectGroup;

    public ReattachProtectGroupVolumeBackTask(ProtectGroup protectGroup, String userName) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.pg.openstack.reattachVols", (String)userName, (String)"", null), true);
        this.protectGroup = protectGroup;
    }

    protected void doWork() {
        List reattachResultList;
        Set poSet = this.protectGroup.getPolist();
        ArrayList reattachTaskList = new ArrayList();
        for (ProtectObject po : poSet) {
            String replicationInfo = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                logger.error((Object)("json to bean error:replicaInfoStr=" + replicationInfo));
                continue;
            }
            ReattachVolumeTask task = new ReattachVolumeTask(poReplicaInfo);
            task.setIsHyperMetro(true);
            task.setIsDisasterReMappingVols(true);
            reattachTaskList.add(task);
        }
        if (VerifyUtil.isEmpty(reattachTaskList)) {
            logger.info((Object)"reattachTaskList is empty");
            return;
        }
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        int calculateTimeOut = OpenStackCommonUtil.calculateTaskTimeOut(reattachTaskList);
        if (calculateTimeOut > timeout) {
            timeout = calculateTimeOut;
        }
        if (VerifyUtil.isEmpty((Collection)(reattachResultList = ExecutionService.batchSubmit(reattachTaskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum))) || reattachResultList.size() != reattachTaskList.size()) {
            logger.error((Object)("reattach volume failed:result size=" + reattachResultList.size() + " task size" + reattachTaskList.size()));
            throw new LegoCheckedException(1073948106L);
        }
    }
}

