/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.observer;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.OpenstackPgRefreshServiceImpl;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.recovery.framework.task.FixedRecoveryThreadPool;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class RecoveryPlanOperateObserver
implements IObjectObserver {
    private static Log logger = LogFactory.getInstance(RecoveryPlanOperateObserver.class);
    private static Map<String, String> statusMap = new HashMap<String, String>();

    public void before(MessageEvent event) {
        logger.info((Object)"enter before RecoveryPlanOperateObserver");
        this.changeStatus(event, "before");
    }

    public void after(MessageEvent event) {
        this.changeStatus(event, "after");
    }

    public String getObserverType() {
        return RecoveryPlan.class.getName();
    }

    private void changeStatus(MessageEvent event, String notifyType) {
        Map messageMap = event.getMessageMap();
        Object type = messageMap.get("message_event_excute_type");
        logger.info((Object)("MESSAGEEVENT_EXECUTE_TYPE " + type));
        if (null == type || !(type instanceof DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)) {
            logger.info((Object)"excute type is not right");
            return;
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E excuteType = (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type;
        DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE opreateType = DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.getType((int)excuteType.getValue());
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        int messageType = event.getMessageType();
        DRMObject object = (DRMObject)CommonUtil.getFirstElement((Collection)objectList);
        if (!(object instanceof RecoveryPlan)) {
            return;
        }
        RecoveryPlan recoveryPlan = (RecoveryPlan)object;
        ProtectGroup protectGroup = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        String instanceId = (String)protectGroup.getProps().get("SERVICEINSTANCE_UUID");
        if (VerifyUtil.isEmpty((String)instanceId)) {
            logger.info((Object)"change instance status on recoveryPlan excute : instanceId is null");
            return;
        }
        ServiceInstance instance = this.getServiceInstanceById(instanceId);
        if (messageType == 7) {
            this.updateRecoveryPropsForPg(recoveryPlan, opreateType);
        }
        if (!this.isNeedModify(instance, protectGroup, excuteType)) {
            this.setCshaCsdrStatusForExternal(excuteType, protectGroup);
            logger.info((Object)("change instance status : replica model is not replication," + instance.getType()));
            return;
        }
        if (messageType == 6) {
            if ("before".equals(notifyType)) {
                this.beforeChangeStatus(instance, opreateType);
                ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).saveOrUpdateProtectGroupProps(recoveryPlan.getProtectGroup().getUuid(), recoveryPlan.getProtectGroup().getProps());
            } else if ("after".equals(notifyType)) {
                String projectId = null;
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == excuteType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == excuteType.getValue()) {
                    String projectUuid = (String)protectGroup.getProps().get("projectId");
                    projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
                }
                this.afterChangeInstance(recoveryPlan, instance, projectId);
                this.setCshaCsdrStatusForExternal(excuteType, protectGroup);
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == excuteType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == excuteType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() == excuteType.getValue() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(protectGroup)) {
                    this.asyncRefreshInstance(instance);
                } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == excuteType.getValue()) {
                    OpenStackRecoveryTool.operateReplicationFlagOfPg(protectGroup, true);
                }
            }
        } else if (messageType == 7) {
            this.checkOperatePermission(excuteType, opreateType, recoveryPlan, instance);
            this.checkPhVmExist(recoveryPlan, opreateType);
            this.checkReplicationStatus(protectGroup, opreateType, recoveryPlan);
            this.checkInstanceAlarms(excuteType, protectGroup, instance);
        }
    }

    private void checkInstanceAlarms(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E excuteType, ProtectGroup protectGroup, ServiceInstance instance) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == excuteType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == excuteType.getValue()) {
            String entityId = "10x3230046" + protectGroup.getUuid();
            if (((IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class)).hasUnclearedAlarm(entityId)) {
                logger.error((Object)"Can not execute recovery plan of %s, instance has uncleared alarm.", new Object[]{instance.getName()});
                throw new LegoCheckedException(1073949737L, new String[]{instance.getName()});
            }
        }
    }

    private void setCshaCsdrStatusForExternal(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E excuteType, ProtectGroup protectGroup) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == excuteType.getValue() && PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(protectGroup)) {
            ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).updateProtectGroupStatus(DrmEnumDefine.PROTECT_GROUP_STATUS.NORMAL, new String[]{protectGroup.getUuid()});
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == excuteType.getValue() && PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(protectGroup)) {
            IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
            service.resumeTasks(protectGroup.getUuid());
        }
    }

    private void checkOperatePermission(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E excuteType, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE opreateType, RecoveryPlan recoveryPlan, ServiceInstance instance) {
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String key = RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.getType((String)instance.getStatus()), opreateType);
        if (VerifyUtil.isEmpty((String)statusMap.get(key))) {
            logger.error((Object)("instance( " + instance.getId() + " ) not allow the operation.instance status:" + instance.getStatus() + " operation type:" + opreateType.getValue()));
            throw new LegoCheckedException(1073948693L);
        }
        if ((37 != protectGroup.getTemplate().getType() || OpenStackCommonUtil.isCsdrCshaMode(protectGroup)) && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.equals((Object)DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus())) && excuteType.getValue() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue()) {
            throw new LegoCheckedException(1073948693L);
        }
    }

    private void asyncRefreshInstance(final ServiceInstance instance) {
        FixedRecoveryThreadPool.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                RecoveryPlanOperateObserver.this.refreshInstance(instance);
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshInstance(ServiceInstance instance) {
        String instanceId = instance.getId();
        if (!ServiceInstanceHelper.getInstance().getLock(instanceId)) {
            logger.error((Object)"Failed to refresh instance.can not get this instance lock,instanceId:%s,instanceName=%s", new Object[]{instanceId, instance.getName()});
            throw new LegoCheckedException(1073948693L);
        }
        try {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            instance = this.getServiceInstanceById(instanceId);
            if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue().equals(instance.getStatus())) {
                logger.error((Object)"Instance name:%s status:%s not normal,", new Object[]{instance.getName(), instance.getStatus()});
                throw new LegoCheckedException(1073948693L);
            }
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            ProtectGroup protectGroup = pgService.getProtectGroupByID(instance.getProtectGroupId(), true);
            if (null == protectGroup) {
                logger.error((Object)"Failed to refresh instance .protectGroup is null. protectGroupId=%s, instanceName=%s", new Object[]{instance.getProtectGroupId(), instance.getName()});
                throw new LegoCheckedException(2117645L);
            }
            logger.debug((Object)"refresh instance. the inst status:%s,instanceName=%s,pg status:%s", new Object[]{instance.getStatus(), instance.getName(), protectGroup.getStatus()});
            protectGroup.getProps().remove("isManualRefresh");
            OpenstackPgRefreshServiceImpl refreshService = new OpenstackPgRefreshServiceImpl();
            refreshService.refreshProtectGroup(protectGroup);
        }
        finally {
            ServiceInstanceHelper.getInstance().releaseLock(instanceId);
        }
    }

    private boolean isNeedModify(ServiceInstance instance, ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E excuteType) {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(instance.getType()) && !"csha_csdr".equals(instance.getProtectType())) {
            return true;
        }
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO.getValue().equals(instance.getType()) || PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == excuteType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() == excuteType.getValue()) {
                ServiceInstanceHelper.getInstance().checkServiceInstPoInfo(instance);
                return true;
            }
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == excuteType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == excuteType.getValue()) {
                String regionUuid = pg.getProperty("regionId");
                return !RecoveryPlanOperateObserver.isAutoExe(OpenStackBasicUtil.getIdFromUuid(regionUuid));
            }
            return true;
        }
        return true;
    }

    private void checkPhVmExist(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE type) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        HashSet<DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE> cshaCsdrCheckType = new HashSet<DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE>(Arrays.asList(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION));
        if (37 == pg.getTemplate().getType() && cshaCsdrCheckType.contains(type)) {
            String phVmDrRegion = pg.getProperty("drRegionId");
            String phVmDrProjectUuid = pg.getProperty("drProjectId");
            String cshaPhVmRegion = OpenStackCommonUtil.isCsdrCshaMode(pg) ? phVmDrRegion : pg.getProperty("regionId");
            String cshaPhVmProjectUuid = OpenStackCommonUtil.isCsdrCshaMode(pg) ? phVmDrProjectUuid : pg.getProperty("projectId");
            Set<String> cshaOpenstackVmSet = this.getOpenStackVmSet(cshaPhVmRegion, cshaPhVmProjectUuid);
            this.checkIsVmExist(recoveryPlan, "CSHAPLACEHOLDVM", cshaOpenstackVmSet);
            Set<String> phVmOpenstackVmSet = this.getOpenStackVmSet(phVmDrRegion, phVmDrProjectUuid);
            this.checkIsVmExist(recoveryPlan, "PLACEHOLDVM", phVmOpenstackVmSet);
            return;
        }
        HashSet<DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE> needCheckType = new HashSet<DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE>(Arrays.asList(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION));
        if (!needCheckType.contains(type)) {
            return;
        }
        boolean isWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        String regionUuid = isWithinRegionRecovery ? pg.getProperty("regionId") : (String)pg.getProps().get("drRegionId");
        String projectUuid = isWithinRegionRecovery ? pg.getProperty("projectId") : (String)pg.getProps().get("drProjectId");
        Set<String> openstackVmSet = this.getOpenStackVmSet(regionUuid, projectUuid);
        String vmTab = isWithinRegionRecovery ? "CSHAPLACEHOLDVM" : "PLACEHOLDVM";
        this.checkIsVmExist(recoveryPlan, vmTab, openstackVmSet);
    }

    private void checkIsVmExist(RecoveryPlan recoveryPlan, String vmTab, Set<String> openstackVmSet) {
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        for (ProtectObject po : pg.getPolist()) {
            if (ProtectObjectStatusEnum.INVALID.getValue() == po.getPoStatus()) continue;
            String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(recoveryPlan, po, vmTab);
            if (VerifyUtil.isEmpty((String)phVmUuid)) {
                logger.error((Object)("no set PhVm, srcVm uuid is: " + po.getMoUuid()));
                throw new LegoCheckedException(1073948908L, "no set PhVm, srcVm uuid is: " + po.getMoUuid());
            }
            if (openstackVmSet.contains(phVmUuid)) continue;
            logger.error((Object)("PhVm does not exist, PhVm uuid is: " + phVmUuid));
            throw new LegoCheckedException(1073948375L, "PhVm does not exist, PhVm uuid is: " + phVmUuid);
        }
    }

    private Set<String> getOpenStackVmSet(String regionUuid, String projectUuid) {
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        List<OpenStackVM> openstackVmList = novaMgr.getVms(regionUuid, tokenId, projectUuid);
        HashSet<String> openstackVmSet = new HashSet<String>();
        for (OpenStackVM vm : openstackVmList) {
            openstackVmSet.add(vm.getUuid());
        }
        return openstackVmSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeChangeStatus(ServiceInstance instance, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE type) {
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        logger.info((Object)"change instance status before excute.");
        if (!instanceHelper.getLock(instance.getId())) {
            logger.error((Object)("get instance( " + instance.getId() + " ) lock faild."));
            throw new LegoCheckedException(1073948693L);
        }
        try {
            ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E status = ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.getType((String)statusMap.get(RecoveryPlanOperateObserver.generateBeforeKey(type)));
            instanceHelper.changeStatus(instance.getId(), status);
        }
        finally {
            instanceHelper.releaseLock(instance.getId());
        }
    }

    private void afterChangeInstance(RecoveryPlan recoveryPlan, ServiceInstance instance, String projectId) {
        ServiceInstanceHelper instanceHelper = ServiceInstanceHelper.getInstance();
        logger.info((Object)"change instance status after excute.");
        if (!instanceHelper.getLock(instance.getId())) {
            logger.error((Object)("get instance( " + instance.getId() + " ) lock faild."));
            throw new LegoCheckedException(1073948693L);
        }
        try {
            instance = this.getServiceInstanceById(instance.getId());
            if (!VerifyUtil.isEmpty((String)projectId)) {
                instance.setProjectId(projectId);
            }
            recoveryPlan = this.getRecoveryPlanById(recoveryPlan.getPlanId());
            DrmEnumDefine.RECOVERY_PLAN_STATUS_E recoveryStatus = DrmEnumDefine.RECOVERY_PLAN_STATUS_E.getType((int)recoveryPlan.getPlanStatus());
            logger.info((Object)(recoveryPlan.getName() + " afterExcute recoveryStatus:" + recoveryStatus));
            ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E inStatus = ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.getType((String)statusMap.get(RecoveryPlanOperateObserver.generateAfterKey(recoveryStatus)));
            logger.info((Object)(instance.getName() + " afterExcute inStatus:" + inStatus));
            if (!VerifyUtil.isEmpty((Object)inStatus)) {
                instance.setStatus(inStatus.getValue());
            }
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)instance);
        }
        catch (Exception e) {
            logger.error((Object)("save instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, "save instance error.", (Throwable)e);
        }
        finally {
            instanceHelper.releaseLock(instance.getId());
        }
    }

    private ServiceInstance getServiceInstanceById(String instanceId) {
        ServiceInstance instance = (ServiceInstance)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ServiceInstance.class, (Serializable)((Object)instanceId));
        if (null == instance) {
            logger.error((Object)"instance is empty.");
            throw new LegoCheckedException(201L, "instance is empty.");
        }
        return instance;
    }

    private RecoveryPlan getRecoveryPlanById(String recoveryPlanId) {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan plan = recoveryPlanService.getRecoveryPlan(recoveryPlanId, false, false);
        if (null == plan) {
            logger.error((Object)"instance is empty.");
            throw new LegoCheckedException(201L, "instance is empty.");
        }
        return plan;
    }

    private static String generateBeforeKey(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE operation) {
        if (null == operation) {
            logger.error((Object)"RECOVERY_PLAN_OPERATION_TYPE is null");
            throw new LegoCheckedException(1073947393L, "operationE is null.");
        }
        return "before:" + operation.getValue();
    }

    private static String generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E status) {
        if (null == status) {
            logger.error((Object)"RECOVERY_PLAN_STATUS_E is null");
            throw new LegoCheckedException(1073947393L, "status is null.");
        }
        return "after:" + status.getValue();
    }

    private static String generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E status, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE operation) {
        if (null == status || null == operation) {
            logger.error((Object)"status or operation is null");
            throw new LegoCheckedException(1073947393L, "operation or status is null.");
        }
        return "check:" + status.getValue() + ":" + operation.getValue();
    }

    public static boolean isAutoExe(String regionId) {
        String autoRecoveryValue;
        boolean result = true;
        ICloudConfigService cloudService = (ICloudConfigService)ServiceLocator.getInstance().getService(ICloudConfigService.class);
        CloudConfig config = cloudService.getCloudConfigBy("system");
        if (null != config && null != config.getProps() && !VerifyUtil.isEmpty((String)(autoRecoveryValue = (String)config.getProps().get(regionId + "_" + "system_autorecovery")))) {
            result = Boolean.valueOf(autoRecoveryValue);
        }
        return result;
    }

    private void checkReplicationStatus(ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE operation, RecoveryPlan recoveryPlan) {
        HashSet<DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE> cshaCsdrCheckType = new HashSet<DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE>(Arrays.asList(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION));
        if (37 == pg.getTemplate().getType() && cshaCsdrCheckType.contains(operation)) {
            List<String> availableReplicationRepStatus = Arrays.asList(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue(), OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue(), OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue());
            String hyperReplicaCgUuid = pg.getProperty("hyperProdrCgUuid");
            String drReplicaCgUuid = pg.getProperty("drReplicaCgUuid");
            VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.getVolumeReplicaCgInfoForHyperMetro(pg, false);
            if (null == cgInfo || !OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cgInfo.getStatus())) {
                logger.error((Object)"Hypermetro cg: %s is null or replication status is not available", new Object[]{hyperReplicaCgUuid});
                throw new LegoCheckedException(1073949707L, new String[]{OpenStackCommonUtil.getIdFromUuid(hyperReplicaCgUuid)});
            }
            if (!availableReplicationRepStatus.contains(cgInfo.getReplicationStatus())) {
                logger.error((Object)"Hypermetro cg: %s replication rep status is(%s) not normal\uff08active\\active-stop\uff09", new Object[]{hyperReplicaCgUuid, cgInfo.getReplicationStatus()});
                throw new LegoCheckedException(1073949707L, new String[]{OpenStackCommonUtil.getIdFromUuid(hyperReplicaCgUuid)});
            }
            cgInfo = OpenStackCommonUtil.getVolumeReplicationCgInfo(pg, false, new int[0]);
            if (null == cgInfo || !OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cgInfo.getStatus())) {
                logger.error((Object)"Replicate cg: %s is null or replication status is not available", new Object[]{drReplicaCgUuid});
                throw new LegoCheckedException(1073949708L, new String[]{OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid)});
            }
            if (!availableReplicationRepStatus.contains(cgInfo.getReplicationStatus())) {
                logger.error((Object)"Replicate cg: %s replication rep status is(%s) not normal\uff08active\\standby\\active-stop\uff09", new Object[]{drReplicaCgUuid, cgInfo.getReplicationStatus()});
                throw new LegoCheckedException(1073949708L, new String[]{OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid)});
            }
            return;
        }
        if (!DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING.equals((Object)operation) && !DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION.equals((Object)operation) || 21 != pg.getTemplate().getType()) {
            return;
        }
        HashSet<Integer> needCheckStatus = new HashSet<Integer>(Arrays.asList(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED.getValue(), DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED.getValue()));
        if (!needCheckStatus.contains(recoveryPlan.getPlanStatus())) {
            logger.debug((Object)"pg name is:%s,recoveryPlan:%s status:%s not normal,no need checkReplicationStatus", new Object[]{pg.getName(), recoveryPlan.getName(), recoveryPlan.getPlanStatus()});
            return;
        }
        String replicationStatus = OpenStackCommonUtil.getRealTimeCGReplicaStatus(pg);
        if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(replicationStatus)) {
            logger.debug((Object)("pg name is" + pg.getName() + ",replica's replicaionstatus is " + replicationStatus + "can't excute planed-motion or test."));
            throw new LegoCheckedException(1073947722L);
        }
    }

    private void updateRecoveryPropsForPg(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE procType) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (37 != pg.getTemplate().getType()) {
            return;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == procType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == procType.getValue()) {
            OpenStackRecoveryTool.setRecoveryRegionForCshaCsdrPg(pg, null, null, null);
        }
        String recoveryRegion = (String)recoveryPlan.getGlobalSettings().get("recovery_region_id");
        String recoveryAz = (String)recoveryPlan.getGlobalSettings().get("recovery_az_id");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == procType.getValue() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == procType.getValue()) {
            OpenStackRecoveryTool.setRecoveryRegionForCshaCsdrPg(pg, recoveryRegion, this.getExecuteRecoveryRegionType(recoveryPlan, procType, pg, recoveryRegion), recoveryAz);
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() == procType.getValue()) {
            OpenStackRecoveryTool.setRecoveryRegionForCshaCsdrPg(pg, OpenStackCommonUtil.getIdFromUuid(pg.getProperty("regionId")), "REGION_TYPE_WITHIN", OpenStackCommonUtil.getIdFromUuid(pg.getProperty("prod_region_drZoneName")));
        }
    }

    private String getExecuteRecoveryRegionType(RecoveryPlan recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE procType, ProtectGroup pg, String recoveryRegion) {
        String currentRegion = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("regionId"));
        String recoveryRegionType = recoveryRegion.equals(currentRegion) ? "REGION_TYPE_WITHIN" : "REGION_TYPE_BETWEEN";
        String currentDisasterRegion = OpenStackCommonUtil.getIdFromUuid(pg.getProperty("current_disaster_region"));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == procType.getValue() && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            recoveryRegionType = "REGION_TYPE_BETWEEN";
            pg.setProperty("IsSecondDisasterRecovery", (Object)"true");
        } else if (!VerifyUtil.isEmpty((String)currentDisasterRegion) && DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue() == recoveryPlan.getPlanStatus() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == procType.getValue()) {
            recoveryRegionType = recoveryRegion.equals(currentDisasterRegion) ? "REGION_TYPE_WITHIN" : "REGION_TYPE_BETWEEN";
        }
        return recoveryRegionType;
    }

    static {
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.CLEARING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.CLEAN_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_CLEAR.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.TEST_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_TEST.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_COMPLETED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.PLANED_MOTION_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.HOT_MIGRATION_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.HOT_MIGRATION_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.REPROTECT_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_RUNNING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_COMPLETED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateAfterKey(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.DISASTER_RECOVERY_FAILED), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTED, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_CLEAR, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateCheckKey(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.ERR_TEST, DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), "1");
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DISASTER_RECOVERY), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.REPROTECT), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.PLANED_MOTION), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.HOT_MIGRATION), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_RUNNING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.DRILLING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.TESTING.getValue());
        statusMap.put(RecoveryPlanOperateObserver.generateBeforeKey(DrmEnumDefine.RECOVERY_PLAN_OPERATION_TYPE.CLEAN_DRILLING), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.CLEARING.getValue());
    }
}

