/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTask;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AttachVolTaskQueue {
    private static final Log logger = LogFactory.getInstance(AttachVolTaskQueue.class);
    private BlockingQueue<AttachVolTask> queue = new LinkedBlockingQueue<AttachVolTask>();
    private Set<String> volumeInAttaching = Collections.synchronizedSet(new HashSet());
    private boolean isRunning = true;

    protected void start() {
        this.isRunning = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (AttachVolTaskQueue.this.isRunning) {
                    AttachVolTask task = new AttachVolTask();
                    try {
                        task = (AttachVolTask)AttachVolTaskQueue.this.queue.take();
                        if (AttachVolTaskQueue.this.volumeInAttaching.contains(task.getVolumeId())) {
                            AttachVolTaskQueue.this.reAddTask(task);
                            continue;
                        }
                        logger.debug((Object)(task.getVolumeId() + " submit to task pool.target vm is " + task.getVmUuid()));
                        AttachVolTaskQueue.this.volumeInAttaching.add(task.getVolumeId());
                        task.setTaskManager(AttachVolTaskQueue.this);
                        ExecutionService.submitTask((Runnable)task);
                    }
                    catch (Exception e) {
                        logger.error((Object)(task.getVolumeId() + " error." + ExceptionUtil.getErrorMessage((Throwable)e)));
                        AttachVolTaskQueue.this.volumeInAttaching.remove(task.getVolumeId());
                        AttachVolTaskQueue.this.reAddTask(task);
                    }
                }
            }
        }).start();
    }

    private void reAddTask(AttachVolTask task) {
        if (!this.queue.offer(task)) {
            logger.error((Object)(task.getVolumeId() + " readd to queue error."));
            task.setStatus(2);
        }
    }

    protected void stop() {
        this.isRunning = false;
    }

    protected boolean push(AttachVolTask task) {
        logger.debug((Object)(task.getVolumeId() + " add to queue. target vm is " + task.getVmUuid()));
        return this.queue.offer(task);
    }

    protected void markTaskCompleted(String volId) {
        logger.debug((Object)(volId + " is end to attach."));
        this.volumeInAttaching.remove(volId);
    }
}

