/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTask;
import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTaskQueue;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackAttachVolToVMProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3863861299455306336L;
    private static final Log logger = LogFactory.getInstance(OpenStackAttachVolToVMProcessor.class);

    public OpenStackAttachVolToVMProcessor() {
    }

    public OpenStackAttachVolToVMProcessor(String volumeUuid, String volName, String volStatus, String vmUuid, String projUuid, String regionUuid) {
        this.addString("volUuid", volumeUuid);
        this.addString("volName", volName);
        this.addString("volStatus", volStatus);
        this.addString("vmUuid", vmUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into AttachVolumeToVMProcessor");
        String volumeUuid = this.getString("volUuid");
        String deviceName = this.getString("deviceName");
        String volName = this.getString("volName");
        String volStatus = this.getString("volStatus");
        String projUuid = this.getString("projUuid");
        String regionUuid = this.getString("regionUuid");
        String vmUuid = this.getString("vmUuid");
        String vmType = this.getString("vmType");
        String attachPoint = deviceName;
        logger.info((Object)("attach volume to vm: " + vmUuid + ", type: " + vmType));
        if ("BMS".equals(vmType)) {
            OpenStackVM drVm = OpenStackCommonUtil.getServerByUuid(projUuid, regionUuid, vmUuid);
            attachPoint = null == drVm ? "" : drVm.getName();
            logger.info((Object)("attach volume to bms: " + attachPoint));
        }
        this.updateProcessNameParams(new String[]{volName, VerifyUtil.isEmpty((String)attachPoint) ? "UNKNOWN" : attachPoint});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.REMOVED.getStatus().equals(volStatus) || OpenstackEnumDefine.VOL_PROTECT_STATUS_E.RELEASING.getStatus().equals(volStatus)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("openstackattachvoltovmprocessor.vol.status.removed", null);
            logger.error((Object)("vol status is error and it is " + volStatus));
            return true;
        }
        if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(volStatus) || OpenstackEnumDefine.VOL_PROTECT_STATUS_E.CONFIGING.getStatus().equals(volStatus)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("openstackattachvoltovmprocessor.vol.status.unportected", null);
            logger.error((Object)("vol status is error and it is " + volStatus));
            return true;
        }
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
        if (null == vm) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948375", null);
            logger.error((Object)("placeholder vm(" + vmUuid + ") doesn't exits."));
            return false;
        }
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        VolumeInfo volumeInfo = volService.queryVolumeInfoByUuid(regionUuid, projUuid, volumeUuid);
        if (VerifyUtil.isEmpty((Object)volumeInfo)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.2117645", null);
            logger.error((Object)("the volume(" + volumeUuid + ")is not exist"));
            return false;
        }
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        for (VolumeAttachmentInfo attachmentInfo : volumeInfo.getAttachments()) {
            if (!attachmentInfo.getServerId().equals(serverId) || !OpenstackEnumDefine.VOLUME_STATUS_E.INUSE.getType().equals(volumeInfo.getStatus())) continue;
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            logger.info((Object)("vol(" + volumeUuid + ") is areadly attached to vm(" + vm.getName() + ")"));
            return true;
        }
        return this.reTryTask(context, projUuid, regionUuid, vmUuid, vmType, volumeUuid, deviceName);
    }

    private boolean reTryTask(RecoveryProcessorContext context, String projUuid, String regionUuid, String vmUuid, String vmType, String volumeUuid, String deviceName) {
        AttachVolTaskQueue attachVolTaskQueue = (AttachVolTaskQueue)context.getAttribute("AttachVolTaskQueue");
        AttachVolTask task = new AttachVolTask(projUuid, regionUuid, vmUuid, vmType, OpenStackCommonUtil.getIdFromUuid(volumeUuid), deviceName);
        if (null == attachVolTaskQueue || !attachVolTaskQueue.push(task)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.3145729", null);
            logger.error((Object)"add task to AttachVolTaskQueue failed.");
            return true;
        }
        for (int reTryTimes = 30; reTryTimes > 0; --reTryTimes) {
            if (0 == task.getStatus()) {
                CommUtil.pauseThread((long)20000L);
                continue;
            }
            if (1 == task.getStatus()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                logger.info((Object)("attach volume to vm(" + vmUuid + ") success.reTryTimes=" + reTryTimes));
                return true;
            }
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err." + task.getErrorCode(), task.getErrorParam());
            logger.error((Object)("attach volume to vm(" + vmUuid + ") failed.reTryTimes=" + reTryTimes));
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail("com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachVolToVMProcessor.timout", null);
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getName() {
        String volStatus = this.getString("volStatus");
        if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(volStatus)) {
            return ((Object)((Object)this)).getClass().getName() + ".error";
        }
        return ((Object)((Object)this)).getClass().getName();
    }
}

