/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;

public class OpenStackCheckDataConsistencyProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6033983210489674659L;
    private static final long[] STATUS_QUERY_SLEEP_QUEUE = new long[]{3000L, 5000L, 8000L, 12000L, 17000L, 17000L, 12000L, 8000L, 5000L, 3000L};
    private static Log logger = LogFactory.getInstance(OpenStackCheckDataConsistencyProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("Enter into OpenStackCheckDataStatusProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String drReplicaCgUuid = OpenStackCommonUtil.getIdFromUuid(OpenStackRecoveryTool.getDrReplicaCgUuid(pg));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        String replicationStatus = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.UNKNOWN.getValue();
        for (long sleepTime : STATUS_QUERY_SLEEP_QUEUE) {
            VolumeReplicationCgInfo cgInfo = OpenStackCommonUtil.isCurrentFCVersionHighThan63() ? mgr.queryRealtimeVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid), new int[0]) : mgr.queryVolumeReplicationCG(drRegionUuid, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drReplicaCgUuid));
            if (null == cgInfo) {
                logger.error((Object)("replica is null,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948906", null);
                return false;
            }
            replicationStatus = cgInfo.getReplicationStatus();
            String status = cgInfo.getStatus();
            if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(status)) {
                logger.error((Object)("replica's status is not avaiable.,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948906", null);
                return false;
            }
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) {
                logger.info((Object)("Leave OpenStackCheckDataStatusProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() != this.getProcType() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() != this.getProcType() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() != this.getProcType()) continue;
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(replicationStatus)) {
                logger.info((Object)("replica's replicaionstatus is " + replicationStatus));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            logger.warn((Object)("replica's replicaionstatus is not active: " + replicationStatus + ",recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
            CommonUtil.sleep((long)sleepTime);
        }
        logger.info((Object)("time out, Leave OpenStackCheckDataStatusProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail("lego.err." + OpenstackEnumDefine.REPLICATION_REP_STATUS_E.getErrorCode((String)replicationStatus), null);
        return false;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.des");
        } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.dr.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.test.des");
        }
    }
}

