/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackConfigPhVmToNormalVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6050745805347843003L;
    private static Log logger = LogFactory.getInstance(OpenStackConfigPhVmToNormalVmSubProcessor.class);

    public OpenStackConfigPhVmToNormalVmSubProcessor() {
    }

    public OpenStackConfigPhVmToNormalVmSubProcessor(String vmUuid, String vmName, String drRegionUuid, String drProjUuid) {
        this.addString("vmUuid", vmUuid);
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        this.addString("vmName", vmName);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into SetPHVmToNormalVmProcessor");
        String vmUuid = this.getString("vmUuid");
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)vmUuid)) {
            logger.error((Object)"placeholder vm isn't setted.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        try {
            AsyncTaskResponse response;
            OpenStackVM vm = novaMgr.getVm(drRegionUuid, tokenId, drProjUuid, vmUuid, new int[0]);
            if (null == vm) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)("placeholder vm(" + vmUuid + "doesn't exit."));
                this.updateProcessDetail("lego.err.1073948375", null);
                return false;
            }
            boolean isBmsServer = OpenStackCommonUtil.isBareMetalServer(vm);
            logger.info((Object)("config ph vm to normal vm, check if vm is bms: " + isBmsServer));
            if (!isBmsServer && vm.getStatus().intValue() == OpenstackEnumDefine.VM_STATUS_E.ACTIVE.getValue()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)("placeholder vm(" + vmUuid + ") already started."));
                this.updateProcessDetail("lego.err.1073948907", null);
                return false;
            }
            this.updateVmTag(vmUuid, drRegionUuid, drProjUuid, novaMgr, tokenId);
            if (!isBmsServer && !(response = novaMgr.unlockVm(drRegionUuid, tokenId, drProjUuid, vmUuid)).isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                logger.error((Object)("set OpenstackVm from placehoder to normal failed, errorcode is" + response.getErrorCode()));
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)"set OpenstackVm from placehoder to normal failed");
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave SetPHVmToNormalVmProcessor");
        return true;
    }

    private void updateVmTag(String vmUuid, String drRegionUuid, String drProjUuid, NovaManager novaMgr, String tokenId) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            try {
                novaMgr.deleteTagFromVm(drRegionUuid, tokenId, drProjUuid, vmUuid, "__type_dr");
                novaMgr.addTagToVm(drRegionUuid, tokenId, drProjUuid, vmUuid, "__type_pd");
            }
            catch (Exception e) {
                logger.error((Object)("update tag on vm (" + vmUuid + ") failed."), (Throwable)e);
            }
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

