/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigVmToPhVmProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachVolProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReserveVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackShutDownVmProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.cshacsdr.OpenStackSwitchHyperPortProcessor;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OpenStackConfigReSetVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6947095705414105969L;
    private static final Log logger = LogFactory.getInstance(OpenStackConfigReSetVmProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackConfigReSetVmProcessor recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProc(context);
        }
        logger.debug((Object)("OpenStackConfigReSetVmProcessor complete sub.recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        if (null == recoveryTemplate) {
            logger.info((Object)"recoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        logger.debug((Object)("leave OpenStackConfigReSetVmProcessor recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        logger.info((Object)("OpenStackConfigReSetVmProcessor get status. recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType()) {
            return true;
        }
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == procStatus.getValue();
    }

    private void updateSubProc(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.generateSubProcessorsForCleanDrilling(subProcessors);
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
            this.generateSubProcessorsForReprotected(context, subProcessors);
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType()) {
            this.generateSubProcessorsForPlanMotion(context, subProcessors);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateSubProcessorsForPlanMotion(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcessors) {
        OpenStackDetachVolProcessor detachVolProc = new OpenStackDetachVolProcessor();
        OpenStackConfigVmToPhVmProcessor reconfigVmProc = new OpenStackConfigVmToPhVmProcessor();
        this.initProc((RecoveryProcessor)detachVolProc);
        subProcessors.add((RecoveryProcessor)detachVolProc);
        this.initProc((RecoveryProcessor)reconfigVmProc);
        subProcessors.add((RecoveryProcessor)reconfigVmProc);
        detachVolProc.setPreviousProcessor(null);
        reconfigVmProc.setNextProcessor(null);
        OpenStackReserveVolumeProcessor reverseProc = new OpenStackReserveVolumeProcessor();
        this.initProc((RecoveryProcessor)reverseProc);
        subProcessors.add((RecoveryProcessor)reverseProc);
        detachVolProc.setNextProcessor((RecoveryProcessor)reverseProc);
        reverseProc.setPreviousProcessor((RecoveryProcessor)detachVolProc);
        reverseProc.setNextProcessor((RecoveryProcessor)reconfigVmProc);
        reconfigVmProc.setPreviousProcessor((RecoveryProcessor)reverseProc);
        if (this.isBareMetalServer(context)) {
            reverseProc.setPreviousProcessor(null);
            subProcessors.remove((Object)detachVolProc);
        } else {
            OpenStackShutDownVmProcessor shutDownProc = new OpenStackShutDownVmProcessor();
            this.initProc((RecoveryProcessor)shutDownProc);
            subProcessors.add((RecoveryProcessor)shutDownProc);
            shutDownProc.setPreviousProcessor(null);
            shutDownProc.setNextProcessor((RecoveryProcessor)detachVolProc);
            detachVolProc.setPreviousProcessor((RecoveryProcessor)shutDownProc);
        }
    }

    private void generateSubProcessorsForReprotected(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcessors) {
        OpenStackDetachVolProcessor detachVolProc = new OpenStackDetachVolProcessor();
        OpenStackConfigVmToPhVmProcessor reconfigVmProc = new OpenStackConfigVmToPhVmProcessor();
        this.initProc((RecoveryProcessor)detachVolProc);
        subProcessors.add((RecoveryProcessor)detachVolProc);
        this.initProc((RecoveryProcessor)reconfigVmProc);
        subProcessors.add((RecoveryProcessor)reconfigVmProc);
        detachVolProc.setPreviousProcessor(null);
        reconfigVmProc.setNextProcessor(null);
        OpenStackReserveVolumeProcessor reverseProc = new OpenStackReserveVolumeProcessor();
        this.initProc((RecoveryProcessor)reverseProc);
        subProcessors.add((RecoveryProcessor)reverseProc);
        detachVolProc.setNextProcessor((RecoveryProcessor)reverseProc);
        reverseProc.setPreviousProcessor((RecoveryProcessor)detachVolProc);
        reverseProc.setNextProcessor((RecoveryProcessor)reconfigVmProc);
        reconfigVmProc.setPreviousProcessor((RecoveryProcessor)reverseProc);
        if (this.isBareMetalServer(context)) {
            logger.debug((Object)"bms vm do not need to shutdown.");
        } else {
            OpenStackShutDownVmProcessor shutDownProc = new OpenStackShutDownVmProcessor();
            this.initProc((RecoveryProcessor)shutDownProc);
            subProcessors.add((RecoveryProcessor)shutDownProc);
            shutDownProc.setPreviousProcessor(null);
            shutDownProc.setNextProcessor((RecoveryProcessor)detachVolProc);
            detachVolProc.setPreviousProcessor((RecoveryProcessor)shutDownProc);
            boolean isSecondDisasterRecovery = Boolean.parseBoolean(context.getProtectGroup().getProperty("IsSecondDisasterRecovery"));
            if (!VerifyUtil.isEmpty((Object)context.getAttribute("needChangeHyperMaster")) && ((Boolean)context.getAttribute("needChangeHyperMaster")).booleanValue() || isSecondDisasterRecovery) {
                OpenStackSwitchHyperPortProcessor switchHyperPortProcessor = new OpenStackSwitchHyperPortProcessor();
                this.initProc((RecoveryProcessor)switchHyperPortProcessor);
                subProcessors.add((RecoveryProcessor)switchHyperPortProcessor);
                switchHyperPortProcessor.setPreviousProcessor((RecoveryProcessor)reverseProc);
                switchHyperPortProcessor.setNextProcessor((RecoveryProcessor)reconfigVmProc);
                reverseProc.setNextProcessor((RecoveryProcessor)switchHyperPortProcessor);
                reconfigVmProc.setPreviousProcessor((RecoveryProcessor)switchHyperPortProcessor);
            }
        }
    }

    private void generateSubProcessorsForCleanDrilling(Set<RecoveryProcessor> subProcessors) {
        logger.info((Object)"this is a clean proc.");
        OpenStackDetachVolProcessor detachVolProc = new OpenStackDetachVolProcessor();
        OpenStackConfigVmToPhVmProcessor reconfigVmProc = new OpenStackConfigVmToPhVmProcessor();
        this.initProc((RecoveryProcessor)detachVolProc);
        subProcessors.add((RecoveryProcessor)detachVolProc);
        this.initProc((RecoveryProcessor)reconfigVmProc);
        subProcessors.add((RecoveryProcessor)reconfigVmProc);
        detachVolProc.setPreviousProcessor(null);
        reconfigVmProc.setNextProcessor(null);
        detachVolProc.setNextProcessor((RecoveryProcessor)reconfigVmProc);
        reconfigVmProc.setPreviousProcessor((RecoveryProcessor)detachVolProc);
    }

    private boolean isBareMetalServer(RecoveryProcessorContext context) {
        for (ProtectObject po : context.getProtectGroup().getPolist()) {
            if (VerifyUtil.isEmpty((String)((String)po.getProps().get("vm_type"))) || !"BMS".equals(po.getProps().get("vm_type"))) continue;
            return true;
        }
        return false;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        String processName = ((Object)((Object)this)).getClass().getName();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
            processName = processName + ".clean";
        }
        this.setProcName(processName);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    public void updateDescription() {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackConfigReSetVmProcessor.des");
        }
    }
}

