/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackConfigVmToPhVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1147461967937008521L;
    private static final Log logger = LogFactory.getInstance(OpenStackConfigVmToPhVmSubProcessor.class);

    public OpenStackConfigVmToPhVmSubProcessor() {
    }

    public OpenStackConfigVmToPhVmSubProcessor(String vmUuid, String vmName, String regionUuid, String projUuid) {
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackConfigVmToPhVmSubProcessor");
        String vmUuid = this.getString("vmUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        NovaManager novaMgr = new NovaManager();
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        try {
            OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
            if (null == vm) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)("vm(" + vmUuid + ") doesn't exit."));
                this.updateProcessDetail("lego.err.1073947394", null);
                return false;
            }
            this.updateVmTag(vmUuid, regionUuid, projUuid, novaMgr, tokenId);
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("set PhVm failed, vmUuid is: " + this.getString("vmUuid")), (Throwable)e);
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave OpenStackConfigVmToPhVmSubProcessor");
        return true;
    }

    private void updateVmTag(String vmUuid, String regionUuid, String projUuid, NovaManager novaMgr, String tokenId) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
            try {
                novaMgr.deleteTagFromVm(regionUuid, tokenId, projUuid, vmUuid, "__type_pd");
                novaMgr.addTagToVm(regionUuid, tokenId, projUuid, vmUuid, "__type_dr");
            }
            catch (Exception e) {
                logger.error((Object)("update tag on vm (" + vmUuid + ") failed."), (Throwable)e);
            }
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        String processName = ((Object)((Object)this)).getClass().getName();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
            processName = "com.huawei.ism.drm.openstack.recovery.processor.OpenStackSetPhVm";
        }
        this.setProcName(processName);
    }
}

