/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.CreateLinkedCloneVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolSnapshotProcessor;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class OpenStackCreateLinkedCloneVolumeSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2154428928071112146L;
    private static Log logger = LogFactory.getInstance(OpenStackCreateLinkedCloneVolumeSubProcessor.class);

    public OpenStackCreateLinkedCloneVolumeSubProcessor() {
    }

    public OpenStackCreateLinkedCloneVolumeSubProcessor(String openstackVersion) {
        this.addString("openstackVersion", openstackVersion);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackCreateLinkedCloneVolumeSubProcessor");
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        String openStackId = drRegionUuid.split(":")[0];
        String version = this.getString("openstackVersion");
        HashSet<CreateLinkedCloneVolumeProcessor> subProcessors = new HashSet<CreateLinkedCloneVolumeProcessor>();
        if ("6.1".equals(version)) {
            OpenStackCreateVolSnapshotProcessor createVolSnapshotProcessor = (OpenStackCreateVolSnapshotProcessor)this.getPreviousProcessor().getPreviousProcessor();
            if (!VerifyUtil.isEmpty((Object)((Object)createVolSnapshotProcessor)) && null != createVolSnapshotProcessor.getChildProc()) {
                logger.info((Object)("snapshots szie:" + createVolSnapshotProcessor.getChildProc().size()));
                for (RecoveryProcessor subProcessor : createVolSnapshotProcessor.getChildProc()) {
                    String snapshotId = subProcessor.getString("volSnapShotUuid");
                    String volUuid = subProcessor.getString("volUuid");
                    CreateLinkedCloneVolumeProcessor processor = new CreateLinkedCloneVolumeProcessor(drRegionUuid, drProjUuid, snapshotId, volUuid);
                    this.initProc((RecoveryProcessor)processor);
                    subProcessors.add(processor);
                }
            }
        } else {
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            HashMap<String, String> filterProp = new HashMap<String, String>();
            OpenStackCreateVolCgSnapshotProcessor createVolCgSnapshotProcessor = (OpenStackCreateVolCgSnapshotProcessor)this.getPreviousProcessor();
            filterProp.put("cgsnapshot_id", createVolCgSnapshotProcessor.getString("volCgSnapShotId"));
            logger.info((Object)("cgsnapshot_id is:" + createVolCgSnapshotProcessor.getString("volCgSnapShotId")));
            List<VolumeSnapShotInfo> volSnapShots = cinderMgr.queryVolumeSnapShots(drRegionUuid, tokenId, drProjUuid, filterProp);
            for (VolumeSnapShotInfo volSnapShot : volSnapShots) {
                CreateLinkedCloneVolumeProcessor subProcessor = new CreateLinkedCloneVolumeProcessor(drRegionUuid, drProjUuid, volSnapShot.getId(), openStackId + ":" + volSnapShot.getVolumeId());
                this.initProc((RecoveryProcessor)subProcessor);
                subProcessors.add(subProcessor);
            }
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != this.getProcStatus()) {
            return false;
        }
        logger.info((Object)"leave OpenStackCreateLinkedCloneVolumeSubProcessor");
        return true;
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

