/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcStatusCheck;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackDcCinderStatusCheckProcessor
extends OpenStackDcStatusCheck {
    private static final long serialVersionUID = -8239341885159426993L;
    private static Log logger = LogFactory.getInstance(OpenStackDcCinderStatusCheckProcessor.class);
    private static final String VOLUME_ID = "3d781ba4-b55e-46bd-abee-9137ac50acd5";
    private transient CinderManager cinderManager;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        boolean checkServerStatus = this.checkServerStatus(context);
        if (checkServerStatus) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            logger.info((Object)("leave OpenStackDcCinderStatusCheckProcessor:check successed.recoveryPlan name=" + (recoveryPlan != null ? recoveryPlan.getName() : "")));
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail("com.huawei.ism.drm.openstack.recovery.processor.dc.check.error", new String[0]);
        logger.info((Object)("leave OpenStackDcNovaStatusCheckProcessor:check failed.recoveryPlan name=" + (recoveryPlan != null ? recoveryPlan.getName() : "")));
        return false;
    }

    @Override
    protected boolean checkSingleStatus(String regionUuid, String projUuid, String tokenId) {
        try {
            if (this.cinderManager == null) {
                this.cinderManager = new CinderManager();
            }
            this.cinderManager.queryVolume(regionUuid, tokenId, projUuid, VOLUME_ID);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947401L || e.getErrorCode() == 1073947398L) {
                logger.error((Object)("OpenStackDcCinderStatusCheckProcessor queryVolume ( " + regionUuid + " ," + projUuid + " ," + VOLUME_ID + " ) failed."), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("OpenStackDcCinderStatusCheckProcessor queryVolume ( " + regionUuid + " ," + projUuid + " ," + VOLUME_ID + " ) other exception."));
        }
        return true;
    }
}

