/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcStatusCheck;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class OpenStackDcDrExtendStatusCheckProcessor
extends OpenStackDcStatusCheck {
    private static final long serialVersionUID = -5194591082201926872L;
    private static Log logger = LogFactory.getInstance(OpenStackDcDrExtendStatusCheckProcessor.class);
    private static final String REPLICATION_CG_ID = "slave-asdasd-xfdsf-dsfds";
    private transient DrExtendManager drExtendManager;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        boolean checkServerStatus = this.checkServerStatus(context);
        if (checkServerStatus) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            logger.info((Object)("leave OpenStackDcDrExtendStatusCheckProcessor:check successed.recoveryPlan name=" + (recoveryPlan != null ? recoveryPlan.getName() : "")));
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail("com.huawei.ism.drm.openstack.recovery.processor.dc.check.error", new String[0]);
        logger.info((Object)("leave OpenStackDcNovaStatusCheckProcessor:check failed.recoveryPlan name=" + (recoveryPlan != null ? recoveryPlan.getName() : "")));
        return false;
    }

    @Override
    protected boolean checkSingleStatus(String regionUuid, String projUuid, String tokenId) {
        try {
            if (this.drExtendManager == null) {
                this.drExtendManager = new DrExtendManager();
            }
            this.drExtendManager.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, REPLICATION_CG_ID);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947401L || e.getErrorCode() == 1073947398L) {
                logger.error((Object)("OpenStackDcDrextendStatusCheckProcessor queryVolumeReplicationCG ( " + regionUuid + " ," + projUuid + " ," + REPLICATION_CG_ID + " ) failed."), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("OpenStackDcDrextendStatusCheckProcessor queryVolumeReplicationCG ( " + regionUuid + " ," + projUuid + " ," + REPLICATION_CG_ID + " ) other exception." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return true;
    }
}

