/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcCinderStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcDrExtendStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcNeutronStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcNovaStatusCheckProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcStatusCheck;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class OpenStackDcStatusCheckProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -671347846958850539L;
    private static Log logger = LogFactory.getInstance(OpenStackDcStatusCheckProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackDcStatusCheckProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.generateSubProcessors();
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        logger.info((Object)("leave OpenStackDcStatusCheckProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generateSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        HashSet<OpenStackDcStatusCheck> subProcessors = new HashSet<OpenStackDcStatusCheck>();
        OpenStackDcNovaStatusCheckProcessor novaCheckProcessor = new OpenStackDcNovaStatusCheckProcessor();
        this.initProc((RecoveryProcessor)novaCheckProcessor);
        subProcessors.add(novaCheckProcessor);
        OpenStackDcCinderStatusCheckProcessor cinderCheckProcessor = new OpenStackDcCinderStatusCheckProcessor();
        this.initProc((RecoveryProcessor)cinderCheckProcessor);
        subProcessors.add(cinderCheckProcessor);
        OpenStackDcNeutronStatusCheckProcessor neutronCheckProcessor = new OpenStackDcNeutronStatusCheckProcessor();
        this.initProc((RecoveryProcessor)neutronCheckProcessor);
        subProcessors.add(neutronCheckProcessor);
        OpenStackDcDrExtendStatusCheckProcessor drExtendCheckProcessor = new OpenStackDcDrExtendStatusCheckProcessor();
        this.initProc((RecoveryProcessor)drExtendCheckProcessor);
        subProcessors.add(drExtendCheckProcessor);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateProcessName() {
        this.setProcName("ism.drm.recovery.prepare.process.name");
    }
}

