/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDelLinkedCloneVolSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDelVolCgProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDelVolCgSnapShotProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDeleteVolSnapshotProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReserveVolumeProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackUnReserveVolumeProcessor;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OpenStackDelLinkedCloneVolProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -321228293241020469L;
    private static Log logger = LogFactory.getInstance(OpenStackDelLinkedCloneVolProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackCleanLinkedCloneVolProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr((String)context.getProtectGroup().getProps().get("drProjectId"));
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(openstackUuid);
        if (null == open) {
            logger.error((Object)"openstack not found.");
            throw new LegoCheckedException(1073947394L);
        }
        this.generateSubProcessors(open.getVersion());
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        if (null == recoveryTemplate) {
            logger.error((Object)"recoveryTemplate is null.");
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        logger.info((Object)("leave OpenStackCleanLinkedCloneVolProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors(String version) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        HashSet<BaseRecoveryProcessor> subProcessors = new HashSet<BaseRecoveryProcessor>();
        OpenStackUnReserveVolumeProcessor unReserveVolProcessor = new OpenStackUnReserveVolumeProcessor();
        this.initProc((RecoveryProcessor)unReserveVolProcessor);
        subProcessors.add(unReserveVolProcessor);
        OpenStackDelLinkedCloneVolSubProcessor delLinkedCloneVolProcessor = new OpenStackDelLinkedCloneVolSubProcessor();
        this.initProc((RecoveryProcessor)delLinkedCloneVolProcessor);
        subProcessors.add(delLinkedCloneVolProcessor);
        OpenStackReserveVolumeProcessor reserveVolProcessor = new OpenStackReserveVolumeProcessor();
        this.initProc((RecoveryProcessor)reserveVolProcessor);
        subProcessors.add(reserveVolProcessor);
        unReserveVolProcessor.setNextProcessor((RecoveryProcessor)delLinkedCloneVolProcessor);
        if (VerifyUtil.isEmpty((String)version) || "6.0".equals(version)) {
            OpenStackDelVolCgSnapShotProcessor delVolRepCgSnapShotProcessor = new OpenStackDelVolCgSnapShotProcessor();
            this.initProc((RecoveryProcessor)delVolRepCgSnapShotProcessor);
            subProcessors.add(delVolRepCgSnapShotProcessor);
            OpenStackDelVolCgProcessor delVolCgProcessor = new OpenStackDelVolCgProcessor();
            this.initProc((RecoveryProcessor)delVolCgProcessor);
            subProcessors.add(delVolCgProcessor);
            delLinkedCloneVolProcessor.setNextProcessor((RecoveryProcessor)delVolRepCgSnapShotProcessor);
            delVolRepCgSnapShotProcessor.setNextProcessor((RecoveryProcessor)delVolCgProcessor);
            delVolCgProcessor.setNextProcessor((RecoveryProcessor)reserveVolProcessor);
            reserveVolProcessor.setPreviousProcessor((RecoveryProcessor)delVolCgProcessor);
            delVolCgProcessor.setPreviousProcessor((RecoveryProcessor)delVolRepCgSnapShotProcessor);
            delVolRepCgSnapShotProcessor.setPreviousProcessor((RecoveryProcessor)delLinkedCloneVolProcessor);
        } else {
            OpenStackDeleteVolSnapshotProcessor deleteVolSnapshotProcessor = new OpenStackDeleteVolSnapshotProcessor();
            this.initProc((RecoveryProcessor)deleteVolSnapshotProcessor);
            subProcessors.add(deleteVolSnapshotProcessor);
            delLinkedCloneVolProcessor.setNextProcessor((RecoveryProcessor)deleteVolSnapshotProcessor);
            deleteVolSnapshotProcessor.setNextProcessor((RecoveryProcessor)reserveVolProcessor);
            reserveVolProcessor.setPreviousProcessor((RecoveryProcessor)deleteVolSnapshotProcessor);
            deleteVolSnapshotProcessor.setPreviousProcessor((RecoveryProcessor)delLinkedCloneVolProcessor);
        }
        delLinkedCloneVolProcessor.setPreviousProcessor((RecoveryProcessor)unReserveVolProcessor);
        reserveVolProcessor.setNextCascadeProcessor(null);
        unReserveVolProcessor.setPreProcId(null);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return null;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackDelLinkedCloneVolProcessor.des");
    }
}

