/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgProcessor;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgUpdateInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OpenStackDelVolCgProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5527061912529247987L;
    private static Log logger = LogFactory.getInstance(OpenStackDelVolCgProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackDelVolCgProcessor");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue()), OpenStackCreateVolCgProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        OpenStackCreateVolCgProcessor createVolCgProcessor = (OpenStackCreateVolCgProcessor)((Object)CommonUtil.getFirstElement((Collection)createProcessors));
        String volCgUuid = createVolCgProcessor.getString("volCgUuid");
        String drRegionUuid = createVolCgProcessor.getString("regionUuid");
        String drProjUuid = createVolCgProcessor.getString("projUuid");
        logger.info((Object)("volCgUuid is:" + volCgUuid + ", drRegionUuid is:" + drRegionUuid + ", drProjUuid is:" + drProjUuid));
        if (VerifyUtil.isEmpty((String)volCgUuid)) {
            logger.info((Object)"volCgUuid is null.no need to delete cg snapshot.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        try {
            AsyncTaskResponse response;
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            logger.info((Object)"start queryVolConsistencyGroup");
            VolumeCgInfo volCg = cinderMgr.queryVolConsistencyGroup(drRegionUuid, tokenId, drProjUuid, volCgUuid);
            if (null == volCg) {
                logger.info((Object)("volCg(" + volCgUuid + ") doesn't exit."));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            String drVolUuids = this.getDrVolUuids(volCgUuid, drRegionUuid, drProjUuid, cinderMgr, tokenId);
            logger.info((Object)("start remove Volume from ConsistenceGroup:" + drVolUuids));
            if (!VerifyUtil.isEmpty((String)drVolUuids)) {
                VolumeCgUpdateInfo volCgUpdateInfo = new VolumeCgUpdateInfo();
                volCgUpdateInfo.setRemoveVolUuids(drVolUuids);
                AsyncTaskResponse response2 = cinderMgr.updateVolumeConsistenceGroup(volCgUpdateInfo, drRegionUuid, tokenId, drProjUuid, volCgUuid);
                if (!response2.isSuccess()) {
                    this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                    logger.error((Object)("update volCg failed." + response2.getErrorCode()));
                    this.updateProcessDetail("lego.err.1073948915", null);
                    return false;
                }
            }
            if (!(response = cinderMgr.deleteVolumeConsistencyGroup(volCgUuid, drRegionUuid, tokenId, drProjUuid)).isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.info((Object)("del volCg(" + volCgUuid + ")failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err.1073948915", null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948915", null);
            logger.info((Object)("del volCg(" + volCgUuid + ")failed." + (Object)((Object)e)));
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave OpenStackDelVolRepCgSnapShotProcessor");
        return true;
    }

    private String getDrVolUuids(String volCgUuid, String drRegionUuid, String drProjUuid, CinderManager cinderMgr, String tokenId) {
        String drVolUuids = "";
        List<OpenStackVolume> vols = cinderMgr.getVolumes(drRegionUuid, tokenId, drProjUuid, volCgUuid);
        if (!VerifyUtil.isEmpty(vols)) {
            HashSet<String> volIdSet = new HashSet<String>();
            for (OpenStackVolume vol : vols) {
                volIdSet.add(OpenStackCommonUtil.getIdFromUuid(vol.getUuid()));
            }
            drVolUuids = OpenStackCommonUtil.getStringFromCollection(volIdSet, ",");
        }
        return drVolUuids;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

