/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackDetachOnePortSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6299366195786853993L;
    private static Log logger = LogFactory.getInstance(OpenStackDetachOnePortSubProcessor.class);

    public OpenStackDetachOnePortSubProcessor() {
        logger.trace((Object)"OpenStackDetachOnePortSubProcessor defautl constructor");
    }

    public OpenStackDetachOnePortSubProcessor(String regionId, String projectId, String portId, String vmName, String vmUuid) {
        this.addString("regionUuid", regionId);
        this.addString("projUuid", projectId);
        this.addString("portId", portId);
        this.addString("vmName", vmName);
        this.addString("vmUuid", vmUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        String portId = this.getString("portId");
        String vmUuid = this.getString("vmUuid");
        this.updateProcessNameParams(new String[]{this.getPortName()});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) {
                novaMgr.forceDetachPortFromVM(portId, vmUuid, projectUuid, regionUuid, tokenId, false);
            } else {
                AsyncTaskResponse response = novaMgr.detachPortFromVM(portId, vmUuid, projectUuid, regionUuid, tokenId);
                if (!response.isSuccess()) {
                    this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                    return false;
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("detach port failed:vmName=" + vmName), (Throwable)e);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private String getPortName() {
        return OpenStackRecoveryTool.getPortName(this.getContextRef().getProtectGroup(), this.getString("portId"));
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

