/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OpenStackDetachPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static Log logger = LogFactory.getInstance(OpenStackDetachPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.debug((Object)("Enter into OpenStackDetachPortProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (!this.isSwitchNetWork(context)) {
            logger.info((Object)("region config:isSwitchNetwork is false,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors(context);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.debug((Object)("No ports need to detach,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList();
        list.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    private boolean isSwitchNetWork(RecoveryProcessorContext context) {
        List<Integer> protype = Arrays.asList(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue());
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        if (PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg) && protype.contains(this.getProcType())) {
            List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionUuid);
            if (VerifyUtil.isEmpty((Collection)regions)) {
                logger.error((Object)"openstack region is not exist.");
                return true;
            }
            return ((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork();
        }
        return true;
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        INeutronManager neutronManager = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        List<OpenStackPort> portList = neutronManager.getPorts(openstackUuid, regionUuid, tokenId, projectUuid);
        HashSet<OpenStackDetachPortSubProcessor> subProcSet = new HashSet<OpenStackDetachPortSubProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                logger.info((Object)"po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String srcVmUuid = po.getMoUuid();
            List<VMInterface> srcVmPortList = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, srcVmUuid);
            if (VerifyUtil.isEmpty(srcVmPortList)) {
                logger.error((Object)("the vm has no port,vmName=" + po.getName()));
                continue;
            }
            String portIdStr = OpenStackRecoveryTool.getSortedPortIdStr(srcVmPortList, portList);
            if (VerifyUtil.isEmpty((String)portIdStr)) {
                logger.error((Object)("the vm has no valid portId,vmName=" + po.getName()));
                continue;
            }
            String vmName = po.getName();
            String vmUuid = po.getMoUuid();
            OpenStackDetachPortSubProcessor subProc = new OpenStackDetachPortSubProcessor(regionUuid, projectUuid, portIdStr, vmName, vmUuid);
            this.initProc((RecoveryProcessor)subProc);
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        logger.debug((Object)"calcProcessResultBySubProc start");
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

