/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;

public class OpenStackDetachVolOnVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6957370396347134253L;
    private static Log logger = LogFactory.getInstance(OpenStackDetachVolOnVmProcessor.class);
    private static final String VOL_LOCK_NAME = "_vol_detach_lock";

    public OpenStackDetachVolOnVmProcessor() {
    }

    public OpenStackDetachVolOnVmProcessor(String vmUuid, String volUuid, String regionUuid, String projUuid, String vmName, String vmType, String volName) {
        this.addString("vmUuid", vmUuid);
        this.addString("volUuid", volUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
        this.addString("vmName", vmName);
        this.addString("vmType", vmType);
        this.addString("volName", volName);
    }

    public void updateProcNameParams() {
        String volName = this.getString("volName");
        this.updateProcessNameParams(new String[]{volName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackDetachVolOnVmProcessor");
        String vmUuid = this.getString("vmUuid");
        String volUuid = this.getString("volUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String volName = this.getString("volName");
        String vmType = this.getString("vmType");
        this.updateProcessNameParams(new String[]{volName});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        try {
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            VolumeInfo volumeInfo = volService.queryVolumeInfoByUuid(regionUuid, projUuid, volUuid);
            if (null == volumeInfo) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.2117645", null);
                logger.error((Object)("the volume(" + volUuid + ")is not exist"));
                return false;
            }
            if (this.volIsDetached(volumeInfo, vmUuid, volUuid)) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                logger.info((Object)("the volume(" + volUuid + ") has detached"));
                return true;
            }
            NovaManager novaMgr = new NovaManager();
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            String lockName = volUuid + VOL_LOCK_NAME;
            while (!SyncLockManager.tryLock((String)lockName)) {
                logger.debug((Object)("OpenStackDetachVolOnVmProcessor get volUuid lock,lock is in use,wait 1s:" + Thread.currentThread().getId() + "  volId:" + volUuid));
                CommonUtil.sleep((long)5000L);
            }
            logger.debug((Object)("OpenStackDetachVolOnVmProcessor get volUuid lock:" + Thread.currentThread().getId() + "  volId:" + volUuid));
            try {
                AsyncTaskResponse response = novaMgr.detachVolFromVm(tokenId, projUuid, regionUuid, vmUuid, vmType, OpenStackCommonUtil.getIdFromUuid(volUuid));
                if (!response.isSuccess()) {
                    this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                    this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                    logger.error((Object)("detach volume(" + volUuid + ") failed from vm(" + vmUuid + "), errorcode is " + response.getErrorCode()));
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                logger.debug((Object)("OpenStackDetachVolOnVmProcessor relase volUuid lock:" + Thread.currentThread().getId() + "  volId:" + volUuid));
                SyncLockManager.unLock((String)lockName);
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)("detach volume(" + volUuid + ") failed from vm(" + vmUuid + ")"), (Throwable)e);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave OpenStackDetachVolOnVmProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean volIsDetached(VolumeInfo volumeInfo, String vmUuid, String volUuid) {
        if (OpenstackEnumDefine.VOLUME_STATUS_E.AVAILABLE.getType().equals(volumeInfo.getStatus())) {
            return true;
        }
        if (null == volumeInfo.getAttachments()) {
            return true;
        }
        String serverId = OpenStackCommonUtil.getIdFromUuid(vmUuid);
        if (null == serverId) {
            logger.error((Object)("get id from uuid get null value, vmuuid=" + vmUuid));
            throw new LegoCheckedException(1073947393L);
        }
        for (VolumeAttachmentInfo attach : volumeInfo.getAttachments()) {
            if (!serverId.equals(attach.getServerId())) continue;
            logger.debug((Object)("Volume(" + volUuid + ") is still in vm(" + serverId + ")."));
            return false;
        }
        return true;
    }
}

