/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachVolSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachVolSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackDetachVolProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 3619116873006787205L;
    private static Log logger = LogFactory.getInstance(OpenStackDetachVolProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackDetachVolProcessor recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors(context);
        }
        logger.debug((Object)("OpenStackDetachVolProcessor complete sub recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"no child processors.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        logger.debug((Object)("Leave OpenStackDetachVolProcessor recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        logger.info((Object)(" OpenStackDetachVolProcessor get status .recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.generateCleanDrillingProcessors();
        } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
            this.generatePlanMotionSubProcessors(context);
        }
    }

    private void generatePlanMotionSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        ProtectGroup pg = context.getProtectGroup();
        boolean useDrRes = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg);
        boolean csdrCshaReProtect = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) && !OpenStackCommonUtil.isCsdrCshaMode(pg);
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                logger.info((Object)"po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String vmUuid = po.getMoUuid();
            String vmName = po.getName();
            if (useDrRes) {
                PoReplicaInfo poReplicaInfo;
                String replicationInfo = (String)po.getProps().get("replicationInfo");
                if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
                    replicationInfo = po.getProperty("hypermetor_replicationInfo");
                }
                if (null == (poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class))) {
                    logger.error((Object)("json to bean error:replicaInfoStr=" + replicationInfo));
                    continue;
                }
                PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
                if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                    logger.error((Object)("phvmUuid is empty:replicaInfoStr=" + replicationInfo));
                    continue;
                }
                vmUuid = phVm.getVmUuid();
                vmName = phVm.getName();
            }
            OpenStackDetachVolSubProcessor subProcessor = new OpenStackDetachVolSubProcessor(vmUuid, vmName);
            subProcessor.addString("vmType", (String)po.getProps().get("vm_type"));
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add((RecoveryProcessor)subProcessor);
            if (!csdrCshaReProtect) continue;
            this.detachVolForCshaPhVm(subProcessors, po);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void detachVolForCshaPhVm(Set<RecoveryProcessor> subProcessors, ProtectObject po) {
        String replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            logger.error((Object)("json to bean error:replicaInfoStr=" + replicationInfo));
            return;
        }
        PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
        if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
            logger.error((Object)("phvmUuid is empty:replicaInfoStr=" + replicationInfo));
            return;
        }
        String vmUuid = phVm.getVmUuid();
        String vmName = phVm.getName();
        OpenStackDetachVolSubProcessor subProcessorForCshaCsdr = new OpenStackDetachVolSubProcessor(vmUuid, vmName);
        subProcessorForCshaCsdr.addString("vmType", (String)po.getProps().get("vm_type"));
        this.initProc((RecoveryProcessor)subProcessorForCshaCsdr);
        subProcessors.add((RecoveryProcessor)subProcessorForCshaCsdr);
    }

    private void generateCleanDrillingProcessors() {
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue()), OpenStackAttachVolSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<OpenStackDetachVolSubProcessor> subProcessors = new HashSet<OpenStackDetachVolSubProcessor>();
        for (RecoveryProcessor attachVolSubProcessor : createProcessors) {
            OpenStackAttachVolSubProcessor processor = (OpenStackAttachVolSubProcessor)attachVolSubProcessor;
            OpenStackDetachVolSubProcessor subProcessor = new OpenStackDetachVolSubProcessor(processor.getString("vmUuid"), processor.getString("vmName"));
            subProcessor.addString("vmType", processor.getString("vmType"));
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

