/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachVolToVMProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachVolOnVmProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenStackDetachVolSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -4035704623751607574L;
    private static Log logger = LogFactory.getInstance(OpenStackDetachVolSubProcessor.class);

    public OpenStackDetachVolSubProcessor() {
    }

    public OpenStackDetachVolSubProcessor(String vmUuid, String vmName) {
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
    }

    public void updateProcNameParams() {
        String vmUuid = this.getString("vmUuid");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{VerifyUtil.isEmpty((String)vmName) ? OpenStackCommonUtil.getIdFromUuid(vmUuid) : vmName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackDetachVolSubProcessor");
        String vmUuid = this.getString("vmUuid");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{VerifyUtil.isEmpty((String)vmName) ? OpenStackCommonUtil.getIdFromUuid(vmUuid) : vmName});
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors(context);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"no child processors.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        if (null == recoveryTemplate) {
            logger.info((Object)"recoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        try {
            this.startVmHA(context, vmUuid);
        }
        catch (Throwable e) {
            logger.error((Object)"fail to start vm ha mode. cause: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        logger.info((Object)"leave OpenStackDetachVolSubProcessor");
        return this.calcProcessResultBySubProc();
    }

    private boolean needStartVmHA(boolean csha) {
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() || csha && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType();
    }

    private void startVmHA(RecoveryProcessorContext context, String vmUuid) {
        ProtectGroup pg = context.getProtectGroup();
        Map props = pg.getProps();
        boolean csha = PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg);
        if (!this.needStartVmHA(csha)) {
            return;
        }
        String regionUuid = (String)props.get("regionId");
        String projUuid = (String)props.get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(projUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        novaMgr.updateVMmetadata(vmUuid, projUuid, regionUuid, tokenId, Collections.singletonMap("_ha_policy_type", "remote_rebuild"));
        logger.info((Object)"start vm ha mode success. project: %s, region: %s, vm: %s", new Object[]{projUuid, regionUuid, vmUuid});
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.generateCleanDrillingProcessors();
        } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
            if (PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(context.getProtectGroup()) && !OpenStackCommonUtil.isCsdrCshaMode(context.getProtectGroup()) && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType()) {
                this.generateSubProcessorsForCshaCsdrReProtect(context);
            } else {
                this.generatePlanMotionSubProcessors(context);
            }
        }
    }

    private void generateCleanDrillingProcessors() {
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue()), OpenStackAttachVolToVMProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<OpenStackDetachVolOnVmProcessor> subProcessors = new HashSet<OpenStackDetachVolOnVmProcessor>();
        OpenStackDetachVolOnVmProcessor preProcessor = null;
        String vmUuid = this.getString("vmUuid");
        for (RecoveryProcessor attachVolToVmProcessor : createProcessors) {
            OpenStackAttachVolToVMProcessor processor = (OpenStackAttachVolToVMProcessor)attachVolToVmProcessor;
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != attachVolToVmProcessor.getProcStatus() || !vmUuid.equals(attachVolToVmProcessor.getString("vmUuid"))) continue;
            OpenStackDetachVolOnVmProcessor subProcessor = new OpenStackDetachVolOnVmProcessor(processor.getString("vmUuid"), processor.getString("volUuid"), processor.getString("regionUuid"), processor.getString("projUuid"), processor.getString("vmName"), processor.getString("vmType"), processor.getString("volName"));
            this.initProc((RecoveryProcessor)subProcessor);
            if (null != preProcessor) {
                preProcessor.setNextProcessor((RecoveryProcessor)subProcessor);
            }
            preProcessor = subProcessor;
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generatePlanMotionSubProcessors(RecoveryProcessorContext context) {
        HashSet<OpenStackDetachVolOnVmProcessor> subProcessors = new HashSet<OpenStackDetachVolOnVmProcessor>();
        ProtectGroup pg = context.getProtectGroup();
        boolean useDrRes = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg);
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String vmUuid = this.getString("vmUuid");
        String vmType = this.getString("vmType");
        OpenStackDetachVolOnVmProcessor preProcessor = null;
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo replicaInfo;
            if (!this.isDealPo(vmUuid, po, useDrRes)) continue;
            String replicaInfoStr = (String)po.getProps().get("replicationInfo");
            if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
                replicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
            }
            if (null == (replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class))) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("ism.drm.pg.po.replicainfo.error", null);
                logger.error((Object)("replicaInfo in vm(" + po.getName() + ") doesn't exits."));
                return;
            }
            String vmName = useDrRes ? replicaInfo.getPhVmInfo().getName() : po.getName();
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            List pairInfos = replicaInfo.getPairInfos();
            logger.debug((Object)("enter into OpenStackDetachVolSubProcessor_1:" + this.getString("vmName")));
            for (PoReplicaPairInfo repPair : pairInfos) {
                if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(repPair.getVolumeStatus())) continue;
                String volUuid = useDrRes ? repPair.getDrVolumeUuid() : repPair.getVolumeUuid();
                CinderManager cinderMgr = new CinderManager();
                VolumeInfo volInfo = cinderMgr.queryVolume(regionUuid, tokenId, projUuid, volUuid);
                String drVolName = OpenStackCommonUtil.getIdFromUuid(volUuid);
                if (null != volInfo) {
                    drVolName = volInfo.getName();
                } else {
                    logger.error((Object)("Volume not found : " + OpenStackCommonUtil.getIdFromUuid(volUuid)));
                }
                OpenStackDetachVolOnVmProcessor subProcessor = new OpenStackDetachVolOnVmProcessor(vmUuid, volUuid, regionUuid, projUuid, vmName, vmType, drVolName);
                this.initProc((RecoveryProcessor)subProcessor);
                if (null != preProcessor) {
                    preProcessor.setNextProcessor((RecoveryProcessor)subProcessor);
                }
                preProcessor = subProcessor;
                subProcessors.add(subProcessor);
            }
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateSubProcessorsForCshaCsdrReProtect(RecoveryProcessorContext context) {
        HashSet<OpenStackDetachVolOnVmProcessor> subProcessors = new HashSet<OpenStackDetachVolOnVmProcessor>();
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String vmUuid = this.getString("vmUuid");
        String vmType = this.getString("vmType");
        OpenStackDetachVolOnVmProcessor preProcessor = null;
        for (ProtectObject po : pg.getPolist()) {
            String replicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
            if (null == replicaInfo) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("ism.drm.pg.po.replicainfo.error", null);
                logger.error((Object)("replicaInfo in vm(" + po.getName() + ") doesn't exits."));
                return;
            }
            if (!vmUuid.equals(replicaInfo.getMoUuid()) && !vmUuid.equals(replicaInfo.getPhVmInfo().getVmUuid())) {
                logger.debug((Object)"vm:%s is not found in pg replica:%s", new Object[]{vmUuid, replicaInfo.getMoUuid()});
                continue;
            }
            String vmName = vmUuid.equals(replicaInfo.getMoUuid()) ? po.getName() : replicaInfo.getPhVmInfo().getName();
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            List pairInfos = replicaInfo.getPairInfos();
            logger.debug((Object)("enter into OpenStackDetachVolSubProcessor_1:" + this.getString("vmName")));
            for (PoReplicaPairInfo repPair : pairInfos) {
                if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(repPair.getVolumeStatus())) continue;
                String volUuid = vmUuid.equals(replicaInfo.getMoUuid()) ? repPair.getVolumeUuid() : repPair.getDrVolumeUuid();
                CinderManager cinderMgr = new CinderManager();
                VolumeInfo volInfo = cinderMgr.queryVolume(regionUuid, tokenId, projUuid, volUuid);
                String drVolName = OpenStackCommonUtil.getIdFromUuid(volUuid);
                if (null != volInfo) {
                    drVolName = volInfo.getName();
                } else {
                    logger.error((Object)("Volume not found : " + OpenStackCommonUtil.getIdFromUuid(volUuid)));
                }
                OpenStackDetachVolOnVmProcessor subProcessor = new OpenStackDetachVolOnVmProcessor(vmUuid, volUuid, regionUuid, projUuid, vmName, vmType, drVolName);
                this.initProc((RecoveryProcessor)subProcessor);
                if (null != preProcessor) {
                    preProcessor.setNextProcessor((RecoveryProcessor)subProcessor);
                }
                preProcessor = subProcessor;
                subProcessors.add(subProcessor);
            }
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private boolean isDealPo(String vmUuid, ProtectObject po, boolean useDrRes) {
        PoReplicaInfo replicaInfo;
        if (!useDrRes) {
            logger.debug((Object)("to match vm." + po.getMoUuid() + "#" + vmUuid));
            return vmUuid.equals(po.getMoUuid());
        }
        String replicaInfoStr = (String)po.getProps().get("replicationInfo");
        if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(po.getProtectGroup())) {
            replicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
        }
        if (null == (replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class))) {
            logger.warn((Object)("replicaInfo in vm(" + po.getName() + ") doesn't exits."));
            return false;
        }
        PhVmInfo phVm = replicaInfo.getPhVmInfo();
        if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
            logger.warn((Object)("phvmUuid is empty:replicaInfoStr=" + replicaInfoStr));
            return false;
        }
        logger.debug((Object)("to match phvm." + po.getMoUuid() + "#" + phVm.getVmUuid() + "#" + vmUuid));
        return vmUuid.equals(phVm.getVmUuid());
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        proc.setPreviousProcessor(null);
        proc.setNextProcessor(null);
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

