/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackHotMigrationVmSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReleasePhVmSubProcessor;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.Set;

public class OpenStackHotMigrationVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -729290830188252874L;
    private static Log logger = LogFactory.getInstance(OpenStackHotMigrationVmProcessor.class);

    public OpenStackHotMigrationVmProcessor() {
    }

    public OpenStackHotMigrationVmProcessor(String vmUuid, String vmName, String replicaInfoStr) {
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
        this.addString("poReplicaInfo", replicaInfoStr);
    }

    public OpenStackHotMigrationVmProcessor(String regionUuid, String projectUuid, String azUuid, String vmUuid, String vmName, String replicaInfoStr) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("migrateAzUuid", azUuid);
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
        this.addString("poReplicaInfo", replicaInfoStr);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackHotMigrationVmProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.updateProcessNameParams(new String[]{this.getString("vmName")});
        this.generateSubProcessors();
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutorSort((Set)this.getChildProc());
        if (null == recoveryTemplate) {
            logger.error((Object)"OpenStackHotMigrationVmProcessor failed.");
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        logger.info((Object)("leave OpenStackHotMigrationVmProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private void generateSubProcessors() {
        HashSet<BaseRecoveryProcessor> subProcessors = new HashSet<BaseRecoveryProcessor>();
        OpenStackReleasePhVmSubProcessor releasePhVmSubProcessor = new OpenStackReleasePhVmSubProcessor(this.getString("regionUuid"), this.getString("projUuid"), this.getString("vmName"), this.getString("poReplicaInfo"));
        this.initProcessor((RecoveryProcessor)releasePhVmSubProcessor);
        subProcessors.add(releasePhVmSubProcessor);
        OpenStackHotMigrationVmSubProcessor hotMigrationVmSubProcessor = new OpenStackHotMigrationVmSubProcessor(this.getString("regionUuid"), this.getString("projUuid"), this.getString("migrateAzUuid"), this.getString("vmUuid"), this.getString("vmName"), this.getString("poReplicaInfo"));
        this.initProcessor((RecoveryProcessor)hotMigrationVmSubProcessor);
        subProcessors.add(hotMigrationVmSubProcessor);
        hotMigrationVmSubProcessor.setPreviousProcessor((RecoveryProcessor)releasePhVmSubProcessor);
        releasePhVmSubProcessor.setNextProcessor((RecoveryProcessor)hotMigrationVmSubProcessor);
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

