/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenStackVMActionEnum;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class OpenStackPowerOnVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 978572550173130784L;
    private static Log logger = LogFactory.getInstance(OpenStackPowerOnVmProcessor.class);

    public OpenStackPowerOnVmProcessor() {
    }

    public OpenStackPowerOnVmProcessor(String vmUuid, String vmName, String regionUuid, String projUuid, String startupWaitingTime) {
        this.addString("vmUuid", vmUuid);
        this.addString("vmName", vmName);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
        this.addString("start_delay_time", startupWaitingTime);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into StartVmProcessor");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        String vmUuid = this.getString("vmUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String message = new JSONObject().set((Object)"region", (Object)regionUuid).set((Object)"project", (Object)projUuid).set((Object)"vm", (Object)vmUuid).toString();
        long startDelayTime = NumberUtil.parseLong((Object)this.getString("start_delay_time"));
        if (startDelayTime > 0L) {
            logger.info((Object)"start wait. %s", new Object[]{message});
            CommonUtil.sleep((long)startDelayTime, (TimeUnit)TimeUnit.SECONDS);
            logger.info((Object)"end wait. %s", new Object[]{message});
        } else {
            logger.info((Object)"start waiting time is zero, not need to wait. %s", new Object[]{message});
        }
        try {
            AsyncTaskResponse response;
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            NovaManager novaMgr = new NovaManager();
            OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
            if (vm == null) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err.1073948375", null);
                logger.error((Object)("vm(" + vmUuid + ") doesn't exits."));
                return false;
            }
            this.updateProcessNameParams(new String[]{vm.getName()});
            if (vm.getStatus().intValue() == OpenstackEnumDefine.VM_STATUS_E.ACTIVE.getValue()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                logger.error((Object)("vm(" + vm.getName() + ") is aready shutted down."));
                this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
                return true;
            }
            ProtectGroup protectGroup = context.getProtectGroup();
            if ((DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType()) && PolicyTemplateTools.getInstance().isHyperMetroTemplate(protectGroup)) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("_ha_policy_type", "remote_rebuild");
                novaMgr.updateVMmetadata(vmUuid, projUuid, regionUuid, tokenId, metadata);
            }
            if (!(response = novaMgr.vmAction(vmUuid, projUuid, regionUuid, tokenId, OpenStackVMActionEnum.START)).isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                logger.error((Object)("start vm(" + vmUuid + ") failed." + response.getErrorCode()));
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)("start vm(" + vmUuid + ") failed."), (Throwable)e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave StartVmProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

