/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReattachVolSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class OpenStackReattachVolProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3974562709210229270L;
    private static Log logger = LogFactory.getInstance(OpenStackReattachVolProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors(context);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.debug((Object)"No volume need to reattach", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList();
        list.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        logger.debug((Object)"calcProcessResultBySubProc start");
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() != procStatus.getValue();
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        if (PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) && (OpenStackCommonUtil.isCsdrCshaMode(pg) && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() || !OpenStackCommonUtil.isCsdrCshaMode(pg) && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType())) {
            logger.info((Object)"pg:%s no need do reattach volume. current region is: %s. ", new Object[]{pg.getName(), pg.getProperty("regionId")});
            return;
        }
        HashSet<OpenStackReattachVolSubProcessor> subProcSet = new HashSet<OpenStackReattachVolSubProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            String replicaInfoStr;
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                logger.info((Object)"po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String string = replicaInfoStr = 37 == pg.getTemplate().getType() ? po.getProperty("hypermetor_replicationInfo") : (String)po.getProps().get("replicationInfo");
            if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
                logger.info((Object)("the vm has no replicaInfo,vmName=" + po.getName()));
                continue;
            }
            OpenStackReattachVolSubProcessor subProc = new OpenStackReattachVolSubProcessor(replicaInfoStr);
            this.initProc((RecoveryProcessor)subProc);
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

