/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReattachOneVolSubProcessor;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.HypervisorInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackReattachVolSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 2017662756989397319L;
    private static Log logger = LogFactory.getInstance(OpenStackReattachVolSubProcessor.class);

    public OpenStackReattachVolSubProcessor() {
        logger.trace((Object)" OpenStackReattachVolSubProcessor defautl constructor");
    }

    public OpenStackReattachVolSubProcessor(String replicaInfoStr) {
        this.addString("replicationInfo", replicaInfoStr);
    }

    public void updateProcNameParams() {
        String replicaInfoStr = this.getString("replicationInfo");
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        this.updateProcDetails(replicaInfo);
    }

    private void updateProcDetails(PoReplicaInfo replicaInfo) {
        PhVmInfo phVmInfo;
        boolean isReprotect;
        boolean bl = isReprotect = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType();
        if (null == replicaInfo || (phVmInfo = replicaInfo.getPhVmInfo()) == null) {
            logger.error((Object)("phVmInfo is null , the process start time is " + this.getStartTime()));
            this.updateProcessNameParams(new String[]{"unknown"});
        } else {
            String vmName = isReprotect ? replicaInfo.getVmName() : phVmInfo.getName();
            this.updateProcessNameParams(new String[]{vmName});
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String replicaInfoStr = this.getString("replicationInfo");
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (null == replicaInfo || null == replicaInfo.getPhVmInfo()) {
            logger.error((Object)"the place hold vm is empty,cant reattach volume.");
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        this.updateProcDetails(replicaInfo);
        PhVmInfo phVmInfo = replicaInfo.getPhVmInfo();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType()) {
            HypervisorInfo hypervisor = this.getHypervisor(replicaInfo.getDrRegionUuid(), replicaInfo.getDrProjUuid(), phVmInfo.getVmUuid());
            if (null == hypervisor) {
                logger.debug((Object)("the hypervisor not exist: phVmInfo.getVmUuid()= " + phVmInfo.getVmUuid()));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            if (!"FusionCompute".equals(hypervisor.getHypervisorType())) {
                logger.debug((Object)("Not VRM vm\uff0chypervisor.getHypervisorType()= " + hypervisor.getHypervisorType()));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            boolean isReprotect;
            boolean bl = isReprotect = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType();
            if (PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(context.getProtectGroup())) {
                isReprotect = true;
            }
            this.generateSubProcessors(replicaInfo, isReprotect);
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        if (null == recoveryTemplate) {
            logger.info((Object)"recoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors(PoReplicaInfo replicaInfo, boolean isReprotect) {
        List pairList = replicaInfo.getPairInfos();
        HashSet<OpenStackReattachOneVolSubProcessor> subProcSet = new HashSet<OpenStackReattachOneVolSubProcessor>();
        String drRegionUuid = isReprotect ? replicaInfo.getRegionUuid() : replicaInfo.getDrRegionUuid();
        String drProjectUuid = isReprotect ? replicaInfo.getProjUuid() : replicaInfo.getDrProjUuid();
        String phVmUuid = isReprotect ? replicaInfo.getMoUuid() : replicaInfo.getPhVmInfo().getVmUuid();
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        List reginVolumeList = volService.getVolumesFromOpenstack(drRegionUuid, drProjectUuid);
        for (PoReplicaPairInfo pair : pairList) {
            String drVolumeUuid = isReprotect ? pair.getVolumeUuid() : pair.getDrVolumeUuid();
            String drVolName = this.buildVolName(drVolumeUuid, reginVolumeList);
            OpenStackReattachOneVolSubProcessor subProc = new OpenStackReattachOneVolSubProcessor(drRegionUuid, drProjectUuid, phVmUuid, drVolumeUuid, drVolName);
            this.initProc((RecoveryProcessor)subProc);
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private String buildVolName(String volumeUuid, List<OpenStackVolume> reginVolumeList) {
        for (OpenStackVolume openStackVolume : reginVolumeList) {
            if (!openStackVolume.getUuid().equals(volumeUuid)) continue;
            return openStackVolume.getName();
        }
        logger.error((Object)("Volume not found : " + OpenStackCommonUtil.getIdFromUuid(volumeUuid)));
        return OpenStackCommonUtil.getIdFromUuid(volumeUuid);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected boolean calcProcessResultBySubProc() {
        logger.debug((Object)"calcProcessResultBySubProc start");
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private HypervisorInfo getHypervisor(String regionUuid, String projUuid, String phVmUuid) {
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        OpenStackVM vm = novaMgr.getVm(regionUuid, tokenId, projUuid, phVmUuid, new int[0]);
        return ServiceInstanceHelper.getInstance().getHypervisorInfoByVm(regionUuid, projUuid, vm);
    }
}

