/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorProtectRelationProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;

public class OpenStackRefactorProtectRelationProcessor
extends RefactorProtectRelationProcessor {
    private static final long serialVersionUID = 6392314822415647384L;
    private static final String SUCCESS = "success";
    private static final String FAILED = "failed";
    private static Log logger = LogFactory.getInstance(OpenStackRefactorProtectRelationProcessor.class);

    public String getName() {
        return "com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorProtectRelationProcessor";
    }

    public boolean execute(RecoveryProcessorContext context) {
        String lastResult;
        boolean result;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.debug((Object)"enter into OpenStackRefactorProtectRelationProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        int lastProcStatus = this.getProcStatus();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == lastProcStatus) {
            return true;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue() == lastProcStatus) {
            this.getProps().remove("isReverseProtectObject");
        }
        boolean bl = result = SUCCESS.equals(lastResult = this.getString("isReverseProtectObject"));
        if (!result) {
            result = super.execute(context);
            this.addString("isReverseProtectObject", result ? SUCCESS : FAILED);
        }
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(context.getProtectGroup().getUuid());
        if (result) {
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != lastProcStatus && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() != this.getProcType()) {
                OpenStackRecoveryTool.operateReplicationFlagOfPg(pg, false);
            }
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.HOT_MIGRATION.getValue() == this.getProcType()) {
                this.afterMigration(pg, context.getRecoveryPlan());
            }
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        }
        logger.debug((Object)"leave OpenStackRefactorProtectRelationProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return result;
    }

    private boolean afterMigration(ProtectGroup pg, RecoveryPlan plan) {
        String pgId = pg.getUuid();
        ArrayList<String> pgIdList = new ArrayList<String>();
        pgIdList.add(pgId);
        boolean result = RecoveryProcessUtil.changeProtectGroupStatus((String[])pgIdList.toArray(new String[0]), (DrmEnumDefine.PROTECT_GROUP_STATUS)DrmEnumDefine.PROTECT_GROUP_STATUS.LOCKED);
        if (!result) {
            logger.error((Object)("change pg status failed:pgName=" + pg.getName()));
            return false;
        }
        IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
        reprotectService.sendReprotectSuccessMsg(plan);
        return true;
    }
}

