/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackRefreshHostProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(OpenStackRefreshHostProcessor.class);
    private static final long serialVersionUID = -7612068516798013042L;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("step into refreshing protectgroup processor...,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        ProtectGroup pg = context.getProtectGroup();
        if (null == pg) {
            logger.error((Object)"refresh protectgroup failed, for pg is null.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947393", null);
            return false;
        }
        logger.info((Object)("step out refreshing protectgroup processor...,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.openstack.recovery.processor.OpenStackRefreshHostProcessor.des");
    }
}

