/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.ReleaseActionEnum;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackReleasePhVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -729290830188252874L;
    private static Log logger = LogFactory.getInstance(OpenStackReleasePhVmSubProcessor.class);

    public OpenStackReleasePhVmSubProcessor() {
    }

    public OpenStackReleasePhVmSubProcessor(String regionUuid, String projectUuid, String vmName, String replicaInfoStr) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("vmName", vmName);
        this.addString("poReplicaInfo", replicaInfoStr);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackReleasePhVmSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.updateProcessNameParams(new String[]{this.getString("vmName")});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            logger.debug((Object)"OpenStackReleasePhVmSubProcessor already success for plan:%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            return true;
        }
        String vmName = this.getString("vmName");
        String replicaInfoStr = this.getString("poReplicaInfo");
        if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("vm(" + vmName + ") 's replicaInfo is empty."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)replicaInfo) || VerifyUtil.isEmpty((Object)replicaInfo.getPhVmInfo())) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("vm(" + vmName + ") has no placehold vm."));
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            return false;
        }
        String drRegionUuId = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String phVmUuid = replicaInfo.getPhVmInfo().getVmUuid();
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(drProjUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        novaMgr.releaseOrRecapturePhVmResource(drProjUuid, drRegionUuId, drTokenId, phVmUuid, ReleaseActionEnum.RELEASE);
        logger.info((Object)("leave OpenStackReleasePhVmSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }
}

