/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackReserveVolumeSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class OpenStackReserveVolumeProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8318460928833442854L;
    private static Log logger = LogFactory.getInstance(OpenStackReserveVolumeProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        Map<String, String> productVoldToCshaDrVolId;
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackReserveVolumeProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        ProtectGroup pg = context.getProtectGroup();
        Map<String, String> productVoldToDrVolId = OpenStackRecoveryTool.getProductVolIdToDrVolId(context.getRecoveryPlan(), PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(recoveryPlan.getProtectGroup()));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.generateDrillingProcessors(pg, productVoldToDrVolId);
        } else if (!(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() != this.getProcType() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() != this.getProcType() || this.generatePlanMotionProcessorsForCshaCsdrReprotect(pg, productVoldToCshaDrVolId = OpenStackRecoveryTool.getProductVolIdToDrVolId(context.getRecoveryPlan(), true)))) {
            this.generatePlanMotionProcessors(pg, productVoldToDrVolId);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"no child processor");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        logger.info((Object)("leave OpenStackReserveVolumeSubProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generatePlanMotionProcessors(ProtectGroup pg, Map<String, String> productVoldToDrVolId) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        boolean useDrRes = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && (25 == pg.getTemplate().getType() || PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg));
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        HashSet<OpenStackReserveVolumeSubProcessor> subProcessors = new HashSet<OpenStackReserveVolumeSubProcessor>();
        for (Map.Entry<String, String> entry : productVoldToDrVolId.entrySet()) {
            String productVolId = useDrRes ? entry.getValue() : entry.getKey();
            OpenStackReserveVolumeSubProcessor subProcessor = new OpenStackReserveVolumeSubProcessor(productVolId, regionUuid, projUuid);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private boolean generatePlanMotionProcessorsForCshaCsdrReprotect(ProtectGroup pg, Map<String, String> productVoldToCshaDrVolId) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc()) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() != this.getProcType() || OpenStackCommonUtil.isCsdrCshaMode(pg) || !PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            return false;
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        HashSet<OpenStackReserveVolumeSubProcessor> subProcessors = new HashSet<OpenStackReserveVolumeSubProcessor>();
        for (Map.Entry<String, String> entry : productVoldToCshaDrVolId.entrySet()) {
            String cshaDrVolId = entry.getValue();
            String productVolId = entry.getKey();
            OpenStackReserveVolumeSubProcessor subProcessorForProductVol = new OpenStackReserveVolumeSubProcessor(productVolId, regionUuid, projUuid);
            OpenStackReserveVolumeSubProcessor subProcessorForCshaDrVol = new OpenStackReserveVolumeSubProcessor(cshaDrVolId, regionUuid, projUuid);
            this.initProc((RecoveryProcessor)subProcessorForProductVol);
            subProcessors.add(subProcessorForProductVol);
            this.initProc((RecoveryProcessor)subProcessorForCshaDrVol);
            subProcessors.add(subProcessorForCshaDrVol);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }

    private void generateDrillingProcessors(ProtectGroup pg, Map<String, String> productVoldToDrVolId) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        HashSet drVolUuids = new HashSet();
        HashSet<OpenStackReserveVolumeSubProcessor> subProcessors = new HashSet<OpenStackReserveVolumeSubProcessor>();
        for (Map.Entry<String, String> entry : productVoldToDrVolId.entrySet()) {
            String drVolId;
            String string = drVolId = VerifyUtil.isEmpty((String)entry.getValue()) ? entry.getKey() + "-drvol" : entry.getValue();
            if (drVolUuids.contains(drVolId)) continue;
            OpenStackReserveVolumeSubProcessor subProcessor = new OpenStackReserveVolumeSubProcessor(drVolId, drRegionUuid, drProjUuid);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

