/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackReserveVolumeSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 8079254613004797306L;
    private static Log logger = LogFactory.getInstance(OpenStackReserveVolumeSubProcessor.class);

    public OpenStackReserveVolumeSubProcessor() {
    }

    public OpenStackReserveVolumeSubProcessor(String volUuid, String regionUuid, String projUuid) {
        this.addString("volUuid", volUuid);
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
    }

    public void updateProcNameParams() {
        String volUuid = this.getString("volUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String volumeName = this.getString("volName");
        if (null != volumeName) {
            this.updateProcessNameParams(new String[]{volumeName});
            return;
        }
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        VolumeInfo volInfo = cinderMgr.queryVolume(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(volUuid));
        if (null == volInfo) {
            logger.error((Object)("vol is not exist , the vol uuid : " + volUuid));
            this.updateProcessNameParams(new String[]{OpenStackCommonUtil.getIdFromUuid(volUuid)});
        } else {
            this.updateProcessNameParams(new String[]{volInfo.getName()});
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into ReserveVolumeProcessor");
        String volUuid = this.getString("volUuid");
        String regionUuid = this.getString("regionUuid");
        String projUuid = this.getString("projUuid");
        String volumeName = this.getString("volName");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessNameParams(new String[]{volumeName});
            return true;
        }
        this.updateProcessNameParams(new String[]{OpenStackCommonUtil.getIdFromUuid(volUuid)});
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        VolumeInfo volInfo = cinderMgr.queryVolume(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(volUuid));
        if (null == volInfo) {
            logger.info((Object)("vol(" + volUuid + ") is not exist"));
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            this.updateProcessDetail("lego.err.2117645", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return true;
        }
        this.updateProcessNameParams(new String[]{volInfo.getName()});
        this.addString("volName", volInfo.getName());
        try {
            IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            volumeService.reserveVolume(volUuid, regionUuid, projUuid);
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)("reserve volume(" + volUuid + ") failed."), (Throwable)e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave ReserveVolumeProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

