/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackPowerOnVmProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackShutDownVmSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackShutDownVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4342741744015498178L;
    private static Log logger = LogFactory.getInstance(OpenStackShutDownVmProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackShutDownVmProcessor recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.generateCleanDrillingSubProcessors();
        } else if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            this.generatePlanMotionSubProcessors(context);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"no child processors.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        logger.debug((Object)(" OpenStackShutDownVmProcessor complete subproecess recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        recoveryTemplate.process(context);
        logger.debug((Object)("leave OpenStackShutDownVmProcessor recoveryPlan=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        logger.info((Object)("leave OpenStackShutDownVmProcessor setProcStatus =" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() == this.getProcType()) {
            return true;
        }
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == procStatus.getValue();
    }

    private void generatePlanMotionSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        OpenStackCommonUtil.setProtectObjectAddressMap(pg);
        boolean useDrRes = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isHyperMetroTemplate(pg);
        boolean csdrCshaReProtect = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue() == this.getProcType() && PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg) && !OpenStackCommonUtil.isCsdrCshaMode(pg);
        String regionuuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                logger.info((Object)"po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String vmUuid = po.getMoUuid();
            String vmName = po.getName();
            if (useDrRes) {
                PoReplicaInfo poReplicaInfo;
                String replicationInfo = (String)po.getProps().get("replicationInfo");
                if (PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg)) {
                    replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
                }
                if (null == (poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class))) {
                    logger.error((Object)("json to bean error:replicaInfoStr=" + replicationInfo));
                    continue;
                }
                PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
                if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                    logger.error((Object)("phvmUuid is empty:replicaInfoStr=" + replicationInfo));
                    continue;
                }
                vmUuid = phVm.getVmUuid();
                vmName = phVm.getName();
            }
            OpenStackShutDownVmSubProcessor subProcussor = new OpenStackShutDownVmSubProcessor(vmUuid, vmName, projUuid, regionuuid);
            this.initProc((RecoveryProcessor)subProcussor);
            subProcessors.add((RecoveryProcessor)subProcussor);
            if (!csdrCshaReProtect) continue;
            this.generateShutDownCshaPhVmSubProcessor(regionuuid, projUuid, subProcessors, po);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void generateShutDownCshaPhVmSubProcessor(String regionuuid, String projUuid, Set<RecoveryProcessor> subProcessors, ProtectObject po) {
        String replicationInfo = (String)po.getProps().get("hypermetor_replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            logger.error((Object)("json to bean error:replicaInfoStr=" + replicationInfo));
            return;
        }
        PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
        if (null == phVm || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
            logger.error((Object)("phvmUuid is empty:replicaInfoStr=" + replicationInfo));
            return;
        }
        String vmUuid = phVm.getVmUuid();
        String vmName = phVm.getName();
        OpenStackShutDownVmSubProcessor subProcussorForCshaCsdr = new OpenStackShutDownVmSubProcessor(vmUuid, vmName, projUuid, regionuuid);
        this.initProc((RecoveryProcessor)subProcussorForCshaCsdr);
        subProcessors.add((RecoveryProcessor)subProcussorForCshaCsdr);
    }

    private void generateCleanDrillingSubProcessors() {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue()), OpenStackPowerOnVmProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            return;
        }
        HashSet<OpenStackShutDownVmSubProcessor> subProcessors = new HashSet<OpenStackShutDownVmSubProcessor>();
        for (RecoveryProcessor processor : createProcessors) {
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != processor.getProcStatus()) continue;
            OpenStackPowerOnVmProcessor powerOnVmprocessor = (OpenStackPowerOnVmProcessor)processor;
            OpenStackShutDownVmSubProcessor subProcussor = new OpenStackShutDownVmSubProcessor(powerOnVmprocessor.getString("vmUuid"), powerOnVmprocessor.getString("vmName"), powerOnVmprocessor.getString("projUuid"), powerOnVmprocessor.getString("regionUuid"));
            this.initProc((RecoveryProcessor)subProcussor);
            subProcessors.add(subProcussor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("ism.drm.recovery.prepare.process.des");
        }
    }
}

