/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.cshacsdr;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Set;

public abstract class BaseCshaCsdrRecoveryProcessor
extends BaseRecoveryProcessor
implements IInitialChildProcessor {
    private static final long serialVersionUID = -729256930188252874L;
    private static Log logger = LogFactory.getInstance(BaseCshaCsdrRecoveryProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)"recoveryPlan name:%s, enter into processor:%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan), ((Object)((Object)this)).getClass()});
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E execType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(new ArrayList(RecoveryServiceUtil.sortRecoveryProcessors((Set)this.getChildProc())), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)execType);
        if (null == recoveryTemplate) {
            logger.error((Object)"Create recovery processExecutor failed, recoveryTemplate is null.");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        logger.info((Object)"recoveryPlan name:%s, leave processor:%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan), ((Object)((Object)this)).getClass()});
        return this.calcProcessResultBySubProc();
    }

    protected boolean calcProcessResultBySubProc() {
        boolean executeResult = super.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus() && DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() != this.getProcType()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    protected DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E calcProcStatusBySubProc(Set<RecoveryProcessor> rProcesses) {
        logger.trace((Object)"begin calc BaseCshaCsdrRecoveryProcessor Status start");
        if (!VerifyUtil.isEmpty(rProcesses)) {
            for (RecoveryProcessor process : rProcesses) {
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue() != process.getProcStatus() || !process.getIsEnabled().booleanValue()) continue;
                return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED;
            }
        }
        return super.calcProcStatusBySubProc(rProcesses);
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        String regionType;
        String string = regionType = null == pg ? null : pg.getProperty("RECOVERY_REGION_TYPE");
        if (null == regionType) {
            this.setIsEnabled(true);
        } else if (regionType.equals(this.getRecoveryRegionType())) {
            this.setIsEnabled(true);
        } else {
            this.setIsEnabled(false);
        }
    }

    abstract String getRecoveryRegionType();
}

