/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.cshacsdr;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackClearPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.cshacsdr.OpenStackSwitchHyperPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class OpenStackSwitchHyperPortProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6717845830095338632L;
    private static Log logger = LogFactory.getInstance(OpenStackSwitchHyperPortProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.debug((Object)("Enter into OpenStackSwitchHyperPortProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        List regions = CommonDAOLocator.getMoDao().getMoList(OpenStackRegion.class, "uuid", (Object)regionUuid);
        if (VerifyUtil.isEmpty((Collection)regions)) {
            logger.error((Object)"openstack region is not exist.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return false;
        }
        if (!((OpenStackRegion)CommonUtil.getFirstElement((Collection)regions)).getRegionConfig().getIsSwitchNetwork()) {
            logger.info((Object)"region config:isSwitchNetwork is false,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessorsForCsdrCshaRecovery(context);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.debug((Object)"No ports need to detach,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)true);
        if (null == recoveryTemplate) {
            logger.info((Object)"recoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessorsForCsdrCshaRecovery(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        INeutronManager neutronManager = ManagerFactory.getInstance().getNeutronManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        List<OpenStackPort> portList = neutronManager.getPorts(openstackUuid, regionUuid, tokenId, projectUuid);
        boolean isSecondDisasterRecovery = Boolean.parseBoolean(pg.getProperty("IsSecondDisasterRecovery"));
        HashSet<BaseRecoveryProcessor> subProcSet = new HashSet<BaseRecoveryProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            String vmUuid = po.getMoUuid();
            List<VMInterface> phVmPortList = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, vmUuid);
            if (VerifyUtil.isEmpty(phVmPortList)) {
                logger.error((Object)("the vm has no port,vmName=" + po.getName()));
                continue;
            }
            String portIdStr = OpenStackRecoveryTool.getSortedPortIdStr(phVmPortList, portList);
            if (VerifyUtil.isEmpty((String)portIdStr)) {
                logger.error((Object)("the vm has no valid portId,vmName=" + po.getName()));
                continue;
            }
            if (isSecondDisasterRecovery) {
                String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVM");
                String phVmName = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVMNAME");
                OpenStackClearPortSubProcessor clearPortSubProcessor = new OpenStackClearPortSubProcessor(regionUuid, projectUuid, portIdStr, phVmName, phVmUuid);
                this.initProc((RecoveryProcessor)clearPortSubProcessor);
                subProcSet.add(clearPortSubProcessor);
                continue;
            }
            OpenStackSwitchHyperPortSubProcessor openStackSwitchHyperPortSubProcessor = new OpenStackSwitchHyperPortSubProcessor(regionUuid, projectUuid, portIdStr, po, context);
            this.initProc((RecoveryProcessor)openStackSwitchHyperPortSubProcessor);
            subProcSet.add(openStackSwitchHyperPortSubProcessor);
        }
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

