/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.cshacsdr;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackClearPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDetachPortSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OpenStackSwitchHyperPortSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5660380256054152752L;
    private static Log logger = LogFactory.getInstance(OpenStackSwitchHyperPortSubProcessor.class);

    public OpenStackSwitchHyperPortSubProcessor() {
    }

    public OpenStackSwitchHyperPortSubProcessor(String regionUuid, String projectUuid, String portIdStr, ProtectObject po, RecoveryProcessorContext context) {
        String phVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVM");
        String phVmName = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVMNAME");
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("portIdsOfVM", portIdStr);
        this.addString("vmName", po.getName());
        this.addString("vmUuid", po.getMoUuid());
        this.addString("CSHAPLACEHOLDVMNAME", phVmName);
        this.addString("CSHAPLACEHOLDVM", phVmUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        logger.info((Object)"enter into OpenStackSwitchHyperPortSubProcessor");
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.generateSubProcessors();
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        if (null == recoveryTemplate) {
            logger.info((Object)"recoveryTemplate is null");
            throw new LegoCheckedException(2117645L);
        }
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void generateSubProcessors() {
        HashSet<BaseRecoveryProcessor> subProcSet = new HashSet<BaseRecoveryProcessor>();
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        String portIdStr = this.getString("portIdsOfVM");
        String vmUuid = this.getString("vmUuid");
        String vmName = this.getString("vmName");
        String phVmUuid = this.getString("CSHAPLACEHOLDVM");
        String phVmName = this.getString("CSHAPLACEHOLDVMNAME");
        OpenStackDetachPortSubProcessor detachSubProc = new OpenStackDetachPortSubProcessor(regionUuid, projectUuid, portIdStr, vmName, vmUuid);
        this.initProc((RecoveryProcessor)detachSubProc);
        subProcSet.add(detachSubProc);
        OpenStackClearPortSubProcessor clearPortsubProcessor = new OpenStackClearPortSubProcessor(regionUuid, projectUuid, portIdStr, vmName, vmUuid);
        this.initProc((RecoveryProcessor)clearPortsubProcessor);
        subProcSet.add(clearPortsubProcessor);
        OpenStackAttachPortSubProcessor attachSubProc = new OpenStackAttachPortSubProcessor(regionUuid, projectUuid, portIdStr, phVmName, phVmUuid);
        this.initProc((RecoveryProcessor)attachSubProc);
        subProcSet.add(attachSubProc);
        detachSubProc.setPreviousProcessor(null);
        detachSubProc.setNextProcessor((RecoveryProcessor)clearPortsubProcessor);
        clearPortsubProcessor.setPreviousProcessor((RecoveryProcessor)detachSubProc);
        clearPortsubProcessor.setNextProcessor((RecoveryProcessor)attachSubProc);
        attachSubProc.setPreviousProcessor((RecoveryProcessor)clearPortsubProcessor);
        attachSubProc.setNextProcessor(null);
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }
}

