/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.provider;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.recovery.provider.OpenStackRefactorConfigurationProvider;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OpenStackCshaCsdrHyperRefactorConfigureProvider
extends OpenStackRefactorConfigurationProvider {
    private static Log logger = LogFactory.getInstance(OpenStackCshaCsdrHyperRefactorConfigureProvider.class);

    protected void reverseProtectGroupAttributes(ProtectGroup pg) {
        if (PolicyTemplateTools.getInstance().isCshaCsdrBetweenRegionRecovery(pg)) {
            String zoneName = (String)pg.getProps().get("drZoneName");
            String drZoneName = (String)pg.getProps().get("prod_region_drZoneName");
            pg.getProps().put("drZoneName", drZoneName);
            pg.getProps().put("prod_region_drZoneName", zoneName);
            String hyperCgUuid = (String)pg.getProps().get("hyperProCgUuid");
            String hyperDrCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
            pg.getProps().put("hyperProCgUuid", hyperDrCgUuid);
            pg.getProps().put("hyperProdrCgUuid", hyperCgUuid);
            String cgUuid = (String)pg.getProps().get("replicaCgUuid");
            String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
            String standbyCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
            String standbyDrCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
            pg.getProps().put("replicaCgUuid", standbyCgUuid);
            pg.getProps().put("drReplicaCgUuid", standbyDrCgUuid);
            pg.getProps().put("hyperProRemoteCgUuid", cgUuid);
            pg.getProps().put("hyperProRemotedrCgUuid", drCgUuid);
        }
    }

    protected void reverseProtectObjectAttributes(ProtectObject protectObject) {
        String poReplicaInfoStr = (String)protectObject.getProps().get("hypermetor_replicationInfo");
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            logger.error((Object)"parse poReplicaInfo failed. poName=%s, poReplicaInfoJson= %s", new Object[]{protectObject.getName(), poReplicaInfoStr});
            return;
        }
        this.reverseHyperPoReplicaInfo(poReplicaInfo);
        protectObject.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
        JSONArray volConfigArray = JSONArray.fromObject((Object)protectObject.getProperty("volumeConfig"));
        int size = volConfigArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonInfo = volConfigArray.getJSONObject(i);
            String drVolType = jsonInfo.containsKey((Object)"drVolumeType") ? String.valueOf(jsonInfo.get("drVolumeType")) : "";
            String drHyperVolType = jsonInfo.containsKey((Object)"drHyperVolumeType") ? String.valueOf(jsonInfo.get("drHyperVolumeType")) : "";
            jsonInfo.put((Object)"drHyperVolumeType", (Object)drVolType);
            jsonInfo.put((Object)"drVolumeType", (Object)drHyperVolType);
        }
        protectObject.getProps().put("volumeConfig", volConfigArray.toString());
        String replicaInfoUuid = (String)protectObject.getProps().get("replicationInfo");
        String drReplicaInfoUuid = (String)protectObject.getProps().get("remote_replicationInfo");
        protectObject.getProps().put("replicationInfo", drReplicaInfoUuid);
        protectObject.getProps().put("remote_replicationInfo", replicaInfoUuid);
    }

    private Map<String, String> reverseHyperPoReplicaInfo(PoReplicaInfo poReplicaInfo) {
        String drCgUuid = poReplicaInfo.getDrCgUuid();
        poReplicaInfo.setDrCgUuid(poReplicaInfo.getCgUuid());
        poReplicaInfo.setCgUuid(drCgUuid);
        String poReplicaInfoUuid = poReplicaInfo.getPhVmInfo().getVmUuid();
        String poReplicaInfoVmName = poReplicaInfo.getPhVmInfo().getName();
        poReplicaInfo.getPhVmInfo().setVmUuid(poReplicaInfo.getMoUuid());
        poReplicaInfo.getPhVmInfo().setName(poReplicaInfo.getVmName());
        poReplicaInfo.setMoUuid(poReplicaInfoUuid);
        poReplicaInfo.setVmName(poReplicaInfoVmName);
        HashMap<String, String> drVolTypeProductVolType = new HashMap<String, String>();
        Iterator itr = poReplicaInfo.getPairInfos().iterator();
        while (itr.hasNext()) {
            PoReplicaPairInfo pairInfo = (PoReplicaPairInfo)itr.next();
            String volUuid = pairInfo.getVolumeUuid();
            String volType = pairInfo.getVolumeType();
            String replicaUuid = pairInfo.getReplicaUuid();
            String drVolUuid = pairInfo.getDrVolumeUuid();
            String drVolType = pairInfo.getDrVolumeType();
            String drReplicaUuid = pairInfo.getDrReplicaUuid();
            if (VerifyUtil.isEmpty((String)drVolUuid)) {
                logger.info((Object)(pairInfo.getVolumeName() + " has no drvolume."));
                itr.remove();
                continue;
            }
            pairInfo.setVolumeType(drVolType);
            pairInfo.setReplicaUuid(drReplicaUuid);
            pairInfo.setVolumeUuid(drVolUuid);
            pairInfo.setDrVolumeType(volType);
            pairInfo.setDrReplicaUuid(replicaUuid);
            pairInfo.setDrVolumeUuid(volUuid);
            if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) {
                logger.info((Object)(pairInfo.getVolumeName() + "'s status is " + pairInfo.getVolumeStatus() + ", and set it to removed."));
                pairInfo.setVolumeStatus(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.RELEASING.getStatus());
            }
            drVolTypeProductVolType.put(drVolType, volType);
        }
        return drVolTypeProductVolType;
    }

    protected void exchangeRecoverySetting(RecoveryPlan recoveryPlan, ProtectGroup protectGroup) {
        for (ProtectObject po : protectGroup.getPolist()) {
            String poReplicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                logger.error((Object)("parse poReplicaInfo failed. poName=" + po.getName() + ", poReplicaInfoJson=" + poReplicaInfoStr));
                return;
            }
            for (RecoverySetting setting : recoveryPlan.getRecoverySettings()) {
                if ("PLACEHOLDVM".equals(setting.getName()) && po.getUuid().equals(setting.getOwnerId())) {
                    setting.setValue(poReplicaInfo.getMoUuid());
                }
                if ("PLACEHOLDVMNAME".equals(setting.getName()) && po.getUuid().equals(setting.getOwnerId())) {
                    setting.setValue(poReplicaInfo.getVmName());
                }
                if ("CSHAPLACEHOLDVM".equals(setting.getName()) && po.getUuid().equals(setting.getOwnerId())) {
                    setting.setValue(poReplicaInfo.getPhVmInfo().getVmUuid());
                }
                if (!"CSHAPLACEHOLDVMNAME".equals(setting.getName()) || !po.getUuid().equals(setting.getOwnerId())) continue;
                setting.setValue(poReplicaInfo.getPhVmInfo().getName());
            }
        }
    }
}

