/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolAttachInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OpenStackVmResRollBackExecutor
implements IRollBackExecutor {
    private static final Log logger = LogFactory.getInstance(OpenStackVmResRollBackExecutor.class);
    private static Map<String, Date> cgUuidLockMap = new ConcurrentHashMap<String, Date>();
    private IVolumeService volumeService;

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public String getName() {
        return "OpenStackVmResRollBackExecutor";
    }

    public boolean execute(String param) {
        if (VerifyUtil.isEmpty((String)param)) {
            logger.warn((Object)"param is empty.");
            return true;
        }
        logger.info((Object)("start vmrollback param info=" + param), 90160758786988L);
        JSONObject json = JSONObject.fromObject((Object)param);
        if (json.containsKey((Object)"rollbackupside")) {
            PoReplicaInfo activePoReplicaInfo = VerifyUtil.isEmpty((Map)json.getJSONObject("replicationInfo")) ? null : (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject("replicationInfo"), PoReplicaInfo.class);
            int operationType = json.getInt("operationType");
            Object pg = null;
            if (OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.ADD_PROTECTOBJECT.getType() == operationType || OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.MODIFY_VOLUME.getType() == operationType) {
                this.switchAllRing(activePoReplicaInfo, operationType, json, false);
            }
            if (!VerifyUtil.isEmpty((Object)activePoReplicaInfo)) {
                logger.info((Object)("vmrollback.vmname=" + activePoReplicaInfo.getVmName() + ",vmUUID=" + activePoReplicaInfo.getMoUuid() + ", vmname belongs to vha+csdr."));
                VolumeReplicationCgInfo cgInfo = null;
                DrExtendManager mgr = new DrExtendManager();
                String tokenId = TokenUtil.getInstance().getTokenId(activePoReplicaInfo.getProjUuid());
                if (!VerifyUtil.isEmpty((String)activePoReplicaInfo.getCgUuid())) {
                    cgInfo = mgr.queryRealtimeVolumeReplicationCG(activePoReplicaInfo.getRegionUuid(), tokenId, activePoReplicaInfo.getProjUuid(), OpenStackCommonUtil.getIdFromUuid(activePoReplicaInfo.getCgUuid()), new int[0]);
                }
                if (OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.CREATE_PROTECTGROUP.getType() == operationType) {
                    logger.info((Object)("vmrollback.vmname=" + activePoReplicaInfo.getVmName() + ",vmUUID=" + activePoReplicaInfo.getMoUuid() + ", start close and delete ring."));
                    this.rollBackupCloseAndDeleteRing(param, "replicationInfo");
                    logger.info((Object)("vmrollback.vmname=" + activePoReplicaInfo.getVmName() + ",vmUUID=" + activePoReplicaInfo.getMoUuid() + ", end close and delete ring."));
                }
                if (cgInfo != null && !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(cgInfo.getReplicationStatus()) || null == cgInfo) {
                    logger.info((Object)("vmrollback.vmname=" + activePoReplicaInfo.getVmName() + ",vmUUID=" + activePoReplicaInfo.getMoUuid() + ",delete replicationcg process(standby->hypermetro->production)."));
                    this.rollback(param, "remote_replicationInfo", "standbyside");
                    this.rollback(param, "hypermetor_replicationInfo", "hypermetorside");
                    this.rollback(param, "replicationInfo", "activeside");
                } else {
                    logger.info((Object)("vmrollback.vmname=" + activePoReplicaInfo.getVmName() + ",vmUUID=" + activePoReplicaInfo.getMoUuid() + ",delete replicationcg process(production->hypermetro->standby, standby switch to active)."));
                    this.rollback(param, "replicationInfo", "standbyside");
                    this.rollback(param, "hypermetor_replicationInfo", "hypermetorside");
                    this.rollback(param, "remote_replicationInfo", "activeside");
                }
            } else {
                this.rollback(param, "hypermetor_replicationInfo", "hypermetorside");
                this.rollback(param, "replicationInfo", "standbyside");
                this.rollback(param, "remote_replicationInfo", "activeside");
            }
            if (OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.ADD_PROTECTOBJECT.getType() == operationType || OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.MODIFY_VOLUME.getType() == operationType) {
                this.switchAllRing(activePoReplicaInfo, operationType, json, true);
            }
        } else {
            this.rollback(param, "replicationInfo", null);
        }
        if (json.containsKey((Object)"SERVICEINSTANCE_UUID")) {
            logger.debug((Object)"vmrollback.vha or csdr instance need update instance status to normal.");
            ServiceInstanceHelper.getInstance().changeStatus(json.get("SERVICEINSTANCE_UUID").toString(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.NORMAL);
        }
        return true;
    }

    private void switchAllRing(PoReplicaInfo activePoReplicaInfo, int operationType, JSONObject json, boolean isOpen) {
        String action = isOpen ? "open" : "close";
        logger.info((Object)("vmrollback.vmname=" + (activePoReplicaInfo != null ? activePoReplicaInfo.getVmName() : "") + ",vmUUID=" + (activePoReplicaInfo != null ? activePoReplicaInfo.getMoUuid() : "") + ", add volume and vm need " + action + " ring.operationType" + operationType));
        int template = json.getInt("template");
        Map pgProp = json.toMap(String.class);
        if (34 != template && 37 != template) {
            return;
        }
        String standbyRingUuid = (String)pgProp.get("standbyDRRingUuid");
        String hyperRingUuid = (String)pgProp.get("hyperDRRingID");
        String proRingUuid = (String)pgProp.get("prodRingID");
        String projUuid = (String)pgProp.get("projectId");
        String drProjUuid = (String)pgProp.get("drProjectId");
        String regionUuid = (String)pgProp.get("regionId");
        String drRegionUuid = (String)pgProp.get("drRegionId");
        if (isOpen) {
            this.openRing(drProjUuid, drRegionUuid, standbyRingUuid);
            this.openRing(projUuid, regionUuid, proRingUuid);
            this.openRing(projUuid, regionUuid, hyperRingUuid);
        } else {
            this.closeRing(drProjUuid, drRegionUuid, standbyRingUuid, true);
            this.closeRing(projUuid, regionUuid, proRingUuid, true);
            this.closeRing(projUuid, regionUuid, hyperRingUuid, true);
        }
    }

    private void rollBackupCloseAndDeleteRing(String param, String operationPoRelication) {
        String drHyperMetorRingID;
        JSONObject json = JSONObject.fromObject((Object)param);
        if (VerifyUtil.isEmpty((Map)json.getJSONObject(operationPoRelication))) {
            logger.info((Object)("vmrollback.rollBackupCloseRing json  is null, rollback info=" + param + ", operationPoRelication=" + operationPoRelication));
            return;
        }
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)poReplicaInfo)) {
            logger.info((Object)"vmrollback.rollBackup close ring,json to bean error, poReplicaInfo is null");
            return;
        }
        String regionId = poReplicaInfo.getRegionUuid();
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String projectId = poReplicaInfo.getProjUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        String prodRingID = json.containsKey((Object)"prodRingID") ? json.getString("prodRingID") : null;
        String drStandByRingID = json.containsKey((Object)"standbyDRRingUuid") ? json.getString("standbyDRRingUuid") : null;
        String string = drHyperMetorRingID = json.containsKey((Object)"hyperDRRingID") ? json.getString("hyperDRRingID") : null;
        if (!VerifyUtil.isEmpty((String)prodRingID)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",vmUUID=" + poReplicaInfo.getMoUuid() + ", close production ring.ringid=" + prodRingID));
            this.closeRing(projectId, regionId, prodRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)drStandByRingID)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",vmUUID=" + poReplicaInfo.getMoUuid() + ", close disaster standby ringid=" + drStandByRingID));
            this.closeRing(drProjectId, drRegionId, drStandByRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)drHyperMetorRingID)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",vmUUID=" + poReplicaInfo.getMoUuid() + ", close disaster hypermetro ringid=" + drHyperMetorRingID));
            this.closeRing(projectId, regionId, drHyperMetorRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)drStandByRingID)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",vmUUID=" + poReplicaInfo.getMoUuid() + ", delete disaster standby ring.ringid=" + drStandByRingID));
            this.deleteRing(drProjectId, drRegionId, drStandByRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)drHyperMetorRingID)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",vmUUID=" + poReplicaInfo.getMoUuid() + ", delete disaster hypermetro ring.ringid=" + drHyperMetorRingID));
            this.deleteRing(projectId, regionId, drHyperMetorRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)prodRingID)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",vmUUID=" + poReplicaInfo.getMoUuid() + ", delete production  ring.ringid=" + prodRingID));
            this.deleteRing(projectId, regionId, prodRingID, true);
        }
    }

    private void rollbackupDeleteVolume(String param, String operationPoRelication, String replicationSide) {
        JSONObject json = JSONObject.fromObject((Object)param);
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        String regionId = poReplicaInfo.getRegionUuid();
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String projectId = poReplicaInfo.getProjUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete volume.,vmUUID=" + poReplicaInfo.getMoUuid() + ", replicationSide=" + replicationSide));
        if ("hypermetorside".equals(replicationSide)) {
            drRegionId = regionId;
            drProjectId = projectId;
        }
        if (!"standbyside".equals(replicationSide)) {
            this.deleteVolume(poReplicaInfo, drRegionId, drProjectId);
        }
        logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", end delete volume.,vmUUID=" + poReplicaInfo.getMoUuid() + ", replicationSide=" + replicationSide));
    }

    private void openRing(String projUuid, String regionUuid, String ringUuid) {
        try {
            this.volumeService.openRing(regionUuid, projUuid, ringUuid);
        }
        catch (LegoCheckedException e) {
            if (1073947394L == e.getErrorCode()) {
                logger.error((Object)("open ring success for rollback, ringUUID : " + ringUuid + " ex: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                return;
            }
            logger.error((Object)("open ring fail, ringUUID : " + ringUuid + " ex: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw e;
        }
    }

    private void deleteTagToVm(PoReplicaInfo poReplicationInfo) {
        if (poReplicationInfo == null) {
            logger.error((Object)"vmrollback.deleting Tag from vm failed.param error,PoReplicaInfo is null");
            return;
        }
        String reginUuid = poReplicationInfo.getRegionUuid();
        String projectUuid = poReplicationInfo.getProjUuid();
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(reginUuid);
        String drRreginUuid = poReplicationInfo.getDrRegionUuid();
        String drProjectUuid = poReplicationInfo.getDrProjUuid();
        String drTokenId = TokenUtil.getInstance().getTokenId(drProjectUuid);
        if (VerifyUtil.isEmpty((String)reginUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)("vmrollback.deleting Tag from vm failed.vmUUID=" + poReplicationInfo.getMoUuid() + ",some param is null,reginUuid:" + reginUuid + ", projectUuid:" + projectUuid + ", openstackUuid:" + openstackUuid + ", drRegionUuid:" + drRreginUuid + ", drprojectUuid:" + drProjectUuid));
            return;
        }
        if (VerifyUtil.isEmpty((String)drRreginUuid) || VerifyUtil.isEmpty((String)drProjectUuid) || VerifyUtil.isEmpty((String)drTokenId)) {
            logger.info((Object)("vmrollback.deleting Tag from vm failed.vmUUID=" + poReplicationInfo.getMoUuid() + ",some param is null, drRegionUuid:" + drRreginUuid + ", drprojectUuid:" + drProjectUuid));
            return;
        }
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        logger.debug((Object)("vmrollback.start deleting __type_pd  Tag from production vm.vmUUID=" + poReplicationInfo.getMoUuid()));
        novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_pd");
        logger.debug((Object)("vmrollback.end deleting __type_pd  Tag from production vm.vmUUID=" + poReplicationInfo.getMoUuid()));
        logger.debug((Object)("vmrollback.start deleting __type_dr  Tag from production vm.vmUUID=" + poReplicationInfo.getMoUuid()));
        novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_dr");
        logger.debug((Object)("vmrollback.end deleting __type_dr  Tag from production vm.vmUUID=" + poReplicationInfo.getMoUuid()));
        logger.debug((Object)("vmrollback.start deleting __type_csha  Tag from production vm.vmUUID=" + poReplicationInfo.getMoUuid()));
        novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_csha");
        logger.debug((Object)("vmrollback.end deleting __type_csha  Tag from production vm.vmUUID=" + poReplicationInfo.getMoUuid()));
        OpenStackVM phVm = novaMgr.getVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), new int[0]);
        novaMgr.deleteDrBackUpTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), phVm);
        PhVmInfo phVmInfo = poReplicationInfo.getPhVmInfo();
        if (!VerifyUtil.isEmpty((Object)phVmInfo) && !VerifyUtil.isEmpty((String)phVmInfo.getVmUuid())) {
            logger.debug((Object)("vmrollback.start deleting __type_dr Tag from phvm.vmUUID=" + phVmInfo.getVmUuid()));
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_dr");
            logger.debug((Object)("vmrollback.end deleting __type_dr Tag from phvm.vmUUID=" + phVmInfo.getVmUuid()));
            logger.debug((Object)("vmrollback.start deleting __type_pd Tag from phvm.vmUUID=" + phVmInfo.getVmUuid()));
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_pd");
            logger.debug((Object)("vmrollback.end deleting __type_pd Tag from phvm.vmUUID=" + phVmInfo.getVmUuid()));
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_csha");
            logger.debug((Object)("vmrollback.end deleting __type_csha Tag from phvm.vmUUID=" + phVmInfo.getVmUuid()));
            OpenStackVM drVm = novaMgr.getVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), new int[0]);
            novaMgr.deleteDrBackUpTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), drVm);
        }
    }

    private void deleteVolume(PoReplicaInfo poReplicaInfo, String drRegionId, String drProjectId) {
        List pairInfoList = poReplicaInfo.getPairInfos();
        logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete volume., vmUUID=" + poReplicaInfo.getMoUuid()));
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            if (VerifyUtil.isEmpty((String)drVolumeUuid)) continue;
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete volume.,vmUUID=" + poReplicaInfo.getMoUuid() + ", drVolumeUuid=" + drVolumeUuid));
            this.volumeService.delVolume(drVolumeUuid, drRegionId, drProjectId);
        }
        logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", end delete volume., vmUUID=" + poReplicaInfo.getMoUuid()));
    }

    private void deleteReplica(String param, PoReplicaInfo poReplicaInfo, String regionId, String drRegionId, String projectId, String drProjectId) {
        this.removeReplicaFromCg(poReplicaInfo, true);
        this.removeReplicaFromCg(poReplicaInfo, false);
        List pairInfoList = poReplicaInfo.getPairInfos();
        logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete replication and volumeMetadata,vmUUID=" + poReplicaInfo.getMoUuid()));
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            boolean isUpgrade;
            JSONObject json;
            String srcReplicaUuid = pairInfo.getReplicaUuid();
            String drReplicaUuid = pairInfo.getDrReplicaUuid();
            if (!VerifyUtil.isEmpty((String)srcReplicaUuid)) {
                logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete production replication,vmUUID=" + poReplicaInfo.getMoUuid() + ", srcReplicaUuid=" + srcReplicaUuid));
                this.volumeService.delVolReplica(regionId, projectId, srcReplicaUuid, false, false);
            }
            if (!VerifyUtil.isEmpty((String)drReplicaUuid)) {
                logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete disaster replication,vmUUID=" + poReplicaInfo.getMoUuid() + ", drReplicaUuid=" + drReplicaUuid));
                this.volumeService.delVolReplica(drRegionId, drProjectId, drReplicaUuid, false, false);
            }
            String serviceType = (json = JSONObject.fromObject((Object)param)).containsKey((Object)"serviceInstanceType") ? json.getString("serviceInstanceType") : "";
            String beforeUpgradeType = json.containsKey((Object)"BEFORE_UPGRADE_TYPE") ? json.get("BEFORE_UPGRADE_TYPE").toString() : "";
            boolean bl = isUpgrade = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.isCurrent(serviceType) && (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.isCurrent(beforeUpgradeType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.isCurrent(beforeUpgradeType));
            if (!isUpgrade && !VerifyUtil.isEmpty((String)pairInfo.getVolumeUuid())) {
                logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete production volume metadata,vmUUID=" + poReplicaInfo.getMoUuid() + ", volumeUuid=" + pairInfo.getVolumeUuid()));
                this.volumeService.deleteVolMetadatas(regionId, projectId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid()), "occupied_volume");
            }
            if (isUpgrade || VerifyUtil.isEmpty((String)pairInfo.getDrVolumeUuid())) continue;
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete replication and volumeMetadata,vmUUID=" + poReplicaInfo.getMoUuid() + ", volumeUuid=" + pairInfo.getDrVolumeUuid()));
            this.volumeService.deleteVolMetadatas(drRegionId, drProjectId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid()), "occupied_volume");
        }
        logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", end delete replication and volumeMetadata,vmUUID=" + poReplicaInfo.getMoUuid()));
    }

    private void removeReplicaFromCg(PoReplicaInfo poReplicaInfo, boolean isMaster) {
        String cgUuid;
        String regionUuid = isMaster ? poReplicaInfo.getRegionUuid() : poReplicaInfo.getDrRegionUuid();
        String projectUuid = isMaster ? poReplicaInfo.getProjUuid() : poReplicaInfo.getDrProjUuid();
        String string = cgUuid = isMaster ? poReplicaInfo.getCgUuid() : poReplicaInfo.getDrCgUuid();
        if (VerifyUtil.isEmpty((String)cgUuid)) {
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", remove replication from Cg.,vmUUID=" + poReplicaInfo.getMoUuid() + ", the cg is empty,need not to remove replications.cg is " + (isMaster ? "production" : "disaster")));
            return;
        }
        Set replicaIdStillInCg = this.volumeService.getReplicaIdsOfCg(regionUuid, projectUuid, cgUuid);
        if (VerifyUtil.isEmpty((Collection)replicaIdStillInCg)) {
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", remove replication from Cg.,vmUUID=" + poReplicaInfo.getMoUuid() + ", the cg is has no replica now, cguuid=" + cgUuid + ", replications cg is " + (isMaster ? "production" : "disaster")));
            return;
        }
        HashSet<String> replicaIdSet = new HashSet<String>();
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            String replicaUuid = isMaster ? pairInfo.getReplicaUuid() : pairInfo.getDrReplicaUuid();
            String replicaId = OpenStackCommonUtil.getIdFromUuid(replicaUuid);
            if (!replicaIdStillInCg.contains(replicaId)) continue;
            replicaIdSet.add(replicaId);
        }
        if (replicaIdSet.isEmpty()) {
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", remove replication from Cg.,vmUUID=" + poReplicaInfo.getMoUuid() + ", target replications are not in cg now, cguuid=" + cgUuid + ", replications cg is " + (isMaster ? "production" : "disaster")));
            return;
        }
        this.volumeService.updateVolumeReplicationCG(regionUuid, projectUuid, cgUuid, null, replicaIdSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCg(PoReplicaInfo poReplicaInfo, String regionId, String drRegionId, String projectId, String drProjectId) {
        Date date;
        String replicaCgUuid = poReplicaInfo.getCgUuid();
        String drReplicaCgUuid = poReplicaInfo.getDrCgUuid();
        logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete CG,vmUUID=" + poReplicaInfo.getMoUuid() + ", replicaCgUuid=" + replicaCgUuid + ", drReplicaCgUuid=" + drReplicaCgUuid));
        if (!VerifyUtil.isEmpty((String)replicaCgUuid)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", delete production CG,cguuid=" + replicaCgUuid + ",vmUUID=" + poReplicaInfo.getMoUuid()));
            this.genCgUuidLock(replicaCgUuid);
            date = cgUuidLockMap.get(replicaCgUuid);
            synchronized (date) {
                logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",succeed geting lock and  start delete production CG,cguuid=" + replicaCgUuid + ",vmUUID=" + poReplicaInfo.getMoUuid()));
                this.volumeService.delReplicaCG(regionId, projectId, replicaCgUuid, false, false);
                logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",succeed geting lock and  end delete production CG,cguuid=" + replicaCgUuid + ",vmUUID=" + poReplicaInfo.getMoUuid()));
            }
        }
        if (!VerifyUtil.isEmpty((String)drReplicaCgUuid)) {
            logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", delete disaster CG,cguuid=" + drReplicaCgUuid + ",vmUUID=" + poReplicaInfo.getMoUuid()));
            this.genCgUuidLock(drReplicaCgUuid);
            date = cgUuidLockMap.get(drReplicaCgUuid);
            synchronized (date) {
                logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",succeed geting lock and  start delete disaster CG,cguuid=" + drReplicaCgUuid + ",vmUUID=" + poReplicaInfo.getMoUuid()));
                this.volumeService.delReplicaCG(drRegionId, drProjectId, drReplicaCgUuid, false, false);
                logger.debug((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",succeed deleting disaster CG,cguuid=" + drReplicaCgUuid + ",vmUUID=" + poReplicaInfo.getMoUuid()));
            }
        }
        logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", end delete CG,vmUUID=" + poReplicaInfo.getMoUuid() + ", replicaCgUuid=" + replicaCgUuid + ", drReplicaCgUuid=" + drReplicaCgUuid));
    }

    private synchronized void genCgUuidLock(String cgUuid) {
        if (cgUuidLockMap.containsKey(cgUuid)) {
            return;
        }
        if (cgUuidLockMap.size() > 20) {
            ArrayList<Date> lockObjList = new ArrayList<Date>(cgUuidLockMap.values());
            Collections.sort(lockObjList);
            Date value = (Date)lockObjList.get(0);
            for (Map.Entry<String, Date> entry : cgUuidLockMap.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                cgUuidLockMap.remove(entry.getKey());
                break;
            }
        }
        cgUuidLockMap.put(cgUuid, new Date());
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    private void closeRing(String projId, String regionId, String ringId, boolean splitFlag) {
        logger.info((Object)("rollback close ring:ringId=" + ringId + ",splitFlag:" + splitFlag));
        OpenStackCommonUtil.closeRing(this.volumeService, projId, regionId, ringId, String.valueOf(splitFlag));
    }

    private void deleteRing(String projId, String regionId, String ringId, boolean splitFlag) {
        logger.info((Object)("rollback delete ring:ringId=" + ringId + ",splitFlag:" + splitFlag));
        OpenStackCommonUtil.deleteRing(this.volumeService, projId, regionId, ringId, String.valueOf(splitFlag));
    }

    private boolean rollback(String param, String operationPoRelication, String replicationSide) {
        String serviceType;
        boolean isSkipReconnect;
        String beforeUpgradeType;
        JSONObject json = JSONObject.fromObject((Object)param);
        if (json.containsKey((Object)"BEFORE_UPGRADE_TYPE") && this.isNeedRollback(beforeUpgradeType = json.get("BEFORE_UPGRADE_TYPE").toString(), replicationSide)) {
            PoReplicaInfo tempPoReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
            logger.debug((Object)("vmrollback vmname=" + (tempPoReplicaInfo != null ? tempPoReplicaInfo.getVmName() : " poReplicaInfo is null. ") + ", Update instance type(VHA+HyperMetroSide and CSDR+ActiveSide) do not need rollback.beforeUpgradeType=" + beforeUpgradeType + ", replicationSide=" + replicationSide + ",vmUUID=" + (tempPoReplicaInfo != null ? tempPoReplicaInfo.getMoUuid() : " is null. ")));
            return true;
        }
        int operationType = json.getInt("operationType");
        if (null == json.getJSONObject(operationPoRelication)) {
            logger.error((Object)("vmrollback failed.rollback json  is null, rollback info=" + param + ", operationPoRelication=" + operationPoRelication));
            return false;
        }
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            logger.error((Object)"vmrollback failed.json to bean error, poReplicaInfo is null");
            return false;
        }
        String regionId = poReplicaInfo.getRegionUuid();
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String projectId = poReplicaInfo.getProjUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)drRegionId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)drProjectId)) {
            logger.error((Object)("vmrollback failed. vmname=" + poReplicaInfo.getVmName() + " param is error.regionId=" + regionId + ",drRegionId=" + drRegionId + ",projectId=" + projectId + ",vmUUID=" + poReplicaInfo.getMoUuid()));
            return false;
        }
        logger.info((Object)("start vmrollback. vmname=" + poReplicaInfo.getVmName() + (replicationSide != null ? ",belong to vha+csdr,replicationSide=" + replicationSide : "belong to other type.") + ", operationType=" + operationType + ",vmUUID=" + poReplicaInfo.getMoUuid()));
        if (null != replicationSide && replicationSide.equals("hypermetorside")) {
            drRegionId = regionId;
            drProjectId = projectId;
        }
        if (!(isSkipReconnect = this.isSkipReconnect(replicationSide, serviceType = json.containsKey((Object)"serviceInstanceType") ? json.getString("serviceInstanceType") : ""))) {
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ",need to reconnctVolume.,vmUUID=" + poReplicaInfo.getMoUuid()));
            this.reconnectVolumes(poReplicaInfo);
        }
        if (this.isDeleteTag(replicationSide, operationType)) {
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", start delete tag from vm.,vmUUID=" + poReplicaInfo.getMoUuid()));
            this.deleteTagToVm(poReplicaInfo);
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", end delete tag from vm.,vmUUID=" + poReplicaInfo.getMoUuid()));
        }
        if (OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.CREATE_PROTECTGROUP.getType() == operationType) {
            this.deleteCg(poReplicaInfo, regionId, drRegionId, projectId, drProjectId);
        }
        this.deleteReplica(param, poReplicaInfo, regionId, drRegionId, projectId, drProjectId);
        this.rollbackupDeleteVolume(param, operationPoRelication, replicationSide);
        logger.info((Object)("vmrollback succeed.vmname=" + poReplicaInfo.getVmName() + ",vmUUID=" + poReplicaInfo.getMoUuid()));
        return true;
    }

    private void reconnectVolumes(PoReplicaInfo poReplicaInfo) {
        String vmUuid = poReplicaInfo.getMoUuid();
        String reginUuid = poReplicaInfo.getRegionUuid();
        String projectUuid = poReplicaInfo.getProjUuid();
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(reginUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List pairInfoList = poReplicaInfo.getPairInfos();
        logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", vmUuid=" + vmUuid + ", reconnectVolumes begin."));
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            VolAttachInfo attachInfo;
            String volumeUuid = pairInfo.getVolumeUuid();
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", vmUuid=" + vmUuid + ",check  volumeID=" + volumeUuid + "is attached."));
            if (!this.isAttach(reginUuid, projectUuid, vmUuid, volumeId) || !OpenStackCommonUtil.checkHyperMetroVolPath(attachInfo = novaMgr.getVolumeAttachInfo(vmUuid, reginUuid, tokenId, volumeId))) continue;
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", vmUuid=" + vmUuid + ", volume has HyperMetro Path. volumeId :" + volumeId));
            ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
            reconnVolumeInfo.setVolumeId(volumeId);
            reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(false));
            novaMgr.reattachAndCheckVolume(new ReattchParam(reginUuid, projectUuid, tokenId), vmUuid, reconnVolumeInfo);
            logger.info((Object)("vmrollback.vmname=" + poReplicaInfo.getVmName() + ", vmUuid=" + vmUuid + ", reconnectVolumes succussfully. volumeId :" + volumeId));
        }
    }

    private boolean isSkipReconnect(String replicationSide, String serviceType) {
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(serviceType) || Arrays.asList("standbyside", "activeside").contains(replicationSide);
    }

    private boolean isDeleteTag(String replicationSide, int operationType) {
        return !"standbyside".equals(replicationSide) && (OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.CREATE_PROTECTGROUP.getType() == operationType || OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.ADD_PROTECTOBJECT.getType() == operationType);
    }

    private boolean isAttach(String reginUuid, String projectUuid, String vmUuid, String volumeId) {
        boolean isAttach = false;
        if (this.volumeService.isAttachVM(reginUuid, projectUuid, vmUuid, volumeId) && OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            isAttach = true;
        }
        return isAttach;
    }

    private boolean isNeedRollback(String beforeUpgradeType, String replicationSide) {
        return ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(beforeUpgradeType) && "hypermetorside".equals(replicationSide) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(beforeUpgradeType) && "activeside".equals(replicationSide);
    }
}

