/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.meter.model.MeterRecord;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.IKeystoreManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.IAMManager;
import com.huawei.ism.drm.openstack.adapter.util.EndpointUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cert.component.OpenstackDependedCertificateService;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZone;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackRegion;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackServiceEndPoint;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenstackMetaData;
import com.huawei.ism.drm.openstack.sdk.msg.CloudAvailableZone;
import com.huawei.ism.drm.openstack.sdk.msg.CloudInfra;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.serviceinstance.SDRRegisterHelper;
import com.huawei.ism.drm.openstack.serviceinstance.dao.IMeterDao;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Service(Name="com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService", Desc="", Interface=IOpenstackResourceService.class)
public class OpenstackResourceServiceImpl
extends BaseService
implements IOpenstackResourceService {
    private static final Log logger = LogFactory.getInstance(OpenstackResourceServiceImpl.class);
    private static final String META_START_KEY = "start";
    private static final String META_END_KEY = "end";
    private static final String META_VALUE_KEY = "value";
    private static final Set<String> SERVICE_TYPE_SET = new HashSet<String>(Arrays.asList("compute", "network", "volume", "agent", "compute-ext", "metering", "image", "apicom"));
    private IMeterDao meterDao;
    private OpenstackDependedCertificateService openstackDependedCertificateService;

    public IMeterDao getMeterDao() {
        return this.meterDao;
    }

    public void setMeterDao(IMeterDao meterDao) {
        this.meterDao = meterDao;
    }

    public List<OpenStackAvailabilityZone> getAvailabilityZones(String openstackUuid, String regionUuid, String projectUuid, Boolean zoneState) {
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)projectUuid)) {
            logger.error((Object)("param is empty:projectUuid=" + projectUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        ICinderManager manager = ManagerFactory.getInstance().getCinderManager(openstackUuid);
        if (!regionUuid.contains(":")) {
            regionUuid = OpenStackCommonUtil.getObjectUuid(openstackUuid, regionUuid);
        }
        List<OpenStackAvailabilityZone> result = manager.getAzs(regionUuid, tokenId, projectUuid);
        if (null != zoneState && null != result && !result.isEmpty()) {
            Iterator<OpenStackAvailabilityZone> itr = result.iterator();
            while (itr.hasNext()) {
                OpenStackAvailabilityZone az = itr.next();
                if (zoneState.equals(az.getZoneAvailable())) continue;
                itr.remove();
            }
        }
        return result;
    }

    public List<OpenStackProject> getProjectFromDB(String openstackUuid, Boolean isEnable) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)("param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(openstackUuid);
        String unscopedToken = TokenUtil.getInstance().getTokenId(open, null);
        IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, open.isUseIAM());
        List<OpenStackProject> openStackProjects = keystoreMgr.getProjects(open, unscopedToken);
        Collections.sort(openStackProjects, new Comparator<OpenStackProject>(){

            @Override
            public int compare(OpenStackProject arg0, OpenStackProject arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        if (VerifyUtil.isEmpty((Object)isEnable)) {
            return openStackProjects;
        }
        ArrayList<OpenStackProject> openStackProjectsReturn = new ArrayList<OpenStackProject>();
        for (OpenStackProject osp : openStackProjects) {
            if (!isEnable.equals(osp.getEnabled())) continue;
            openStackProjectsReturn.add(osp);
        }
        return openStackProjectsReturn;
    }

    public OpenStackProject getProjectByProjectUUid(String projectUUid) {
        if (VerifyUtil.isEmpty((String)projectUUid)) {
            logger.error((Object)("param is projectUUid=" + projectUUid));
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject managedObject = CommonDAOLocator.getMoDao().getMoByUuid(projectUUid, Boolean.valueOf(true));
        if (!VerifyUtil.isEmpty((Object)managedObject) && !VerifyUtil.isEmpty((String)managedObject.getName())) {
            return (OpenStackProject)managedObject;
        }
        logger.info((Object)("can't find project from DB,find it from OpenStack,projectUUid=" + projectUUid));
        OpenstackInfo open = ManagerFactory.getInstance().getRegOpenstack(OpenStackCommonUtil.getOpenstackUuidFromStr(projectUUid));
        String unscopedToken = TokenUtil.getInstance().getTokenId(open, null);
        IKeystoreManager keystoreMgr = ManagerFactory.getInstance().getKeystoreManagerByVersion(null, open.isUseIAM());
        List<OpenStackProject> projList = keystoreMgr.getProjects(open, unscopedToken);
        for (OpenStackProject openStackProject : projList) {
            if (!openStackProject.getUuid().equals(projectUUid)) continue;
            return openStackProject;
        }
        return null;
    }

    public List<OpenStackRegion> getRegionFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)("param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        List regionList = CommonDAOLocator.getMoDao().find("from OpenStackRegion where parentMo.uuid = ? order by name", new Object[]{openstackUuid});
        return regionList;
    }

    public void updateRegion(OpenStackRegion region) {
        try {
            CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)region);
        }
        catch (HibernateException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("updateRegion:" + region.getUuid()), (long)1073947393L, (String[])new String[0], (Log)logger);
        }
    }

    public List<OpenStackServiceEndPoint> getEndPointFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)("param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        List services = CommonDAOLocator.getMoDao().find("from OpenStackServiceEndPoint where topMoUuid = ? order by name", new Object[]{openstackUuid});
        return services;
    }

    public void updateRegionService(String openstackUuid, Map<String, List<OpenStackServiceEndPoint>> regionServiceMap) {
        List<OpenStackServiceEndPoint> currentEndPointList;
        List<OpenStackServiceEndPoint> saveEndPointList;
        List<OpenStackServiceEndPoint> delEndPointList;
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty(regionServiceMap)) {
            logger.error((Object)("param is empty:openstackUuid=" + openstackUuid));
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, OpenStackRegion> regionMap = new HashMap<String, OpenStackRegion>();
        List<OpenStackRegion> regionList = this.getRegionFromDB(openstackUuid);
        long count = regionList.size() + regionServiceMap.size();
        if (count > 128L) {
            logger.error((Object)"Private cloud rule region quantity is more than [%s]", 128L);
            throw new SpecCheckedException("openstack_region_quantity", 128L, count);
        }
        if (!VerifyUtil.isEmpty(regionList)) {
            for (OpenStackRegion openStackRegion : regionList) {
                regionMap.put(OpenStackCommonUtil.getIdFromUuid(openStackRegion.getUuid()), openStackRegion);
            }
        }
        if (VerifyUtil.isEmpty(delEndPointList = this.getDelEndPointList(regionServiceMap, saveEndPointList = this.construecEndPointList(openstackUuid, regionServiceMap, regionMap), currentEndPointList = this.getEndPointFromDB(openstackUuid))) && VerifyUtil.isEmpty(saveEndPointList)) {
            logger.error((Object)"EndPointList is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.updateDb(saveEndPointList, delEndPointList);
        this.refreshEndpoint(saveEndPointList);
        this.openstackDependedCertificateService.registerOpenstackCert(this.getEndPointFromDB(openstackUuid));
        SDRRegisterHelper.getInstance().registerSDR();
    }

    private List<OpenStackServiceEndPoint> getDelEndPointList(Map<String, List<OpenStackServiceEndPoint>> regionServiceMap, List<OpenStackServiceEndPoint> saveEndPointList, List<OpenStackServiceEndPoint> currentEndPointList) {
        ArrayList<OpenStackServiceEndPoint> delEndPointList = new ArrayList<OpenStackServiceEndPoint>();
        if (!VerifyUtil.isEmpty(currentEndPointList)) {
            for (OpenStackServiceEndPoint endPoint : currentEndPointList) {
                if (!regionServiceMap.containsKey(OpenStackCommonUtil.getIdFromUuid(endPoint.getRegionUuid()))) continue;
                delEndPointList.add(endPoint);
            }
            if (currentEndPointList.size() - delEndPointList.size() + saveEndPointList.size() <= 0) {
                logger.error((Object)"can not delete all endPoint");
                throw new LegoCheckedException(1073947393L);
            }
        }
        return delEndPointList;
    }

    private void updateDb(List<OpenStackServiceEndPoint> saveEndPointList, List<OpenStackServiceEndPoint> delEndPointList) {
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (OpenStackServiceEndPoint delEndPoint : delEndPointList) {
                session.delete((Object)delEndPoint);
            }
            for (OpenStackServiceEndPoint saveEndPoint : saveEndPointList) {
                session.save((Object)saveEndPoint);
            }
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            logger.error((Object)("save AzPairs failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            DBOperationUtil.rollbackSession((Session)session);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    private void refreshEndpoint(List<OpenStackServiceEndPoint> endPointList) {
        HashMap<String, Map<String, String>> regionEndpointMap = new HashMap<String, Map<String, String>>();
        for (OpenStackServiceEndPoint endpoint : endPointList) {
            String regionUuid = endpoint.getRegionUuid();
            if (!regionEndpointMap.containsKey(regionUuid)) {
                HashMap endpointMap = new HashMap();
                regionEndpointMap.put(regionUuid, endpointMap);
            }
            Map map = (Map)regionEndpointMap.get(regionUuid);
            map.put(endpoint.getServiceType(), endpoint.getServiceUrl());
        }
        EndpointUtil.getInstance().refreshEndpointMap(regionEndpointMap);
    }

    private List<OpenStackServiceEndPoint> construecEndPointList(String openstackUuid, Map<String, List<OpenStackServiceEndPoint>> regionServiceMap, Map<String, OpenStackRegion> regionMap) {
        ArrayList<OpenStackServiceEndPoint> saveEndPointList = new ArrayList<OpenStackServiceEndPoint>();
        for (Map.Entry<String, List<OpenStackServiceEndPoint>> entry : regionServiceMap.entrySet()) {
            String regionId = entry.getKey();
            List<OpenStackServiceEndPoint> list = entry.getValue();
            if (VerifyUtil.isEmpty(list)) continue;
            OpenStackRegion openStackRegion = regionMap.get(regionId);
            if (VerifyUtil.isEmpty((Object)openStackRegion)) {
                logger.error((Object)("region not exist:" + regionId));
                throw new LegoCheckedException(1073947393L);
            }
            if (SERVICE_TYPE_SET.size() != list.size() && SERVICE_TYPE_SET.size() - 1 != list.size()) {
                logger.error((Object)("service size wrong:" + list.size()));
                throw new LegoCheckedException(1073947393L);
            }
            for (OpenStackServiceEndPoint endPoint : list) {
                String serviceId = UUIDGenerator.getUUID();
                endPoint.setServiceId(serviceId);
                endPoint.setUuid(OpenStackCommonUtil.getObjectUuid(openstackUuid, serviceId));
                endPoint.setRegionUuid(OpenStackCommonUtil.getObjectUuid(openstackUuid, regionId));
                if (!SERVICE_TYPE_SET.contains(endPoint.getServiceType())) {
                    logger.error((Object)("serviceType not exist:" + endPoint.getServiceType()));
                    throw new LegoCheckedException(1073947393L);
                }
                if (VerifyUtil.isEmpty((String)endPoint.getServiceUrl()) || !ParamChecker.checkUrl((String)endPoint.getServiceUrl())) {
                    logger.error((Object)("serviceUrl is null:" + endPoint));
                    throw new LegoCheckedException(1073947393L);
                }
                endPoint.setServiceUrl(IAMManager.getValidUrl(endPoint.getServiceUrl()));
                endPoint.setTopMoUuid(openstackUuid);
                endPoint.setParentMo((ManagedObject)openStackRegion);
                saveEndPointList.add(endPoint);
            }
        }
        return saveEndPointList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenStackVolTypeMapping> getVolTypeMappingsFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Criteria crit = session.createCriteria(OpenStackVolTypeMapping.class);
            crit.add((Criterion)Restrictions.like((String)"uuid", (Object)(openstackUuid + "%")));
            List list = crit.list();
            return list;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public List<OpenStackVolTypeMapping> getVolTypeMappingsFromDB() {
        List mappings = CommonDAOLocator.getMoDao().find("from OpenStackVolTypeMapping", new Object[0]);
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenStackAvailabilityZoneMapping> getAvailabilityZoneMappingsFromDB(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackUuid is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Criteria crit = session.createCriteria(OpenStackAvailabilityZoneMapping.class);
            crit.add((Criterion)Restrictions.like((String)"uuid", (Object)(openstackUuid + "%")));
            List list = crit.list();
            return list;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void saveAvailabilityZoneMappingInDB(OpenStackAvailabilityZoneMapping mapping) {
        if (VerifyUtil.isEmpty((Object)mapping)) {
            logger.error((Object)"param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            session.save((Object)mapping);
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            logger.error((Object)("save AzPairs failed." + e));
            DBOperationUtil.rollbackSession((Session)session);
            throw new LegoCheckedException(0x300001L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void deleteAvailabilityZoneMappingInDB(List<OpenStackAvailabilityZoneMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            for (OpenStackAvailabilityZoneMapping mapping : mappings) {
                session.delete((Object)mapping);
            }
            session.flush();
        }
        catch (HibernateException e) {
            logger.error((Object)("deleted AzPairs failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(2117645L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void saveVolTypeMappingInDB(List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (OpenStackVolTypeMapping mapping : mappings) {
                session.save((Object)mapping);
            }
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            logger.error((Object)("save voltypemapping failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            DBOperationUtil.rollbackSession((Session)session);
            throw new LegoCheckedException(0x300001L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void deleteVolTypeMappingInDB(List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            for (OpenStackVolTypeMapping mapping : mappings) {
                session.delete((Object)mapping);
            }
            session.flush();
        }
        catch (HibernateException e) {
            logger.error((Object)("deleted voltypemapping failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(2117645L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public List<OpenStackAvailabilityZoneMapping> getAvailabilityZoneMappingsFromDB() {
        List mappings = CommonDAOLocator.getMoDao().find("from OpenStackAvailabilityZoneMapping", new Object[0]);
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenStackAvailabilityZoneMapping getSlaveAzNameByAzPairInDB(String azName) {
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            Criteria crit = session.createCriteria(OpenStackAvailabilityZoneMapping.class);
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"primaryAz", (Object)azName), (Criterion)Restrictions.eq((String)"secondAz", (Object)azName)));
            List mappings = crit.list();
            if (VerifyUtil.isEmpty((Collection)mappings)) {
                logger.error((Object)"Az Pairs not exists in DB.");
                OpenStackAvailabilityZoneMapping openStackAvailabilityZoneMapping = null;
                return openStackAvailabilityZoneMapping;
            }
            OpenStackAvailabilityZoneMapping openStackAvailabilityZoneMapping = (OpenStackAvailabilityZoneMapping)mappings.get(0);
            return openStackAvailabilityZoneMapping;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public List<Map<String, Object>> getVHACSDRMapping(String regionId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E instanceType) {
        return OpenStackCommonUtil.getVHACSDRMapping(regionId, this, instanceType);
    }

    public void updateVolTypeMappingInDB(List<OpenStackVolTypeMapping> mappings) {
        if (VerifyUtil.isEmpty(mappings)) {
            logger.error((Object)"Update volumeType mapping failed.param is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Session session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (OpenStackVolTypeMapping mapping : mappings) {
                session.saveOrUpdate((Object)mapping);
            }
            session.flush();
            tx.commit();
        }
        catch (Exception e) {
            logger.error((Object)("update voltypemapping failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            DBOperationUtil.rollbackSession((Session)session);
            throw new LegoCheckedException(2117645L);
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }

    public void setOpenstackDependedCertificateService(OpenstackDependedCertificateService openstackDependedCertificateService) {
        this.openstackDependedCertificateService = openstackDependedCertificateService;
    }

    public JSONObject queryHwStackInfo() {
        IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
        List cloudInfraList = scOperation.queryCloudInfras();
        JSONObject hwStackInfoObject = new JSONObject();
        if (!VerifyUtil.isEmpty((Collection)cloudInfraList)) {
            JSONArray cloudInfraArray = new JSONArray();
            cloudInfraList.stream().forEach(cloudInfra -> cloudInfraArray.add((Object)this.convertCloudInfra((CloudInfra)cloudInfra)));
            hwStackInfoObject.put((Object)"cloudInfras", (Object)cloudInfraArray);
            this.queryProjects(hwStackInfoObject);
        }
        return hwStackInfoObject;
    }

    private void queryProjects(JSONObject hwStackInfoObject) {
        FusionSphereOpenStack fusionSphereOpenStack = OpenStackCommonUtil.getOpenstack();
        if (VerifyUtil.isEmpty((Object)fusionSphereOpenStack)) {
            return;
        }
        Map pgPropsMap = ProtectGroupUtil.getAllPgProps();
        HashSet<String> allProjectIdSet = new HashSet<String>();
        for (Map props : pgPropsMap.values()) {
            String drProjectId;
            String projectId = OpenStackCommonUtil.getIdFromUuid((String)props.get("projectId"));
            if (!VerifyUtil.isEmpty((String)projectId)) {
                allProjectIdSet.add(projectId);
            }
            if (VerifyUtil.isEmpty((String)(drProjectId = OpenStackCommonUtil.getIdFromUuid((String)props.get("drProjectId"))))) continue;
            allProjectIdSet.add(drProjectId);
        }
        List<OpenStackProject> allProjectList = this.getProjectFromDB(fusionSphereOpenStack.getUuid(), true);
        JSONArray projectArray = new JSONArray();
        allProjectList.forEach(project -> {
            String projectId = OpenStackCommonUtil.getIdFromUuid(project.getUuid());
            if (allProjectIdSet.contains(projectId)) {
                JSONObject projectObject = new JSONObject();
                projectObject.put((Object)"projectId", (Object)projectId);
                projectObject.put((Object)"projectName", (Object)project.getName());
                projectArray.add((Object)projectObject);
            }
        });
        if (projectArray.size() > 0) {
            hwStackInfoObject.put((Object)"projects", (Object)projectArray);
        }
    }

    private JSONObject convertCloudInfra(CloudInfra cloudInfra) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"regionId", (Object)cloudInfra.getRegionId());
        jsonObject.put((Object)"regionName", (Object)cloudInfra.getRegionName());
        IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
        List cloudAvailableZoneList = scOperation.queryAvailableZones(cloudInfra.getId());
        if (!VerifyUtil.isEmpty((Collection)cloudAvailableZoneList)) {
            JSONArray cloudAvailableZoneArray = new JSONArray();
            cloudAvailableZoneList.stream().forEach(cloudAvailableZone -> cloudAvailableZoneArray.add((Object)this.convertCloudAvailableZone((CloudAvailableZone)cloudAvailableZone)));
            jsonObject.put((Object)"availableZones", (Object)cloudAvailableZoneArray);
        }
        return jsonObject;
    }

    private JSONObject convertCloudAvailableZone(CloudAvailableZone cloudAvailableZone) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"azId", (Object)cloudAvailableZone.getAzId());
        jsonObject.put((Object)"azName", (Object)cloudAvailableZone.getName());
        return jsonObject;
    }

    public List<OpenstackMetaData> queryMeterInfos(String regionId, String serviceName, String startTime, String endTime) {
        List<MeterRecord> recordList = this.meterDao.queryMeterInfos(regionId, serviceName, startTime);
        HashMap recordMap = new HashMap();
        recordList.forEach(meterRecord -> {
            String instanceId = meterRecord.getInstanceId();
            String instanceType = meterRecord.getInstanceType();
            String meterType = meterRecord.getMeterType();
            String key = instanceId + ":" + instanceType + ":" + regionId + ":" + meterType;
            this.addToMap(recordMap, key, (MeterRecord)meterRecord);
        });
        ArrayList<OpenstackMetaData> resultList = new ArrayList<OpenstackMetaData>();
        recordMap.values().forEach(list -> {
            OpenstackMetaData metaData = this.buildMetaData((List<MeterRecord>)list, startTime, endTime);
            if (metaData != null) {
                resultList.add(metaData);
            }
        });
        return resultList;
    }

    private OpenstackMetaData buildMetaData(List<MeterRecord> recordList, String startTime, String endTime) {
        recordList.sort(Comparator.comparing(MeterRecord::getRecordTime));
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String lastTime = startTime;
        for (MeterRecord meterRecord : recordList) {
            String recordType = meterRecord.getRecordType();
            String recordTime = meterRecord.getRecordTime();
            if ("meter_create".equals(recordType)) {
                lastTime = recordTime.compareTo(startTime) >= 0 ? recordTime : endTime;
            } else {
                HashMap<String, String> metaMap = new HashMap<String, String>();
                String resultEndTime = recordTime.compareTo(endTime) <= 0 ? recordTime : endTime;
                metaMap.put(META_START_KEY, lastTime);
                metaMap.put(META_END_KEY, resultEndTime);
                metaMap.put(META_VALUE_KEY, meterRecord.getMeterValue());
                result.add(metaMap);
                lastTime = resultEndTime;
            }
            if (recordTime.compareTo(endTime) <= 0) continue;
            break;
        }
        if (VerifyUtil.isEmpty(result)) {
            return null;
        }
        String resultStartTime = (String)((Map)result.get(0)).get(META_START_KEY);
        String resultEndTime = (String)((Map)result.get(result.size() - 1)).get(META_END_KEY);
        double totalMetaValue = this.calcTotalMetaValue(result);
        MeterRecord meterRecord = recordList.get(0);
        OpenstackMetaData metaData = new OpenstackMetaData();
        metaData.setTimestamp(resultStartTime);
        metaData.setUserId(meterRecord.getProjectId());
        metaData.setRegionId(meterRecord.getRegionId());
        metaData.setCloudServiceType(meterRecord.getInstanceType());
        metaData.setResourceType(meterRecord.getMeterType());
        metaData.setResourceId(meterRecord.getInstanceId() + meterRecord.getMeterType());
        metaData.setBeginTime(resultStartTime);
        metaData.setEndTime(resultEndTime);
        metaData.setAccumulateFactorName("Duration");
        metaData.setAccumulateFactorValue(String.valueOf(3600));
        metaData.setExtendParams("display_name:" + meterRecord.getInstanceName() + "," + totalMetaValue);
        return metaData;
    }

    private double calcTotalMetaValue(List<Map<String, String>> result) {
        if (VerifyUtil.isEmpty(result)) {
            return 0.0;
        }
        double totalMetaValue = 0.0;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        long totalInterval = 0L;
        for (Map<String, String> metaMap : result) {
            try {
                long beginInterval = format.parse(metaMap.get(META_START_KEY)).getTime();
                long endInterval = format.parse(metaMap.get(META_END_KEY)).getTime();
                long interval = endInterval - beginInterval;
                double meterValue = Double.parseDouble(metaMap.get(META_VALUE_KEY));
                totalMetaValue += meterValue * (double)interval;
                totalInterval += interval;
            }
            catch (ParseException e) {
                logger.error((Object)"Build meter error.");
                throw new LegoCheckedException("Build meter error.");
            }
        }
        return totalMetaValue / (double)totalInterval;
    }

    private void addToMap(Map<String, List<MeterRecord>> recordMap, String key, MeterRecord value) {
        if (recordMap.containsKey(key)) {
            recordMap.get(key).add(value);
        } else {
            ArrayList<MeterRecord> list = new ArrayList<MeterRecord>();
            list.add(value);
            recordMap.put(key, list);
        }
    }

    public void updateMeterInstName(String instId, String instName) {
        this.meterDao.updateMeterRecord(instId, instName);
    }
}

