/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.sdk.service.IGalaxSiteResService;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class OpenstackSiteResourceServiceImpl
implements IGalaxSiteResService {
    private static Log logger = LogFactory.getInstance(OpenstackSiteResourceServiceImpl.class);

    public void registerResource(Site site, String[] resSns) {
        if (null == site) {
            throw new LegoCheckedException(1073947393L);
        }
        if (0 == site.getSiteType() && VerifyUtil.isEmpty((Object[])resSns)) {
            return;
        }
        switch (site.getSiteType()) {
            case 0: {
                this.saveOpentackIntoDB(site, resSns);
                break;
            }
            case 1: {
                this.registerOpenstackOfRemoteSite(site);
                break;
            }
            default: {
                logger.error((Object)("the type is error:" + site.getSiteType()), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOpentackIntoDB(Site site, String[] resSns) {
        if (VerifyUtil.isEmpty((Object)site) || VerifyUtil.isEmpty((Object[])resSns)) {
            return;
        }
        ArrayList<Object> drOpenstacks = new ArrayList<Object>(resSns.length);
        ArrayList<DrResource> drChilds = new ArrayList<DrResource>();
        HashMap<String, String[]> props = new HashMap<String, String[]>();
        props.put("sn", resSns);
        List networkList = CommonDAOLocator.getMoDao().findMoBy(NetworkEntity.class, props);
        if (networkList.size() != resSns.length) {
            logger.error((Object)"the entity is not existed:", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        for (NetworkEntity network : networkList) {
            if (!(network instanceof FusionSphereOpenStack)) continue;
            if (null != ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(network.getSn(), "ism.drm.deviceType.fusionsphere.mainType")) {
                logger.error((Object)("the openstack has been registered:" + network.getSn()), 90160758787071L);
                throw new LegoCheckedException(1073947671L);
            }
            DrFusionSphereOpenStack drOpenstack = (DrFusionSphereOpenStack)this.getDrResourceByMo(network);
            drOpenstack.setSiteId(site.getSiteId());
            for (DrResource child : drOpenstack.getChildResources()) {
                child.setSiteId(site.getSiteId());
                drChilds.add(child);
            }
            drOpenstacks.add(drOpenstack);
        }
        Session session = null;
        Transaction t = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            t = session.beginTransaction();
            for (DrResource drResource : drOpenstacks) {
                session.saveOrUpdate((Object)drResource);
            }
            for (DrResource drResource : drChilds) {
                session.save((Object)drResource);
            }
            t.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Batch save resource failed.", (long)-1L, null, (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void registerOpenstackOfRemoteSite(Site site) {
        logger.debug((Object)"registerVsphereCentersOfRemoteSite start");
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        List oldOpenstacks = baseDao.getHibernateTemplate().find("from DrFusionSphereOpenStack where siteId=?", new Object[]{site.getSiteId()});
        if (null != oldOpenstacks) {
            for (DrFusionSphereOpenStack oldOpen : oldOpenstacks) {
                for (DrResource resource : oldOpen.getChildResources()) {
                    baseDao.getHibernateTemplate().delete((Object)resource);
                }
            }
        }
        baseDao.getHibernateTemplate().deleteAll((Collection)oldOpenstacks);
        List<DrFusionSphereOpenStack> drOpenstackList = this.getDrOpenstackOfRemoteSite(site);
        for (DrFusionSphereOpenStack drOpen : drOpenstackList) {
            if (SiteResourceManagerUtil.isResourceExists((String)drOpen.getDeviceSn())) continue;
            Set childresources = drOpen.getChildResources();
            baseDao.getHibernateTemplate().saveOrUpdate((Object)drOpen);
            for (DrResource resource : childresources) {
                resource.setParentDrResource((DrResource)drOpen);
                baseDao.getHibernateTemplate().saveOrUpdate((Object)resource);
            }
        }
    }

    private List<DrFusionSphereOpenStack> getDrOpenstackOfRemoteSite(Site site) {
        logger.debug((Object)"getVsphereCentersOfRemoteSite start");
        RestClient client = SiteUtil.initClient((Site)site);
        String url = "/ws/sites/{siteId}/resources?resType=".replace("{siteId}", site.getSiteId()) + "ism.drm.deviceType.fusionsphere.mainType";
        ArrayList<DrFusionSphereOpenStack> drOpenstacks = new ArrayList<DrFusionSphereOpenStack>();
        String responseString = client.getSerializableObject(url);
        if (VerifyUtil.isEmpty((String)responseString)) {
            return drOpenstacks;
        }
        List objects = (List)DrmObjectSerializableUtil.reverseeObj((String)responseString, List.class);
        for (Object object : objects) {
            drOpenstacks.add((DrFusionSphereOpenStack)object);
        }
        return drOpenstacks;
    }

    public void refreshResouce(Site site) {
    }

    public DrResource getDrResourceByMo(NetworkEntity mo) {
        if (null == mo) {
            return null;
        }
        FusionSphereOpenStack ne = (FusionSphereOpenStack)mo;
        DrFusionSphereOpenStack drOpen = new DrFusionSphereOpenStack();
        drOpen.setDeviceSn(ne.getSn());
        drOpen.setIpAddress(ne.getLinkIp());
        drOpen.setName(ne.getName());
        drOpen.setStatus(String.valueOf(ne.getStatus()));
        drOpen.setDbId(UUIDGenerator.getUUID());
        return drOpen;
    }

    public DrResource getDrResourceBySn(String devSN) {
        logger.debug((Object)"getDrResourceBySn start");
        List drOpenstacks = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFusionSphereOpenStack where deviceSn=?", new Object[]{devSN});
        if (null != drOpenstacks && !drOpenstacks.isEmpty()) {
            return (DrResource)drOpenstacks.get(0);
        }
        return null;
    }

    public List<DrResource> getDrResourceBySite(Integer siteType) {
        List drOpenstacks = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFusionSphereOpenStack where siteId in (select siteId from Site where siteType = ?)", new Object[]{siteType});
        return drOpenstacks;
    }

    public List<DrResource> getDrResourceBySite(String siteId) {
        logger.debug((Object)("getDrResourceBySite start:siteId=" + siteId));
        List drOpenstacks = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFusionSphereOpenStack where siteId=?", new Object[]{siteId});
        return drOpenstacks;
    }

    public void checkDrResouceUsed(String siteId, String devSn) {
        this.isOpenstackUsed(devSn);
    }

    public String getResourceSubType() {
        return "ism.drm.deviceType.fusionsphereopenstack.subType";
    }

    private void isOpenstackUsed(String uuid) {
        String hql = "from ProtectGroup as pg where poProviderSN = ?";
        List pgs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{uuid});
        if (null != pgs && !pgs.isEmpty()) {
            logger.error((Object)("Openstack(" + uuid + ") has been used by protectgroup.Failed to unRegister."), 90160777660712L);
            throw new LegoCheckedException(1073947710L);
        }
    }
}

