/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource.authentication;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.openstack.adapter.handler.OpenStackResponseHandler;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class AuthenticationHelper {
    private static AuthenticationHelper authHelper = new AuthenticationHelper();
    private static final String KEYSTONE_POLICY_JSON_NAME = "/auth/keystone_policy.json";
    private static final String IAM_POLICY_JSON_NAME = "/auth/iam_policy.json";
    private static final String JSON_KEY = "policy";
    private static final Log logger = LogFactory.getInstance(AuthenticationHelper.class);
    private static final String ENCODEING = "UTF-8";
    private static final int REST_STATUS_SUCCESS_CODE = 200;
    private static int defaultConnTimeout = 30000;
    private List<PolicyMapping> policyList = new ArrayList<PolicyMapping>();

    public static AuthenticationHelper getInstance() {
        return authHelper;
    }

    public String decodeIAMToken(String token, String signingCert) {
        if (VerifyUtil.isEmpty((String)token) || VerifyUtil.isEmpty((String)signingCert)) {
            logger.error((Object)"Token or signingCert is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            CMSSignedData lSignedData = this.getSignedDataFromRawToken(token);
            SignerInformationVerifier lVerifier = this.createTokenVerifier(signingCert);
            if (!this.isValidTokenSignature(lSignedData, lVerifier)) {
                logger.error((Object)"lSignedData error or lVerifier error");
                throw new LegoCheckedException("token is not match signingcert");
            }
            return this.getTokenContentAsString(lSignedData);
        }
        catch (CMSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (IOException e2) {
            this.handleException(e2);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    public String decodeKeystoneToken(String token) {
        if (VerifyUtil.isEmpty((String)token)) {
            logger.error((Object)"token is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            OpenstackInfo open = this.getOpenstackInfo();
            String url = "https://" + open.getIp() + ":" + open.getPort() + OpenstackEnumDefine.REQUEST_URL.IDENTITY_TOKEN.getUri();
            String unscopeToken = TokenUtil.getInstance().getTokenId(open, null);
            ServiceResponse response = this.sendGet(url, this.getHeaders(unscopeToken, token));
            if (200 == response.getStatusCode()) {
                return response.getResponseString();
            }
        }
        catch (MalformedURLException e1) {
            this.handleException(e1);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    private SignerInformationVerifier createTokenVerifier(String aInSigningCertificate) throws IOException, OperatorCreationException {
        BufferedReader lCertBufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(aInSigningCertificate.getBytes(ENCODEING)), ENCODEING));
        PemReader pemReader = new PemReader((Reader)lCertBufferedReader);
        if (VerifyUtil.isEmpty((Object)pemReader)) {
            throw new LegoCheckedException("certificate is not correct");
        }
        PemObject lPemObj = pemReader.readPemObject();
        BcRSASignerInfoVerifierBuilder signerInfoBuilder = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider());
        if (VerifyUtil.isEmpty((Object)lPemObj)) {
            throw new LegoCheckedException("certificate is not correct");
        }
        SignerInformationVerifier lVerifier = signerInfoBuilder.build(new X509CertificateHolder(lPemObj.getContent()));
        return lVerifier;
    }

    private CMSSignedData getSignedDataFromRawToken(String lRawKeystoneToken) throws CMSException, UnsupportedEncodingException {
        String lRealTokenData = lRawKeystoneToken.replace("-", "/");
        byte[] lData = Base64.decodeBase64((byte[])lRealTokenData.getBytes(ENCODEING));
        CMSSignedData lSignedData = new CMSSignedData(lData);
        return lSignedData;
    }

    private String getTokenContentAsString(CMSSignedData aInSignedData) throws UnsupportedEncodingException {
        Object lObj = aInSignedData.getSignedContent().getContent();
        if (lObj instanceof byte[]) {
            String lObjString = new String((byte[])lObj, ENCODEING);
            return lObjString;
        }
        logger.error((Object)"getTokenContentAsString return null");
        return null;
    }

    private boolean isValidTokenSignature(CMSSignedData aInSignedData, SignerInformationVerifier aInVerifier) throws CMSException {
        SignerInformationStore lSignerInfo = aInSignedData.getSignerInfos();
        Collection lSigners = lSignerInfo.getSigners();
        for (Object lObj : lSigners) {
            SignerInformation lSigner;
            boolean lIsValid;
            if (!(lObj instanceof SignerInformation) || !(lIsValid = (lSigner = (SignerInformation)lObj).verify(aInVerifier))) continue;
            return true;
        }
        return false;
    }

    public synchronized List<PolicyMapping> getPolicyMappingList() {
        if (VerifyUtil.isEmpty(this.policyList)) {
            OpenstackInfo open = this.getOpenstackInfo();
            String path = open.isUseIAM() ? IAM_POLICY_JSON_NAME : KEYSTONE_POLICY_JSON_NAME;
            String policyJson = this.readJson(path);
            JSONArray array = JSONObject.fromObject((Object)policyJson).getJSONArray(JSON_KEY);
            this.policyList = JSONArray.toCollection((JSONArray)array, PolicyMapping.class);
        }
        return this.policyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readJson(String path) {
        if (VerifyUtil.isEmpty((String)path)) {
            logger.error((Object)"policy.json path is not correct.");
            throw new LegoCheckedException("policy.json path is not correct.");
        }
        InputStreamReader reader = null;
        StringBuilder result = new StringBuilder();
        InputStream is = null;
        try {
            int tempchar;
            is = AuthenticationHelper.class.getResourceAsStream(path);
            reader = new InputStreamReader(is, ENCODEING);
            while ((tempchar = ((Reader)reader).read()) != -1) {
                result.append((char)tempchar);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)("readJson policy.json failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
                ExceptionUtil.rethrowException((Throwable)e, (String)("readJson policy.json failed:" + path), (long)0x300001L, null, (Log)logger);
            }
            catch (Throwable throwable) {
                CommonUtil.close(reader);
                CommonUtil.close((Closeable)is);
                throw throwable;
            }
            CommonUtil.close((Closeable)reader);
            CommonUtil.close((Closeable)is);
        }
        CommonUtil.close((Closeable)reader);
        CommonUtil.close((Closeable)is);
        return result.toString();
    }

    public ServiceResponse sendGet(String url, Map<String, String> headers) throws MalformedURLException {
        URL urlObj = new URL(url);
        String newUrlStr = urlObj.getPath();
        if (!VerifyUtil.isEmpty((String)urlObj.getQuery())) {
            newUrlStr = newUrlStr + "?" + urlObj.getQuery();
        }
        RestClient client = this.getClient(urlObj, defaultConnTimeout);
        return client.get(newUrlStr, null, headers);
    }

    public OpenstackInfo getOpenstackInfo() {
        FusionSphereOpenStack openStack = this.getOpenstack();
        long moId = openStack.getMoId();
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend extend = neMgr.findByMoId(Long.valueOf(moId));
        if (VerifyUtil.isEmpty((Object)extend)) {
            logger.error((Object)("cant find openstack ne extend info :moId=" + moId));
            throw new LegoCheckedException(1073947393L);
        }
        Map paramMap = extend.getExtendParams();
        OpenstackInfo openInfo = new OpenstackInfo();
        openInfo.setIp(openStack.getIpAddress());
        openInfo.setPort((String)paramMap.get("port"));
        openInfo.setDomainName((String)paramMap.get("domain"));
        openInfo.setUser(extend.getNetworkUserName());
        openInfo.setPasswd(extend.getNetworkPassword());
        String isIam = (String)paramMap.get("authType");
        openInfo.setUseIAM("IAM".equals(isIam));
        return openInfo;
    }

    private FusionSphereOpenStack getOpenstack() {
        List openstackList = CommonDAOLocator.getMoDao().getAllMo(FusionSphereOpenStack.class);
        if (VerifyUtil.isEmpty((Collection)openstackList)) {
            logger.error((Object)"openstack instance is not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        FusionSphereOpenStack openstack = (FusionSphereOpenStack)CommonUtil.getFirstElement((Collection)openstackList);
        String ipTemp = openstack.getIpAddress();
        if (AddressUtil.ipType((String)ipTemp).equals("IPV6")) {
            openstack.setIpAddress(Ipv6AddressUtil.formatIPv6((String)ipTemp));
        }
        return openstack;
    }

    private RestClient getClient(URL urlObj, int timeout) {
        String host = urlObj.getHost();
        int port = urlObj.getPort();
        RestClient client = new RestClient(host, port, null, null, (IResponseHandler)new OpenStackResponseHandler(), new String[0]);
        client.setTimeout(timeout);
        return client;
    }

    public Map<String, String> getHeaders(String tokenId) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-auth-token", tokenId);
        return headers;
    }

    public Map<String, String> getHeaders(String authToken, String subjectToken) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-auth-token", authToken);
        headers.put("x-subject-token", subjectToken);
        return headers;
    }

    private void handleException(Exception e) {
        logger.error((Object)("decode token error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        ExceptionUtil.rethrowException((Throwable)e, (String)"decode token error.", (long)1073947691L, null, (Log)logger);
    }

    public static final class PolicyMapping {
        @JsonProperty(value="uri-pattern")
        private String uriPattern;
        private String method;
        @JsonProperty(value="operation_name")
        private String operationName;
        private String role;
        @JsonProperty(value="log_level")
        private String logLevel;
        @JsonProperty(value="need-check-scope")
        private boolean needCheckScope;

        public String getUriPattern() {
            return this.uriPattern;
        }

        public String getMethod() {
            return this.method;
        }

        public String getRole() {
            return this.role;
        }

        public boolean isNeedCheckScope() {
            return this.needCheckScope;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String getLogLevel() {
            return this.logLevel;
        }
    }
}

